/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.InMemoryJAASConfiguration;
import org.apache.ranger.audit.utils.KerberosAction;
import org.apache.ranger.audit.utils.KerberosJAASConfigUser;
import org.apache.ranger.audit.utils.KerberosUser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrAuditDestination
extends AuditDestination {
    private static final Logger LOG = LoggerFactory.getLogger(SolrAuditDestination.class);
    public static final String PROP_SOLR_URLS = "urls";
    public static final String PROP_SOLR_ZK = "zookeepers";
    public static final String PROP_SOLR_COLLECTION = "collection";
    public static final String PROP_SOLR_FORCE_USE_INMEMORY_JAAS_CONFIG = "force.use.inmemory.jaas.config";
    public static final String DEFAULT_COLLECTION_NAME = "ranger_audits";
    public static final String PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    private volatile SolrClient solrClient;
    private volatile KerberosUser kerberosUser;

    public void init(Properties props, String propPrefix) {
        LOG.info("init() called");
        super.init(props, propPrefix);
        this.init();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        KerberosUser kerberosUser;
        LOG.info("SolrAuditDestination.stop() called..");
        this.logStatus();
        SolrClient solrClient = this.solrClient;
        if (solrClient != null) {
            try {
                solrClient.close();
            }
            catch (IOException ioe) {
                LOG.error("Error while stopping solr!", (Throwable)ioe);
            }
            finally {
                this.solrClient = null;
            }
        }
        if ((kerberosUser = this.kerberosUser) != null) {
            try {
                kerberosUser.logout();
            }
            catch (LoginException excp) {
                LOG.error("Error logging out keytab user", (Throwable)excp);
            }
            finally {
                this.kerberosUser = null;
            }
        }
    }

    public void flush() {
    }

    public boolean log(Collection<AuditEventBase> events) {
        boolean ret;
        block8: {
            ret = false;
            try {
                this.logStatusIfRequired();
                this.addTotalCount(events.size());
                SolrClient solrClient = this.solrClient;
                if (solrClient == null) {
                    this.connect();
                    solrClient = this.solrClient;
                    if (solrClient == null) {
                        this.addDeferredCount(events.size());
                        return ret;
                    }
                }
                ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
                for (AuditEventBase event : events) {
                    AuthzAuditEvent authzEvent = (AuthzAuditEvent)event;
                    SolrInputDocument document = this.toSolrDoc(authzEvent);
                    docs.add(document);
                }
                try {
                    UpdateResponse response = this.addDocsToSolr(solrClient, docs);
                    if (response.getStatus() != 0) {
                        this.addFailedCount(events.size());
                        this.logFailedEvent(events, response.toString());
                        break block8;
                    }
                    this.addSuccessCount(events.size());
                    ret = true;
                }
                catch (SolrException ex) {
                    this.addFailedCount(events.size());
                    this.logFailedEvent(events, ex);
                }
            }
            catch (Throwable t) {
                this.addDeferredCount(events.size());
                this.logError("Error sending message to Solr", t);
            }
        }
        return ret;
    }

    public boolean isAsync() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void connect() {
        SolrClient me = this.solrClient;
        if (me != null) return;
        Class<SolrAuditDestination> clazz = SolrAuditDestination.class;
        synchronized (SolrAuditDestination.class) {
            String collectionName;
            String urls;
            TrustManager[] tmList;
            me = this.solrClient;
            if (me != null) return;
            KeyManager[] kmList = this.getKeyManagers();
            SSLContext sslContext = this.getSSLContext(kmList, tmList = this.getTrustManagers());
            if (sslContext != null) {
                SSLContext.setDefault(sslContext);
            }
            if ((urls = MiscUtil.getStringProperty((Properties)this.props, (String)(this.propPrefix + "." + PROP_SOLR_URLS))) != null) {
                urls = urls.trim();
            }
            if (urls != null && urls.equalsIgnoreCase("NONE")) {
                urls = null;
            }
            List solrURLs = MiscUtil.toArray((String)urls, (String)",");
            String zkHosts = MiscUtil.getStringProperty((Properties)this.props, (String)(this.propPrefix + "." + PROP_SOLR_ZK));
            if (zkHosts != null && zkHosts.equalsIgnoreCase("NONE")) {
                zkHosts = null;
            }
            if ((collectionName = MiscUtil.getStringProperty((Properties)this.props, (String)(this.propPrefix + "." + PROP_SOLR_COLLECTION))) == null || collectionName.equalsIgnoreCase("none")) {
                collectionName = DEFAULT_COLLECTION_NAME;
            }
            LOG.info("Solr zkHosts={}, solrURLs={}, collectionName={}", new Object[]{zkHosts, urls, collectionName});
            if (zkHosts != null && !zkHosts.isEmpty()) {
                LOG.info("Connecting to solr cloud using zkHosts={}", (Object)zkHosts);
                try {
                    Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();
                    SolrHttpClientBuilder kb = krbBuild.getBuilder();
                    HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)kb);
                    ArrayList<String> zkhosts = new ArrayList<String>(Arrays.asList(zkHosts.split(",")));
                    CloudSolrClient solrCloudClient = (CloudSolrClient)MiscUtil.executePrivilegedAction(() -> new CloudSolrClient.Builder(zkhosts, Optional.empty()).build());
                    solrCloudClient.setDefaultCollection(collectionName);
                    this.solrClient = me = solrCloudClient;
                }
                catch (Throwable t) {
                    LOG.error("Can't connect to Solr server. ZooKeepers={}", (Object)zkHosts, (Object)t);
                }
            } else {
                if (solrURLs == null || solrURLs.isEmpty()) return;
                try {
                    Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();
                    LOG.info("Connecting to Solr using URLs={}", (Object)solrURLs);
                    SolrHttpClientBuilder kb = krbBuild.getBuilder();
                    HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)kb);
                    List solrUrls = solrURLs;
                    LBHttpSolrClient lbSolrClient = (LBHttpSolrClient)MiscUtil.executePrivilegedAction(() -> {
                        LBHttpSolrClient.Builder builder = new LBHttpSolrClient.Builder();
                        builder.withBaseSolrUrl((String)solrUrls.get(0));
                        builder.withConnectionTimeout(1000);
                        return builder.build();
                    });
                    for (int i = 1; i < solrURLs.size(); ++i) {
                        lbSolrClient.addSolrServer((String)solrURLs.get(i));
                    }
                    this.solrClient = me = lbSolrClient;
                }
                catch (Throwable t) {
                    LOG.error("Can't connect to Solr server. URL={}", (Object)solrURLs, (Object)t);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    SolrInputDocument toSolrDoc(AuthzAuditEvent auditEvent) {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField("id", (Object)auditEvent.getEventId());
        doc.addField("access", (Object)auditEvent.getAccessType());
        doc.addField("enforcer", (Object)auditEvent.getAclEnforcer());
        doc.addField("agent", (Object)auditEvent.getAgentId());
        doc.addField("repo", (Object)auditEvent.getRepositoryName());
        doc.addField("sess", (Object)auditEvent.getSessionId());
        doc.addField("reqUser", (Object)auditEvent.getUser());
        doc.addField("reqData", (Object)auditEvent.getRequestData());
        doc.addField("resource", (Object)auditEvent.getResourcePath());
        doc.addField("cliIP", (Object)auditEvent.getClientIP());
        doc.addField("logType", (Object)auditEvent.getLogType());
        doc.addField("result", (Object)auditEvent.getAccessResult());
        doc.addField("policy", (Object)auditEvent.getPolicyId());
        doc.addField("repoType", (Object)auditEvent.getRepositoryType());
        doc.addField("resType", (Object)auditEvent.getResourceType());
        doc.addField("reason", (Object)auditEvent.getResultReason());
        doc.addField("action", (Object)auditEvent.getAction());
        doc.addField("evtTime", (Object)auditEvent.getEventTime());
        doc.addField("seq_num", (Object)auditEvent.getSeqNum());
        doc.setField("event_count", (Object)auditEvent.getEventCount());
        doc.setField("event_dur_ms", (Object)auditEvent.getEventDurationMS());
        doc.setField("tags", (Object)auditEvent.getTags());
        doc.addField("datasets", (Object)auditEvent.getDatasets());
        doc.addField("projects", (Object)auditEvent.getProjects());
        doc.setField("cluster", (Object)auditEvent.getClusterName());
        doc.setField("zoneName", (Object)auditEvent.getZoneName());
        doc.setField("agentHost", (Object)auditEvent.getAgentHostname());
        doc.setField("policyVersion", (Object)auditEvent.getPolicyVersion());
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        LOG.info("==>SolrAuditDestination.init()");
        try {
            String confFileName = System.getProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG);
            LOG.info("In solrAuditDestination.init() : JAAS Configuration set as [{}]", (Object)confFileName);
            if (System.getProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG) == null) {
                if (MiscUtil.getBooleanProperty((Properties)this.props, (String)(this.propPrefix + "." + PROP_SOLR_FORCE_USE_INMEMORY_JAAS_CONFIG), (boolean)false)) {
                    System.setProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG, "/dev/null");
                } else {
                    LOG.warn("No Client JAAS config present in solr audit config. Ranger Audit to Kerberized Solr will fail...");
                }
            }
            LOG.info("Loading SolrClient JAAS config from Ranger audit config if present...");
            InMemoryJAASConfiguration conf = InMemoryJAASConfiguration.init((Properties)this.props);
            KerberosJAASConfigUser kerberosUser = new KerberosJAASConfigUser("Client", (Configuration)conf);
            if (kerberosUser.getPrincipal() != null) {
                this.kerberosUser = kerberosUser;
            }
        }
        catch (Exception e) {
            LOG.error("ERROR: Unable to load SolrClient JAAS config from Audit config file. Audit to Kerberized Solr will fail...", (Throwable)e);
        }
        finally {
            String confFileName = System.getProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG);
            LOG.info("In solrAuditDestination.init() (finally) : JAAS Configuration set as [{}]", (Object)confFileName);
        }
        LOG.info("<==SolrAuditDestination.init()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] getKeyManagers() {
        KeyManager[] kmList = null;
        String credentialProviderPath = MiscUtil.getStringProperty((Properties)this.props, (String)"xasecure.policymgr.clientssl.keystore.credential.file");
        String keyStoreAlias = "sslKeyStore";
        String keyStoreFile = MiscUtil.getStringProperty((Properties)this.props, (String)"xasecure.policymgr.clientssl.keystore");
        String keyStoreFilepwd = MiscUtil.getCredentialString((String)credentialProviderPath, (String)keyStoreAlias);
        if (StringUtils.isNotEmpty((String)keyStoreFile) && StringUtils.isNotEmpty((String)keyStoreFilepwd)) {
            InputStream in = null;
            try {
                in = this.getFileInputStream(keyStoreFile);
                if (in != null) {
                    String keyStoreType = MiscUtil.getStringProperty((Properties)this.props, (String)"xasecure.policymgr.clientssl.keystore.type");
                    keyStoreType = StringUtils.isNotEmpty((String)keyStoreType) ? keyStoreType : "jks";
                    KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                    keyStore.load(in, keyStoreFilepwd.toCharArray());
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(RANGER_SSL_KEYMANAGER_ALGO_TYPE);
                    keyManagerFactory.init(keyStore, keyStoreFilepwd.toCharArray());
                    kmList = keyManagerFactory.getKeyManagers();
                } else {
                    LOG.error("Unable to obtain keystore from file [{}]", (Object)keyStoreFile);
                }
            }
            catch (KeyStoreException e) {
                LOG.error("Unable to obtain from KeyStore :{}", (Object)e.getMessage(), (Object)e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("SSL algorithm is NOT available in the environment", (Throwable)e);
            }
            catch (CertificateException e) {
                LOG.error("Unable to obtain the requested certification ", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOG.error("Unable to find the necessary SSL Keystore Files", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("Unable to read the necessary SSL Keystore Files", (Throwable)e);
            }
            catch (UnrecoverableKeyException e) {
                LOG.error("Unable to recover the key from keystore", (Throwable)e);
            }
            finally {
                this.close(in, keyStoreFile);
            }
        }
        return kmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManager[] getTrustManagers() {
        TrustManager[] tmList = null;
        String credentialProviderPath = MiscUtil.getStringProperty((Properties)this.props, (String)"xasecure.policymgr.clientssl.truststore.credential.file");
        String trustStoreAlias = "sslTrustStore";
        String trustStoreFile = MiscUtil.getStringProperty((Properties)this.props, (String)"xasecure.policymgr.clientssl.truststore");
        String trustStoreFilepwd = MiscUtil.getCredentialString((String)credentialProviderPath, (String)trustStoreAlias);
        if (StringUtils.isNotEmpty((String)trustStoreFile) && StringUtils.isNotEmpty((String)trustStoreFilepwd)) {
            InputStream in = null;
            try {
                in = this.getFileInputStream(trustStoreFile);
                if (in != null) {
                    String trustStoreType = MiscUtil.getStringProperty((Properties)this.props, (String)"xasecure.policymgr.clientssl.truststore.type");
                    trustStoreType = StringUtils.isNotEmpty((String)trustStoreType) ? trustStoreType : "jks";
                    KeyStore trustStore = KeyStore.getInstance(trustStoreType);
                    trustStore.load(in, trustStoreFilepwd.toCharArray());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(RANGER_SSL_TRUSTMANAGER_ALGO_TYPE);
                    trustManagerFactory.init(trustStore);
                    tmList = trustManagerFactory.getTrustManagers();
                } else {
                    LOG.error("Unable to obtain truststore from file [{}]", (Object)trustStoreFile);
                }
            }
            catch (KeyStoreException e) {
                LOG.error("Unable to obtain from KeyStore", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("SSL algorithm is NOT available in the environment :{}", (Object)e.getMessage(), (Object)e);
            }
            catch (CertificateException e) {
                LOG.error("Unable to obtain the requested certification :{}", (Object)e.getMessage(), (Object)e);
            }
            catch (FileNotFoundException e) {
                LOG.error("Unable to find the necessary SSL TrustStore File:{}", (Object)trustStoreFile, (Object)e);
            }
            catch (IOException e) {
                LOG.error("Unable to read the necessary SSL TrustStore Files :{}", (Object)trustStoreFile, (Object)e);
            }
            finally {
                this.close(in, trustStoreFile);
            }
        }
        return tmList;
    }

    private SSLContext getSSLContext(KeyManager[] kmList, TrustManager[] tmList) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            if (sslContext != null) {
                sslContext.init(kmList, tmList, new SecureRandom());
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("SSL algorithm is not available in the environment", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOG.error("Unable to initialise the SSLContext", (Throwable)e);
        }
        return sslContext;
    }

    private UpdateResponse addDocsToSolr(SolrClient solrClient, Collection<SolrInputDocument> docs) throws Exception {
        UpdateResponse ret;
        PrivilegedExceptionAction<UpdateResponse> action = () -> solrClient.add(docs);
        if (this.kerberosUser != null) {
            KerberosAction kerberosAction = new KerberosAction(this.kerberosUser, action, LOG);
            ret = (UpdateResponse)kerberosAction.execute();
        } else {
            ret = action.run();
        }
        return ret;
    }

    private InputStream getFileInputStream(String fileName) throws IOException {
        InputStream in = null;
        if (StringUtils.isNotEmpty((String)fileName)) {
            File file = new File(fileName);
            in = file.exists() ? new FileInputStream(file) : ClassLoader.getSystemResourceAsStream(fileName);
        }
        return in;
    }

    private void close(InputStream str, String filename) {
        if (str != null) {
            try {
                str.close();
            }
            catch (IOException excp) {
                LOG.error("Error while closing file: [{}]", (Object)filename, (Object)excp);
            }
        }
    }
}

