/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.function.Factory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.credutils.CredentialsProviderUtil;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.OpenRequest;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Transport;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchAuditDestination
extends AuditDestination {
    public static final String CONFIG_URLS = "urls";
    public static final String CONFIG_PORT = "port";
    public static final String CONFIG_USER = "user";
    public static final String CONFIG_PWRD = "password";
    public static final String CONFIG_PROTOCOL = "protocol";
    public static final String CONFIG_INDEX = "index";
    public static final String CONFIG_PREFIX = "ranger.audit.opensearch";
    public static final String DEFAULT_INDEX = "ranger_audits";
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchAuditDestination.class);
    private final AtomicLong lastLoggedAt = new AtomicLong(0L);
    private String index = "index";
    private volatile OpenSearchClient client = null;
    private String protocol;
    private String user;
    private int port;
    private String password;
    private String hosts;
    private Subject subject;

    public OpenSearchAuditDestination() {
        this.propPrefix = CONFIG_PREFIX;
    }

    public void init(Properties props, String propPrefix) {
        super.init(props, propPrefix);
        this.protocol = this.getStringProperty(props, propPrefix + "." + CONFIG_PROTOCOL, "https");
        this.user = this.getStringProperty(props, propPrefix + "." + CONFIG_USER, "");
        this.password = this.getStringProperty(props, propPrefix + "." + CONFIG_PWRD, "");
        this.port = MiscUtil.getIntProperty((Properties)props, (String)(propPrefix + "." + CONFIG_PORT), (int)9200);
        this.index = this.getStringProperty(props, propPrefix + "." + CONFIG_INDEX, DEFAULT_INDEX);
        this.hosts = this.getHosts();
        LOG.info("Connecting to OpenSearch: " + this.connectionString());
        this.getClient();
    }

    private String connectionString() {
        return String.format(Locale.ROOT, "User:%s, %s://%s:%s/%s", this.user, this.protocol, this.hosts, this.port, this.index);
    }

    public void stop() {
        super.stop();
        this.logStatus();
    }

    public boolean log(Collection<AuditEventBase> events) {
        boolean ret = false;
        try {
            this.logStatusIfRequired();
            this.addTotalCount(events.size());
            OpenSearchClient client = this.getClient();
            if (null == client) {
                this.addDeferredCount(events.size());
                return ret;
            }
            ArrayList<AuditEventBase> eventList = new ArrayList<AuditEventBase>(events);
            BulkRequest.Builder br = new BulkRequest.Builder();
            try {
                for (AuditEventBase event : eventList) {
                    AuthzAuditEvent authzEvent = (AuthzAuditEvent)event;
                    String id = authzEvent.getEventId();
                    Map<String, Object> doc = this.toDoc(authzEvent);
                    br.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(this.index)).id(id)).document((Object)doc)));
                }
            }
            catch (Exception ex) {
                this.addFailedCount(eventList.size());
                this.logFailedEvent(eventList, ex);
            }
            BulkResponse response = client.bulk(br.build());
            if (response.errors()) {
                this.addFailedCount(eventList.size());
                StringBuilder err = new StringBuilder();
                for (BulkResponseItem item : response.items()) {
                    if (item.error() == null) continue;
                    err.append(item.error().reason());
                }
                this.logFailedEvent(eventList, "HTTP " + err);
            } else {
                List items = response.items();
                for (int i = 0; i < items.size(); ++i) {
                    AuditEventBase itemRequest = eventList.get(i);
                    BulkResponseItem itemResponse = (BulkResponseItem)items.get(i);
                    if (itemResponse.error() != null) {
                        this.addFailedCount(1);
                        this.logFailedEvent(Arrays.asList(itemRequest), itemResponse.error().reason());
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Indexed %s", itemRequest.getEventKey()));
                    }
                    this.addSuccessCount(1);
                    ret = true;
                }
            }
        }
        catch (Throwable t) {
            this.addDeferredCount(events.size());
            this.logError("Error sending message to OpenSearch", t);
        }
        return ret;
    }

    public void flush() {
    }

    public boolean isAsync() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    synchronized OpenSearchClient getClient() {
        if (this.client == null) {
            Class<OpenSearchAuditDestination> clazz = OpenSearchAuditDestination.class;
            // MONITORENTER : org.apache.ranger.audit.destination.OpenSearchAuditDestination.class
            if (this.client == null) {
                this.client = this.newClient();
            }
            // MONITOREXIT : clazz
        }
        if (this.subject == null) return this.client;
        KerberosTicket ticket = CredentialsProviderUtil.getTGT((Subject)this.subject);
        try {
            if (new Date().getTime() > ticket.getEndTime().getTime()) {
                this.client = null;
                CredentialsProviderUtil.ticketExpireTime80 = 0L;
                this.newClient();
                return this.client;
            }
            if (CredentialsProviderUtil.ticketWillExpire((KerberosTicket)ticket) == false) return this.client;
            this.subject = CredentialsProviderUtil.login((String)this.user, (String)this.password);
            return this.client;
        }
        catch (PrivilegedActionException e) {
            LOG.error("PrivilegedActionException:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private OpenSearchClient newClient() {
        try {
            HttpHost host = new HttpHost("https", "obdp3-node3", 9220);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(host), (Credentials)new UsernamePasswordCredentials("admin", "admin".toCharArray()));
            SSLContext sslcontext = SSLContextBuilder.create().loadTrustMaterial(null, (chains, authType) -> true).build();
            ApacheHttpClient5TransportBuilder builder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])new HttpHost[]{host});
            builder.setHttpClientConfigCallback(httpClientBuilder -> {
                TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(sslcontext).setTlsDetailsFactory((Factory)new Factory<SSLEngine, TlsDetails>(){

                    public TlsDetails create(SSLEngine sslEngine) {
                        return new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol());
                    }
                }).build();
                PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build();
                return httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setConnectionManager((AsyncClientConnectionManager)connectionManager);
            });
            ApacheHttpClient5Transport transport = builder.build();
            OpenSearchClient esClient = new OpenSearchClient((OpenSearchTransport)transport);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initialized client");
            }
            if (!esClient.indices().exists(r -> r.index(this.index, new String[0])).value()) {
                LOG.info("Creating index {}", (Object)this.index);
                IndexSettings settings = new IndexSettings.Builder().numberOfShards(Integer.valueOf(2)).numberOfReplicas(Integer.valueOf(1)).build();
                CreateIndexRequest createIndexRequest = new CreateIndexRequest.Builder().index(this.index).settings(settings).build();
                esClient.indices().create(createIndexRequest);
            }
            boolean exits = false;
            try {
                exits = esClient.indices().open(new OpenRequest.Builder().index(this.index, new String[0]).build()).shardsAcknowledged();
            }
            catch (Exception e) {
                LOG.warn("Error validating index " + this.index);
            }
            if (exits) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Index exists");
                }
            } else {
                LOG.info("Index does not exist");
            }
            return esClient;
        }
        catch (Throwable t) {
            this.lastLoggedAt.updateAndGet(lastLoggedAt -> {
                long now = System.currentTimeMillis();
                long elapsed = now - lastLoggedAt;
                if (elapsed > TimeUnit.MINUTES.toMillis(1L)) {
                    LOG.error("Can't connect to OpenSearch server: " + this.connectionString(), t);
                    return now;
                }
                return lastLoggedAt;
            });
            return null;
        }
    }

    private String getHosts() {
        String urls = MiscUtil.getStringProperty((Properties)this.props, (String)(this.propPrefix + "." + CONFIG_URLS));
        if (urls != null) {
            urls = urls.trim();
        }
        if ("NONE".equalsIgnoreCase(urls)) {
            urls = null;
        }
        return urls;
    }

    private String getStringProperty(Properties props, String propName, String defaultValue) {
        String value = MiscUtil.getStringProperty((Properties)props, (String)propName);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    Map<String, Object> toDoc(AuthzAuditEvent auditEvent) {
        HashMap<String, Object> doc = new HashMap<String, Object>();
        doc.put("id", auditEvent.getEventId());
        doc.put("access", auditEvent.getAccessType());
        doc.put("enforcer", auditEvent.getAclEnforcer());
        doc.put("agent", auditEvent.getAgentId());
        doc.put("repo", auditEvent.getRepositoryName());
        doc.put("sess", auditEvent.getSessionId());
        doc.put("reqUser", auditEvent.getUser());
        doc.put("reqData", auditEvent.getRequestData());
        doc.put("resource", auditEvent.getResourcePath());
        doc.put("cliIP", auditEvent.getClientIP());
        doc.put("logType", auditEvent.getLogType());
        doc.put("result", auditEvent.getAccessResult());
        doc.put("policy", auditEvent.getPolicyId());
        doc.put("repoType", auditEvent.getRepositoryType());
        doc.put("resType", auditEvent.getResourceType());
        doc.put("reason", auditEvent.getResultReason());
        doc.put("action", auditEvent.getAction());
        doc.put("evtTime", auditEvent.getEventTime());
        doc.put("seq_num", auditEvent.getSeqNum());
        doc.put("event_count", auditEvent.getEventCount());
        doc.put("event_dur_ms", auditEvent.getEventDurationMS());
        doc.put("tags", auditEvent.getTags());
        doc.put("cluster", auditEvent.getClusterName());
        doc.put("zoneName", auditEvent.getZoneName());
        doc.put("agentHost", auditEvent.getAgentHostname());
        doc.put("policyVersion", auditEvent.getPolicyVersion());
        return doc;
    }
}

