/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.util.Collection;
import java.util.Properties;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4jAuditProvider
extends AuditDestination {
    private static final Logger LOG = LoggerFactory.getLogger(Log4jAuditProvider.class);
    private static final Logger AUDITLOG = LoggerFactory.getLogger((String)("xaaudit." + Log4jAuditProvider.class.getName()));

    public Log4jAuditProvider() {
        LOG.info("Log4jAuditProvider: creating..");
    }

    public boolean log(AuditEventBase event) {
        if (!AUDITLOG.isInfoEnabled()) {
            return true;
        }
        if (event != null) {
            String eventStr = MiscUtil.stringify((Object)event);
            AUDITLOG.info(eventStr);
        }
        return true;
    }

    public boolean logJSON(String event) {
        AuditEventBase eventObj = (AuditEventBase)MiscUtil.fromJson((String)event, AuthzAuditEvent.class);
        return this.log(eventObj);
    }

    public boolean logJSON(Collection<String> events) {
        for (String event : events) {
            this.logJSON(event);
        }
        return true;
    }

    public void init(Properties props) {
        LOG.info("Log4jAuditProvider.init()");
        super.init(props);
    }

    public boolean log(Collection<AuditEventBase> events) {
        for (AuditEventBase event : events) {
            this.log(event);
        }
        return true;
    }

    public void start() {
    }

    public void stop() {
    }
}

