/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.util.Collection;
import java.util.Properties;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.MiscUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4JAuditDestination
extends AuditDestination {
    private static final Logger logger = LoggerFactory.getLogger(Log4JAuditDestination.class);
    private static Logger auditLogger;
    public static final String PROP_LOG4J_LOGGER = "logger";
    public static final String DEFAULT_LOGGER_PREFIX = "ranger.audit";

    public Log4JAuditDestination() {
        logger.info("Log4JAuditDestination() called.");
    }

    public void init(Properties prop, String propPrefix) {
        super.init(prop, propPrefix);
        String loggerName = MiscUtil.getStringProperty((Properties)this.props, (String)(propPrefix + "." + PROP_LOG4J_LOGGER));
        if (loggerName == null || loggerName.isEmpty()) {
            loggerName = "ranger.audit." + this.getName();
            logger.info("Logger property {}.{} was not set. Constructing default={}", new Object[]{propPrefix, PROP_LOG4J_LOGGER, loggerName});
        }
        logger.info("Logger name for {} is {}", (Object)this.getName(), (Object)loggerName);
        auditLogger = LoggerFactory.getLogger((String)loggerName);
        logger.info("Done initializing logger for audit. name={}, loggerName={}", (Object)this.getName(), (Object)loggerName);
    }

    public void stop() {
        super.stop();
        this.logStatus();
    }

    public boolean log(AuditEventBase event) {
        if (!auditLogger.isInfoEnabled()) {
            this.logStatusIfRequired();
            this.addTotalCount(1);
            return true;
        }
        if (event != null) {
            String eventStr = MiscUtil.stringify((Object)event);
            this.logJSON(eventStr);
        }
        return true;
    }

    public boolean logJSON(String event) {
        this.logStatusIfRequired();
        this.addTotalCount(1);
        if (!auditLogger.isInfoEnabled()) {
            return true;
        }
        if (event != null) {
            auditLogger.info(event);
            this.addSuccessCount(1);
        }
        return true;
    }

    public boolean logJSON(Collection<String> events) {
        if (!auditLogger.isInfoEnabled()) {
            this.logStatusIfRequired();
            this.addTotalCount(events.size());
            return true;
        }
        for (String event : events) {
            this.logJSON(event);
        }
        return false;
    }

    public boolean log(Collection<AuditEventBase> events) {
        if (!auditLogger.isInfoEnabled()) {
            this.logStatusIfRequired();
            this.addTotalCount(events.size());
            return true;
        }
        for (AuditEventBase event : events) {
            this.log(event);
        }
        return true;
    }
}

