/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.audit.provider.AuditMessageException;
import org.apache.ranger.audit.provider.DebugTracer;
import org.apache.ranger.audit.provider.LogBuffer;
import org.apache.ranger.audit.provider.LogDestination;
import org.apache.ranger.audit.provider.MiscUtil;

public class LocalFileLogBuffer<T>
implements LogBuffer<T> {
    private String mDirectory;
    private String mFile;
    private int mFlushIntervalSeconds = 60;
    private int mFileBufferSizeBytes = 8192;
    private String mEncoding;
    private boolean mIsAppend = true;
    private int mRolloverIntervalSeconds = 600;
    private String mArchiveDirectory;
    private int mArchiveFileCount = 10;
    private final DebugTracer mLogger;
    private Writer mWriter;
    private String mBufferFilename;
    private long mNextRolloverTime;
    private long mNextFlushTime;
    private final int mFileOpenRetryIntervalInMs = 60000;
    private long mNextFileOpenRetryTime;
    private DestinationDispatcherThread<T> mDispatcherThread;

    public LocalFileLogBuffer(DebugTracer tracer) {
        this.mLogger = tracer;
    }

    public String getDirectory() {
        return this.mDirectory;
    }

    public void setDirectory(String directory) {
        this.mDirectory = directory;
    }

    public String getFile() {
        return this.mFile;
    }

    public void setFile(String file) {
        this.mFile = file;
    }

    public int getFileBufferSizeBytes() {
        return this.mFileBufferSizeBytes;
    }

    public void setFileBufferSizeBytes(int fileBufferSizeBytes) {
        this.mFileBufferSizeBytes = fileBufferSizeBytes;
    }

    public int getFlushIntervalSeconds() {
        return this.mFlushIntervalSeconds;
    }

    public void setFlushIntervalSeconds(int flushIntervalSeconds) {
        this.mFlushIntervalSeconds = flushIntervalSeconds;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String encoding) {
        this.mEncoding = encoding;
    }

    public boolean getIsAppend() {
        return this.mIsAppend;
    }

    public void setIsAppend(boolean isAppend) {
        this.mIsAppend = isAppend;
    }

    public int getRolloverIntervalSeconds() {
        return this.mRolloverIntervalSeconds;
    }

    public void setRolloverIntervalSeconds(int rolloverIntervalSeconds) {
        this.mRolloverIntervalSeconds = rolloverIntervalSeconds;
    }

    public String getArchiveDirectory() {
        return this.mArchiveDirectory;
    }

    public void setArchiveDirectory(String archiveDirectory) {
        this.mArchiveDirectory = archiveDirectory;
    }

    public int getArchiveFileCount() {
        return this.mArchiveFileCount;
    }

    public void setArchiveFileCount(int archiveFileCount) {
        this.mArchiveFileCount = archiveFileCount;
    }

    public void start(LogDestination<T> destination) {
        this.mLogger.debug("==> LocalFileLogBuffer.start()");
        this.mDispatcherThread = new DestinationDispatcherThread<T>(this, destination, this.mLogger);
        this.mDispatcherThread.setDaemon(true);
        this.mDispatcherThread.start();
        this.mLogger.debug("<== LocalFileLogBuffer.start()");
    }

    public void stop() {
        this.mLogger.debug("==> LocalFileLogBuffer.stop()");
        DestinationDispatcherThread<T> dispatcherThread = this.mDispatcherThread;
        this.mDispatcherThread = null;
        if (dispatcherThread != null && dispatcherThread.isAlive()) {
            dispatcherThread.stopThread();
            try {
                dispatcherThread.join();
            }
            catch (InterruptedException e) {
                this.mLogger.warn("LocalFileLogBuffer.stop(): failed in waiting for DispatcherThread", (Throwable)e);
            }
        }
        this.closeFile();
        this.mLogger.debug("<== LocalFileLogBuffer.stop()");
    }

    public boolean isAvailable() {
        return this.mWriter != null;
    }

    public boolean isEmpty() {
        return this.mDispatcherThread == null || this.mDispatcherThread.isIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T log) {
        boolean ret = false;
        String msg = MiscUtil.stringify(log);
        if (msg.contains(MiscUtil.LINE_SEPARATOR)) {
            msg = msg.replace(MiscUtil.LINE_SEPARATOR, "\\" + MiscUtil.LINE_SEPARATOR);
        }
        LocalFileLogBuffer localFileLogBuffer = this;
        synchronized (localFileLogBuffer) {
            this.checkFileStatus();
            Writer writer = this.mWriter;
            if (writer != null) {
                try {
                    writer.write(msg + MiscUtil.LINE_SEPARATOR);
                    if (this.mFileBufferSizeBytes == 0) {
                        writer.flush();
                    }
                    ret = true;
                }
                catch (IOException excp) {
                    this.mLogger.warn("LocalFileLogBuffer.add(): write failed", (Throwable)excp);
                    this.closeFile();
                }
            }
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LocalFileLogBuffer {");
        sb.append("Directory=").append(this.mDirectory).append("; ");
        sb.append("File=").append(this.mFile).append("; ");
        sb.append("RolloverIntervaSeconds=").append(this.mRolloverIntervalSeconds).append("; ");
        sb.append("ArchiveDirectory=").append(this.mArchiveDirectory).append("; ");
        sb.append("ArchiveFileCount=").append(this.mArchiveFileCount);
        sb.append("}");
        return sb.toString();
    }

    boolean isCurrentFilename(String filename) {
        return filename != null && filename.equals(this.mBufferFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void openFile() {
        this.mLogger.debug("==> LocalFileLogBuffer.openFile()");
        long now = System.currentTimeMillis();
        this.closeFile();
        if (this.mNextFileOpenRetryTime <= now) {
            try {
                this.mNextRolloverTime = MiscUtil.getNextRolloverTime((long)this.mNextRolloverTime, (long)((long)this.mRolloverIntervalSeconds * 1000L));
                long startTime = MiscUtil.getRolloverStartTime((long)this.mNextRolloverTime, (long)((long)this.mRolloverIntervalSeconds * 1000L));
                this.mBufferFilename = MiscUtil.replaceTokens((String)(this.mDirectory + File.separator + this.mFile), (long)startTime);
                MiscUtil.createParents((File)new File(this.mBufferFilename));
                FileOutputStream ostream = null;
                try {
                    ostream = new FileOutputStream(this.mBufferFilename, this.mIsAppend);
                }
                catch (Exception excp) {
                    this.mLogger.warn("LocalFileLogBuffer.openFile(): failed to open file " + this.mBufferFilename, (Throwable)excp);
                }
                if (ostream != null) {
                    this.mWriter = this.createWriter(ostream);
                    this.mLogger.debug("LocalFileLogBuffer.openFile(): opened file " + this.mBufferFilename);
                    this.mNextFlushTime = System.currentTimeMillis() + (long)this.mFlushIntervalSeconds * 1000L;
                } else {
                    this.mLogger.warn("LocalFileLogBuffer.openFile(): failed to open file for write " + this.mBufferFilename);
                    this.mBufferFilename = null;
                }
            }
            finally {
                if (this.mWriter == null) {
                    this.mNextFileOpenRetryTime = now + 60000L;
                }
            }
        }
        this.mLogger.debug("<== LocalFileLogBuffer.openFile()");
    }

    private synchronized void closeFile() {
        this.mLogger.debug("==> LocalFileLogBuffer.closeFile()");
        Writer writer = this.mWriter;
        this.mWriter = null;
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException excp) {
                this.mLogger.warn("LocalFileLogBuffer: failed to close file " + this.mBufferFilename, (Throwable)excp);
            }
            if (this.mDispatcherThread != null) {
                this.mDispatcherThread.addLogfile(this.mBufferFilename);
            }
        }
        this.mLogger.debug("<== LocalFileLogBuffer.closeFile()");
    }

    private void rollover() {
        this.mLogger.debug("==> LocalFileLogBuffer.rollover()");
        this.closeFile();
        this.openFile();
        this.mLogger.debug("<== LocalFileLogBuffer.rollover()");
    }

    private void checkFileStatus() {
        long now = System.currentTimeMillis();
        if (now > this.mNextRolloverTime) {
            this.rollover();
        } else if (this.mWriter == null) {
            this.openFile();
        } else if (now > this.mNextFlushTime) {
            try {
                this.mNextFlushTime = now + (long)this.mFlushIntervalSeconds * 1000L;
                this.mWriter.flush();
            }
            catch (IOException excp) {
                this.mLogger.warn("LocalFileLogBuffer: failed to flush to file " + this.mBufferFilename, (Throwable)excp);
            }
        }
    }

    private Writer createWriter(OutputStream os) {
        Writer writer = null;
        if (os != null) {
            if (this.mEncoding != null) {
                try {
                    writer = new OutputStreamWriter(os, this.mEncoding);
                }
                catch (UnsupportedEncodingException excp) {
                    this.mLogger.warn("LocalFileLogBuffer: failed to create output writer for file " + this.mBufferFilename, (Throwable)excp);
                }
            }
            if (writer == null) {
                writer = new OutputStreamWriter(os);
            }
            if (this.mFileBufferSizeBytes > 0) {
                writer = new BufferedWriter(writer, this.mFileBufferSizeBytes);
            }
        }
        return writer;
    }

    static class DestinationDispatcherThread<T>
    extends Thread {
        private final TreeSet<String> mCompletedLogfiles = new TreeSet();
        private final LocalFileLogBuffer<T> mFileLogBuffer;
        private final LogDestination<T> mDestination;
        private final DebugTracer mLogger;
        private String mCurrentLogfile;
        private boolean mStopThread;

        public DestinationDispatcherThread(LocalFileLogBuffer<T> fileLogBuffer, LogDestination<T> destination, DebugTracer tracer) {
            super(DestinationDispatcherThread.class.getSimpleName() + "-" + System.currentTimeMillis());
            this.mLogger = tracer;
            this.mFileLogBuffer = fileLogBuffer;
            this.mDestination = destination;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLogfile(String filename) {
            this.mLogger.debug("==> DestinationDispatcherThread.addLogfile(" + filename + ")");
            if (filename != null) {
                TreeSet<String> treeSet = this.mCompletedLogfiles;
                synchronized (treeSet) {
                    this.mCompletedLogfiles.add(filename);
                    this.mCompletedLogfiles.notifyAll();
                }
            }
            this.mLogger.debug("<== DestinationDispatcherThread.addLogfile(" + filename + ")");
        }

        public void stopThread() {
            this.mStopThread = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isIdle() {
            TreeSet<String> treeSet = this.mCompletedLogfiles;
            synchronized (treeSet) {
                return this.mCompletedLogfiles.isEmpty() && this.mCurrentLogfile == null;
            }
        }

        @Override
        public void run() {
            UserGroupInformation loginUser = null;
            try {
                loginUser = UserGroupInformation.getLoginUser();
            }
            catch (IOException excp) {
                this.mLogger.error("DestinationDispatcherThread.run(): failed to get login user details. Audit files will not be sent to HDFS destination", (Throwable)excp);
            }
            if (loginUser == null) {
                this.mLogger.error("DestinationDispatcherThread.run(): failed to get login user. Audit files will not be sent to HDFS destination");
                return;
            }
            try {
                loginUser.doAs(() -> {
                    this.doRun();
                    return 0;
                });
            }
            catch (Exception excp) {
                this.mLogger.error("DestinationDispatcherThread.run(): failed", (Throwable)excp);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DestinationDispatcherThread {");
            sb.append("ThreadName=").append(this.getName()).append("; ");
            sb.append("CompletedLogfiles.size()=").append(this.mCompletedLogfiles.size()).append("; ");
            sb.append("StopThread=").append(this.mStopThread).append("; ");
            sb.append("CurrentLogfile=").append(this.mCurrentLogfile);
            sb.append("}");
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() {
            this.init();
            this.mDestination.start();
            long pollIntervalInMs = 1000L;
            while (!this.mStopThread) {
                TreeSet<String> treeSet = this.mCompletedLogfiles;
                synchronized (treeSet) {
                    while (this.mCompletedLogfiles.isEmpty() && !this.mStopThread) {
                        try {
                            this.mCompletedLogfiles.wait(pollIntervalInMs);
                        }
                        catch (InterruptedException excp) {
                            throw new RuntimeException("DestinationDispatcherThread.run(): failed to wait for log file", excp);
                        }
                    }
                    this.mCurrentLogfile = this.mCompletedLogfiles.pollFirst();
                }
                if (this.mCurrentLogfile == null) continue;
                this.sendCurrentFile();
            }
            this.mDestination.stop();
        }

        private void init() {
            File[] files;
            File directory;
            this.mLogger.debug("==> DestinationDispatcherThread.init()");
            String dirName = MiscUtil.replaceTokens((String)this.mFileLogBuffer.getDirectory(), (long)0L);
            if (dirName != null && (directory = new File(dirName)).exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
                for (File file : files) {
                    String filename;
                    if (!file.exists() || !file.isFile() || !file.canRead() || this.mFileLogBuffer.isCurrentFilename(filename = file.getAbsolutePath())) continue;
                    this.addLogfile(filename);
                }
            }
            this.mLogger.debug("<== DestinationDispatcherThread.init()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean sendCurrentFile() {
            this.mLogger.debug("==> DestinationDispatcherThread.sendCurrentFile()");
            boolean ret = false;
            long destinationPollIntervalInMs = 1000L;
            BufferedReader reader = this.openCurrentFile();
            try {
                while (!this.mStopThread) {
                    String log = this.getNextStringifiedLog(reader);
                    if (log == null) {
                        ret = true;
                        break;
                    }
                    try {
                        while (!this.mStopThread && !this.mDestination.sendStringified(log)) {
                            try {
                                Thread.sleep(destinationPollIntervalInMs);
                            }
                            catch (InterruptedException excp) {
                                throw new RuntimeException("LocalFileLogBuffer.sendCurrentFile(" + this.mCurrentLogfile + "): failed while waiting for destination to be available", excp);
                            }
                        }
                    }
                    catch (AuditMessageException msgError) {
                        this.mLogger.error("Error in log message:" + log);
                    }
                }
            }
            finally {
                this.closeCurrentFile(reader);
            }
            if (!this.mStopThread) {
                this.mDestination.flush();
                this.archiveCurrentFile();
            }
            this.mLogger.debug("<== DestinationDispatcherThread.sendCurrentFile()");
            return ret;
        }

        private String getNextStringifiedLog(BufferedReader mReader) {
            String log = null;
            if (mReader != null) {
                try {
                    String line;
                    while ((line = mReader.readLine()) != null) {
                        if (line.endsWith("\\")) {
                            line = line.substring(0, line.length() - "\\".length());
                            if (log == null) {
                                log = line;
                                continue;
                            }
                            log = log + MiscUtil.LINE_SEPARATOR;
                            log = log + line;
                            continue;
                        }
                        log = log == null ? line : log + line;
                        break;
                    }
                }
                catch (IOException excp) {
                    this.mLogger.warn("getNextStringifiedLog.getNextLog(): failed to read from file " + this.mCurrentLogfile, (Throwable)excp);
                }
            }
            return log;
        }

        private BufferedReader openCurrentFile() {
            this.mLogger.debug("==> openCurrentFile(" + this.mCurrentLogfile + ")");
            BufferedReader mReader = null;
            if (this.mCurrentLogfile != null) {
                try {
                    FileInputStream inStr = new FileInputStream(this.mCurrentLogfile);
                    InputStreamReader strReader = this.createReader(inStr);
                    if (strReader != null) {
                        mReader = new BufferedReader(strReader);
                    }
                }
                catch (FileNotFoundException excp) {
                    this.mLogger.warn("openNextFile(): error while opening file " + this.mCurrentLogfile, (Throwable)excp);
                }
            }
            this.mLogger.debug("<== openCurrentFile(" + this.mCurrentLogfile + ")");
            return mReader;
        }

        private void closeCurrentFile(BufferedReader mReader) {
            this.mLogger.debug("==> closeCurrentFile(" + this.mCurrentLogfile + ")");
            if (mReader != null) {
                try {
                    mReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.mLogger.debug("<== closeCurrentFile(" + this.mCurrentLogfile + ")");
        }

        private void archiveCurrentFile() {
            if (this.mCurrentLogfile != null) {
                File logFile = new File(this.mCurrentLogfile);
                String archiveDirName = MiscUtil.replaceTokens((String)this.mFileLogBuffer.getArchiveDirectory(), (long)0L);
                String archiveFilename = archiveDirName + File.separator + logFile.getName();
                try {
                    if (logFile.exists()) {
                        File archiveDir;
                        File[] files;
                        int numOfFilesToDelete;
                        File archiveFile = new File(archiveFilename);
                        MiscUtil.createParents((File)archiveFile);
                        if (!logFile.renameTo(archiveFile)) {
                            this.mLogger.warn("archiving failed to move file: " + this.mCurrentLogfile + " ==> " + archiveFilename);
                        }
                        int n = numOfFilesToDelete = (files = (archiveDir = new File(archiveDirName)).listFiles(File::isFile)) == null ? 0 : files.length - this.mFileLogBuffer.getArchiveFileCount();
                        if (numOfFilesToDelete > 0) {
                            Arrays.sort(files, (f1, f2) -> (int)(f1.lastModified() - f2.lastModified()));
                            for (int i = 0; i < numOfFilesToDelete; ++i) {
                                if (files[i].delete()) continue;
                                this.mLogger.warn("archiving failed to delete file: " + files[i].getAbsolutePath());
                            }
                        }
                    }
                }
                catch (Exception excp) {
                    this.mLogger.warn("archiveCurrentFile(): faile to move " + this.mCurrentLogfile + " to archive location " + archiveFilename, (Throwable)excp);
                }
            }
            this.mCurrentLogfile = null;
        }

        private InputStreamReader createReader(InputStream iStr) {
            InputStreamReader reader = null;
            if (iStr != null) {
                String encoding = this.mFileLogBuffer.getEncoding();
                if (encoding != null) {
                    try {
                        reader = new InputStreamReader(iStr, encoding);
                    }
                    catch (UnsupportedEncodingException excp) {
                        this.mLogger.warn("createReader(): failed to create input reader.", (Throwable)excp);
                    }
                }
                if (reader == null) {
                    reader = new InputStreamReader(iStr);
                }
            }
            return reader;
        }
    }
}

