/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.RangerAuditWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditWriterFactory {
    private static final Logger logger = LoggerFactory.getLogger(AuditWriterFactory.class);
    public static final String AUDIT_FILETYPE_DEFAULT = "json";
    public static final String AUDIT_JSON_FILEWRITER_IMPL = "org.apache.ranger.audit.utils.RangerJSONAuditWriter";
    public static final String AUDIT_ORC_FILEWRITER_IMPL = "org.apache.ranger.audit.utils.RangerORCAuditWriter";
    private static volatile AuditWriterFactory me;
    public Map<String, String> auditConfigs;
    public Properties props;
    public String propPrefix;
    public String auditProviderName;
    public RangerAuditWriter auditWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditWriterFactory getInstance() {
        AuditWriterFactory auditWriter = me;
        if (auditWriter != null) return auditWriter;
        Class<AuditWriterFactory> clazz = AuditWriterFactory.class;
        synchronized (AuditWriterFactory.class) {
            auditWriter = me;
            if (auditWriter != null) return auditWriter;
            me = auditWriter = new AuditWriterFactory();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return auditWriter;
        }
    }

    public void init(Properties props, String propPrefix, String auditProviderName, Map<String, String> auditConfigs) throws Exception {
        logger.debug("==> AuditWriterFactory.init()");
        this.props = props;
        this.propPrefix = propPrefix;
        this.auditProviderName = auditProviderName;
        this.auditConfigs = auditConfigs;
        String auditFileType = MiscUtil.getStringProperty(props, propPrefix + ".batch.filequeue.filetype", AUDIT_FILETYPE_DEFAULT);
        String writerClass = MiscUtil.getStringProperty(props, propPrefix + ".filewriter.impl");
        RangerAuditWriter rangerAuditWriter = this.auditWriter = StringUtils.isEmpty((String)writerClass) ? this.createWriter(this.getDefaultWriter(auditFileType)) : this.createWriter(writerClass);
        if (this.auditWriter != null) {
            this.auditWriter.init(props, propPrefix, auditProviderName, auditConfigs);
            logger.debug("<== AuditWriterFactory.init() :{}", (Object)this.auditWriter.getClass().getName());
        }
    }

    public RangerAuditWriter createWriter(String writerClass) throws Exception {
        logger.debug("==> AuditWriterFactory.createWriter()");
        Class<?> cls = Class.forName(writerClass);
        RangerAuditWriter ret = (RangerAuditWriter)cls.newInstance();
        logger.debug("<== AuditWriterFactory.createWriter()");
        return ret;
    }

    public String getDefaultWriter(String auditFileType) {
        String ret;
        logger.debug("==> AuditWriterFactory.getDefaultWriter()");
        switch (auditFileType) {
            case "orc": {
                ret = AUDIT_ORC_FILEWRITER_IMPL;
                break;
            }
            case "json": {
                ret = AUDIT_JSON_FILEWRITER_IMPL;
                break;
            }
            default: {
                ret = null;
            }
        }
        logger.debug("<== AuditWriterFactory.getDefaultWriter() :{}", (Object)ret);
        return ret;
    }

    public RangerAuditWriter getAuditWriter() {
        return this.auditWriter;
    }
}

