/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MultiDestAuditProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAuditProvider
extends MultiDestAuditProvider
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncAuditProvider.class);
    private static final int mStopLoopIntervalSecs = 1;
    private static final int mWaitToCompleteLoopIntervalSecs = 1;
    private static int sThreadCount;
    private final BlockingQueue<AuditEventBase> mQueue;
    private final String mName;
    private final AtomicLong lifeTimeInLogCount = new AtomicLong(0L);
    private final AtomicLong lifeTimeOutLogCount = new AtomicLong(0L);
    private final AtomicLong lifeTimeDropCount = new AtomicLong(0L);
    private final AtomicLong intervalInLogCount = new AtomicLong(0L);
    private final AtomicLong intervalOutLogCount = new AtomicLong(0L);
    private final AtomicLong intervalDropCount = new AtomicLong(0L);
    private Thread mThread;
    private int mMaxQueueSize = 10240;
    private int mMaxFlushInterval = 5000;
    private long lastIntervalLogTime = System.currentTimeMillis();
    private int intervalLogDurationMS = 60000;
    private long lastFlushTime = System.currentTimeMillis();

    public AsyncAuditProvider(String name, int maxQueueSize, int maxFlushInterval) {
        LOG.info("AsyncAuditProvider({}): creating..", (Object)name);
        if (maxQueueSize < 1) {
            LOG.warn("AsyncAuditProvider({}): invalid maxQueueSize={}. will use default {}", new Object[]{name, maxQueueSize, this.mMaxQueueSize});
            maxQueueSize = this.mMaxQueueSize;
        }
        this.mName = name;
        this.mMaxQueueSize = maxQueueSize;
        this.mMaxFlushInterval = maxFlushInterval;
        this.mQueue = new ArrayBlockingQueue<AuditEventBase>(this.mMaxQueueSize);
    }

    public AsyncAuditProvider(String name, int maxQueueSize, int maxFlushInterval, AuditHandler provider) {
        this(name, maxQueueSize, maxFlushInterval);
        this.addAuditProvider(provider);
    }

    @Override
    public void init(Properties props) {
        LOG.info("AsyncAuditProvider({}).init()", (Object)this.mName);
        super.init(props);
    }

    @Override
    public boolean log(AuditEventBase event) {
        LOG.debug("AsyncAuditProvider.logEvent(AuditEventBase)");
        this.queueEvent(event);
        return true;
    }

    @Override
    public void start() {
        this.mThread = new Thread((Runnable)this, "AsyncAuditProvider" + ++sThreadCount);
        this.mThread.setDaemon(true);
        this.mThread.start();
        super.start();
    }

    @Override
    public void stop() {
        LOG.info("==> AsyncAuditProvider.stop()");
        try {
            LOG.info("Interrupting child thread of {}...", (Object)this.mName);
            this.mThread.interrupt();
            while (this.mThread.isAlive()) {
                try {
                    LOG.info("Waiting for child thread of {} to exit.  Sleeping for {} secs", (Object)this.mName, (Object)1);
                    this.mThread.join(1000L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while waiting for child thread to join!  Proceeding with stop", (Throwable)e);
                    break;
                }
            }
            super.stop();
        }
        finally {
            LOG.info("<== AsyncAuditProvider.stop()");
        }
    }

    @Override
    public void waitToComplete() {
        this.waitToComplete(0L);
        super.waitToComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitToComplete(long maxWaitSeconds) {
        LOG.debug("==> AsyncAuditProvider.waitToComplete()");
        try {
            for (long waitTime = 0L; !(this.isEmpty() || maxWaitSeconds > 0L && maxWaitSeconds <= waitTime); ++waitTime) {
                try {
                    LOG.info("{} messages yet to be flushed by {}.  Sleeoping for {} sec", new Object[]{this.mQueue.size(), this.mName, 1});
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException excp) {
                    LOG.warn("Caught interrupted exception! {} messages still unflushed!  Won't wait for queue to flush, exiting...", (Object)this.mQueue.size(), (Object)excp);
                    break;
                }
            }
        }
        finally {
            LOG.debug("<== AsyncAuditProvider.waitToComplete()");
        }
    }

    public int getIntervalLogDurationMS() {
        return this.intervalLogDurationMS;
    }

    public void setIntervalLogDurationMS(int intervalLogDurationMS) {
        this.intervalLogDurationMS = intervalLogDurationMS;
    }

    @Override
    public void run() {
        LOG.info("==> AsyncAuditProvider.run()");
        while (true) {
            AuditEventBase event = null;
            try {
                event = this.dequeueEvent();
                if (event != null) {
                    super.log(event);
                    continue;
                }
                this.lastFlushTime = System.currentTimeMillis();
                this.flush();
                continue;
            }
            catch (InterruptedException excp) {
                LOG.info("AsyncAuditProvider.run - Interrupted!  Breaking out of while loop.");
            }
            catch (Exception excp) {
                this.logFailedEvent(event, (Throwable)excp);
                continue;
            }
            break;
        }
        try {
            this.lastFlushTime = System.currentTimeMillis();
            this.flush();
        }
        catch (Exception excp) {
            LOG.error("AsyncAuditProvider.run()", (Throwable)excp);
        }
        LOG.info("<== AsyncAuditProvider.run()");
    }

    private void queueEvent(AuditEventBase event) {
        this.lifeTimeInLogCount.incrementAndGet();
        this.intervalInLogCount.incrementAndGet();
        if (!this.mQueue.offer(event)) {
            this.lifeTimeDropCount.incrementAndGet();
            this.intervalDropCount.incrementAndGet();
        }
    }

    private AuditEventBase dequeueEvent() throws InterruptedException {
        AuditEventBase ret = (AuditEventBase)this.mQueue.poll();
        while (ret == null) {
            this.logSummaryIfRequired();
            if (this.mMaxFlushInterval > 0) {
                long timeTillNextFlush = this.getTimeTillNextFlush();
                if (timeTillNextFlush <= 0L) break;
                ret = this.mQueue.poll(timeTillNextFlush, TimeUnit.MILLISECONDS);
                continue;
            }
            long waitTime = (long)this.intervalLogDurationMS - (System.currentTimeMillis() - this.lastIntervalLogTime);
            if (waitTime <= 0L) {
                waitTime = this.intervalLogDurationMS;
            }
            ret = this.mQueue.poll(waitTime, TimeUnit.MILLISECONDS);
        }
        if (ret != null) {
            this.lifeTimeOutLogCount.incrementAndGet();
            this.intervalOutLogCount.incrementAndGet();
        }
        this.logSummaryIfRequired();
        return ret;
    }

    private void logSummaryIfRequired() {
        long intervalSinceLastLog = System.currentTimeMillis() - this.lastIntervalLogTime;
        if (intervalSinceLastLog > (long)this.intervalLogDurationMS) {
            if (this.intervalInLogCount.get() > 0L || this.intervalOutLogCount.get() > 0L) {
                long queueSize = this.mQueue.size();
                LOG.info("AsyncAuditProvider-stats:{}: past {}: inLogs={}, outLogs={}, dropped={}, currentQueueSize={}", new Object[]{this.mName, this.formatIntervalForLog(intervalSinceLastLog), this.intervalInLogCount, this.intervalOutLogCount, this.intervalDropCount, queueSize});
                LOG.info("AsyncAuditProvider-stats:{}: process lifetime: inLogs={}, outLogs={}, dropped={}", new Object[]{this.mName, this.lifeTimeInLogCount, this.lifeTimeOutLogCount, this.lifeTimeDropCount});
            }
            this.lastIntervalLogTime = System.currentTimeMillis();
            this.intervalInLogCount.set(0L);
            this.intervalOutLogCount.set(0L);
            this.intervalDropCount.set(0L);
        }
    }

    private boolean isEmpty() {
        return this.mQueue.isEmpty();
    }

    private long getTimeTillNextFlush() {
        long timeTillNextFlush = this.mMaxFlushInterval;
        if (this.mMaxFlushInterval > 0 && this.lastFlushTime != 0L) {
            long timeSinceLastFlush = System.currentTimeMillis() - this.lastFlushTime;
            timeTillNextFlush = timeSinceLastFlush >= (long)this.mMaxFlushInterval ? 0L : (long)this.mMaxFlushInterval - timeSinceLastFlush;
        }
        return timeTillNextFlush;
    }
}

