/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.AbstractRangerAuditWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerJSONAuditWriter
extends AbstractRangerAuditWriter {
    private static final Logger logger = LoggerFactory.getLogger(RangerJSONAuditWriter.class);
    public static final String PROP_HDFS_ROLLOVER_ENABLE_PERIODIC_ROLLOVER = "file.rollover.enable.periodic.rollover";
    public static final String PROP_HDFS_ROLLOVER_PERIODIC_ROLLOVER_CHECK_TIME = "file.rollover.periodic.rollover.check.sec";
    protected static final String JSON_FILE_EXTENSION = ".log";
    private long periodicRollOverCheckTimeinSec;

    @Override
    public void init(Properties props, String propPrefix, String auditProviderName, Map<String, String> auditConfigs) {
        logger.debug("==> RangerJSONAuditWriter.init()");
        this.init();
        super.init(props, propPrefix, auditProviderName, auditConfigs);
        boolean enableAuditFilePeriodicRollOver = MiscUtil.getBooleanProperty(props, propPrefix + "." + PROP_HDFS_ROLLOVER_ENABLE_PERIODIC_ROLLOVER, false);
        if (enableAuditFilePeriodicRollOver) {
            this.periodicRollOverCheckTimeinSec = MiscUtil.getLongProperty(props, propPrefix + "." + PROP_HDFS_ROLLOVER_PERIODIC_ROLLOVER_CHECK_TIME, 60L);
            try {
                logger.debug("rolloverPeriod: {} nextRollOverTime: {} periodicRollOverTimeinSec: {}", new Object[]{this.rolloverPeriod, this.nextRollOverTime, this.periodicRollOverCheckTimeinSec});
                this.startAuditFilePeriodicRollOverTask();
            }
            catch (Exception e) {
                logger.warn("Error enabling audit file perodic rollover..! Default behavior will be");
            }
        }
        logger.debug("<== RangerJSONAuditWriter.init()");
    }

    @Override
    public void flush() {
        logger.debug("==> JSONWriter.flush() called. name={}", (Object)this.auditProviderName);
        super.flush();
        logger.debug("<== JSONWriter.flush()");
    }

    public void init() {
        this.setFileExtension(JSON_FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean logJSON(Collection<String> events) throws Exception {
        PrintWriter out = null;
        try {
            logger.debug("UGI = {}, will write to HDFS file = {}", (Object)MiscUtil.getUGILoginUser(), (Object)this.currentFileName);
            out = MiscUtil.executePrivilegedAction(() -> {
                PrintWriter out1 = null;
                if (CollectionUtils.isEmpty((Collection)events)) {
                    this.closeFileIfNeeded();
                } else {
                    out1 = this.getLogFileStream();
                    for (String event : events) {
                        out1.println(event);
                    }
                }
                return out1;
            });
            if (out != null && out.checkError()) {
                logger.error("Stream encountered errors while writing audits to HDFS!");
                this.closeWriter();
                this.resetWriter();
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("Exception encountered while writing audits to HDFS!", (Throwable)e);
            this.closeWriter();
            this.resetWriter();
            boolean bl = false;
            return bl;
        }
        finally {
            logger.debug("Flushing HDFS audit. Event Size:{}", (Object)events.size());
            if (out != null) {
                out.flush();
            }
        }
        return true;
    }

    @Override
    public boolean log(Collection<String> events) throws Exception {
        return this.logJSON(events);
    }

    @Override
    public boolean logFile(File file) throws Exception {
        return this.logAsFile(file);
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        logger.debug("==> JSONWriter.stop()");
        if (this.logWriter != null) {
            try {
                this.logWriter.flush();
                this.logWriter.close();
            }
            catch (Throwable t) {
                logger.error("Error on closing log writter. Exception will be ignored. name={}, fileName={}", (Object)this.auditProviderName, (Object)this.currentFileName);
            }
            this.logWriter = null;
            this.ostream = null;
        }
        logger.debug("<== JSONWriter.stop()");
    }

    public synchronized boolean logAsFile(File file) throws Exception {
        logger.debug("UGI={}. Will write to HDFS file={}", (Object)MiscUtil.getUGILoginUser(), (Object)this.currentFileName);
        boolean ret = MiscUtil.executePrivilegedAction(() -> this.logFileToHDFS(file));
        logger.info("Flushing HDFS audit File :{}{}", (Object)file.getAbsolutePath(), (Object)file.getName());
        return ret;
    }

    public synchronized PrintWriter getLogFileStream() throws Exception {
        this.closeFileIfNeeded();
        return this.createWriter();
    }

    private void startAuditFilePeriodicRollOverTask() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new AuditFilePeriodicRollOverTaskThreadFactory());
        logger.debug("HDFSAuditDestination.startAuditFilePeriodicRollOverTask() strated..Audit File rollover happens every {}", (Object)this.rolloverPeriod);
        executorService.scheduleAtFixedRate(new AuditFilePeriodicRollOverTask(), 0L, this.periodicRollOverCheckTimeinSec, TimeUnit.SECONDS);
    }

    private class AuditFilePeriodicRollOverTask
    implements Runnable {
        private AuditFilePeriodicRollOverTask() {
        }

        @Override
        public void run() {
            logger.debug("==> AuditFilePeriodicRollOverTask.run()");
            try {
                RangerJSONAuditWriter.this.logJSON(Collections.emptyList());
            }
            catch (Exception excp) {
                logger.error("AuditFilePeriodicRollOverTask Failed. Aborting..", (Throwable)excp);
            }
            logger.debug("<== AuditFilePeriodicRollOverTask.run()");
        }
    }

    static class AuditFilePeriodicRollOverTaskThreadFactory
    implements ThreadFactory {
        AuditFilePeriodicRollOverTaskThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "AuditFilePeriodicRollOverTask");
            t.setDaemon(true);
            return t;
        }
    }
}

