/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryJAASConfiguration
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryJAASConfiguration.class);
    public static final String JAAS_CONFIG_PREFIX_PARAM = "xasecure.audit.jaas.";
    public static final String JAAS_CONFIG_LOGIN_MODULE_NAME_PARAM = "loginModuleName";
    public static final String JAAS_CONFIG_LOGIN_MODULE_CONTROL_FLAG_PARAM = "loginModuleControlFlag";
    public static final String JAAS_CONFIG_LOGIN_OPTIONS_PREFIX = "option";
    public static final String JAAS_PRINCIPAL_PROP = "principal";
    private final Configuration parent;
    private final Map<String, List<AppConfigurationEntry>> applicationConfigEntryMap = new HashMap<String, List<AppConfigurationEntry>>();

    private InMemoryJAASConfiguration(Properties prop) {
        this.parent = Configuration.getConfiguration();
        this.initialize(prop);
    }

    public static InMemoryJAASConfiguration init(String propFile) throws Exception {
        InMemoryJAASConfiguration ret;
        LOG.debug("==> InMemoryJAASConfiguration.init( {} ) ", (Object)propFile);
        InputStream in = null;
        try {
            Properties properties = new Properties();
            in = ClassLoader.getSystemResourceAsStream(propFile);
            if (in == null) {
                if (!propFile.startsWith("/")) {
                    in = ClassLoader.getSystemResourceAsStream("/" + propFile);
                }
                if (in == null) {
                    in = Files.newInputStream(new File(propFile).toPath(), new OpenOption[0]);
                }
            }
            properties.load(in);
            ret = InMemoryJAASConfiguration.init(properties);
        }
        catch (IOException e) {
            throw new Exception("Failed to load JAAS application properties", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        LOG.debug("<== InMemoryJAASConfiguration.init( {} ) ", (Object)propFile);
        return ret;
    }

    public static InMemoryJAASConfiguration init(Properties properties) throws Exception {
        LOG.debug("==> InMemoryJAASConfiguration.init()");
        if (!MapUtils.isNotEmpty((Map)properties)) {
            throw new Exception("Failed to load JAAS application properties: properties NULL or empty!");
        }
        InMemoryJAASConfiguration ret = new InMemoryJAASConfiguration(properties);
        LOG.debug("<== InMemoryJAASConfiguration.init()");
        return ret;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        List<AppConfigurationEntry> retList;
        LOG.debug("==> InMemoryJAASConfiguration.getAppConfigurationEntry( {} )", (Object)name);
        AppConfigurationEntry[] ret = null;
        if (this.parent != null) {
            ret = this.parent.getAppConfigurationEntry(name);
        }
        if (!(ret != null && ret.length != 0 || (retList = this.applicationConfigEntryMap.get(name)) == null || retList.isEmpty())) {
            ret = retList.toArray(new AppConfigurationEntry[retList.size()]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== InMemoryJAASConfiguration.getAppConfigurationEntry( {} ) : {}", (Object)name, (Object)this.toString(ret));
        }
        return ret;
    }

    private void initialize(Properties properties) {
        LOG.debug("==> InMemoryJAASConfiguration.initialize()");
        int prefixLen = JAAS_CONFIG_PREFIX_PARAM.length();
        HashMap<String, SortedSet> jaasClients = new HashMap<String, SortedSet>();
        for (String key : properties.stringPropertyNames()) {
            String indexStr;
            Integer clientIdIndex;
            String clientId;
            SortedSet indexList;
            String jaasKey;
            StringTokenizer tokenizer;
            int tokenCount;
            if (!key.startsWith(JAAS_CONFIG_PREFIX_PARAM) || (tokenCount = (tokenizer = new StringTokenizer(jaasKey = key.substring(prefixLen), ".")).countTokens()) <= 0 || (indexList = jaasClients.computeIfAbsent(clientId = tokenizer.nextToken(), k -> new TreeSet())).contains(clientIdIndex = Integer.valueOf(InMemoryJAASConfiguration.isNumeric(indexStr = tokenizer.nextToken()) ? Integer.parseInt(indexStr) : -1))) continue;
            indexList.add(clientIdIndex);
        }
        for (String jaasClient : jaasClients.keySet()) {
            for (Integer index : (SortedSet)jaasClients.get(jaasClient)) {
                AppConfigurationEntry.LoginModuleControlFlag loginControlFlag;
                String keyParam;
                String loginModuleName;
                String keyPrefix = JAAS_CONFIG_PREFIX_PARAM + jaasClient + ".";
                if (index > -1) {
                    keyPrefix = keyPrefix + index + ".";
                }
                if ((loginModuleName = properties.getProperty(keyParam = keyPrefix + JAAS_CONFIG_LOGIN_MODULE_NAME_PARAM)) == null) {
                    LOG.error("Unable to add JAAS configuration for client [{}] as it is missing param [{}]. Skipping JAAS config for [{}]", new Object[]{jaasClient, keyParam, jaasClient});
                    continue;
                }
                loginModuleName = loginModuleName.trim();
                keyParam = keyPrefix + JAAS_CONFIG_LOGIN_MODULE_CONTROL_FLAG_PARAM;
                String controlFlag = properties.getProperty(keyParam);
                if (controlFlag != null) {
                    switch (controlFlag = controlFlag.trim().toLowerCase()) {
                        case "optional": {
                            loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                            break;
                        }
                        case "requisite": {
                            loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                            break;
                        }
                        case "sufficient": {
                            loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                            break;
                        }
                        case "required": {
                            loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                            break;
                        }
                        default: {
                            String validValues = "optional|requisite|sufficient|required";
                            LOG.warn("Unknown JAAS configuration value for ({}) = [{}], valid value are [{}] using the default value, REQUIRED", new Object[]{keyParam, controlFlag, validValues});
                            loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                            break;
                        }
                    }
                } else {
                    LOG.warn("Unable to find JAAS configuration ({}); using the default value, REQUIRED", (Object)keyParam);
                    loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                }
                HashMap<String, String> options = new HashMap<String, String>();
                String optionPrefix = keyPrefix + JAAS_CONFIG_LOGIN_OPTIONS_PREFIX + ".";
                int optionPrefixLen = optionPrefix.length();
                for (String key : properties.stringPropertyNames()) {
                    if (!key.startsWith(optionPrefix)) continue;
                    String optionKey = key.substring(optionPrefixLen);
                    String optionVal = properties.getProperty(key);
                    if (optionVal != null) {
                        optionVal = optionVal.trim();
                        try {
                            if (optionKey.equalsIgnoreCase(JAAS_PRINCIPAL_PROP)) {
                                optionVal = SecurityUtil.getServerPrincipal((String)optionVal, (String)null);
                            }
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to build serverPrincipal. Using provided value:[{}]", (Object)optionVal);
                        }
                    }
                    options.put(optionKey, optionVal);
                }
                AppConfigurationEntry entry = new AppConfigurationEntry(loginModuleName, loginControlFlag, options);
                if (LOG.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Adding client: [").append(jaasClient).append("{").append(index).append("}]\n");
                    sb.append("\tloginModule: [").append(loginModuleName).append("]\n");
                    sb.append("\tcontrolFlag: [").append(loginControlFlag).append("]\n");
                    for (String key : options.keySet()) {
                        String val = (String)options.get(key);
                        sb.append("\tOptions:  [").append(key).append("] => [").append(val).append("]\n");
                    }
                    LOG.debug(sb.toString());
                }
                List retList = this.applicationConfigEntryMap.computeIfAbsent(jaasClient, k -> new ArrayList());
                retList.add(entry);
            }
        }
        LOG.debug("<== InMemoryJAASConfiguration.initialize()");
    }

    private static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    private String toString(AppConfigurationEntry[] entries) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (entries != null) {
            for (AppConfigurationEntry entry : entries) {
                sb.append("{ loginModuleName=").append(entry.getLoginModuleName()).append(", controlFlag=").append(entry.getControlFlag()).append(", options=").append(entry.getOptions()).append("}");
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

