/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.util.Collection;
import java.util.Properties;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.BaseAuditHandler;
import org.apache.ranger.audit.queue.AuditFileCacheProviderSpool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditFileCacheProvider
extends BaseAuditHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuditFileCacheProvider.class);
    AuditFileCacheProviderSpool fileSpooler;
    AuditHandler consumer;

    AuditFileCacheProvider(AuditHandler consumer) {
        this.consumer = consumer;
    }

    @Override
    public boolean log(AuditEventBase event) {
        boolean ret = false;
        if (event != null) {
            this.fileSpooler.stashLogs(event);
            if (this.fileSpooler.isSpoolingSuccessful()) {
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public void init(Properties prop, String basePropertyName) {
        String propPrefix = "xasecure.audit.filecache";
        if (basePropertyName != null) {
            propPrefix = basePropertyName;
        }
        super.init(prop, propPrefix);
        if (this.consumer != null) {
            this.consumer.init(prop, propPrefix);
        }
        this.fileSpooler = new AuditFileCacheProviderSpool(this.consumer);
        this.fileSpooler.init(prop, propPrefix);
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        boolean ret = true;
        if (events != null) {
            for (AuditEventBase event : events) {
                ret = this.log(event);
            }
        }
        return ret;
    }

    @Override
    public void start() {
        if (this.consumer != null) {
            this.consumer.start();
        }
        if (this.fileSpooler != null) {
            this.fileSpooler.start();
        }
    }

    @Override
    public void stop() {
        logger.info("stop() called. name={}", (Object)this.getName());
        if (this.consumer != null) {
            this.consumer.stop();
        }
    }

    @Override
    public void waitToComplete() {
        logger.info("waitToComplete() called. name={}", (Object)this.getName());
        if (this.consumer != null) {
            this.consumer.waitToComplete();
        }
    }

    @Override
    public void waitToComplete(long timeout) {
        logger.info("waitToComplete(timeout={}) called. name={}", (Object)timeout, (Object)this.getName());
        if (this.consumer != null) {
            this.consumer.waitToComplete(timeout);
        }
    }

    @Override
    public void flush() {
        logger.info("flush() called. name={}", (Object)this.getName());
        if (this.consumer != null) {
            this.consumer.flush();
        }
    }
}

