/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class RollingTimeUtil {
    public static final String MINUTES = "m";
    public static final String HOURS = "h";
    public static final String DAYS = "d";
    public static final String WEEKS = "w";
    public static final String MONTHS = "M";
    public static final String YEARS = "y";
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int SECONDS_IN_HOUR = 3600;
    private static final int SECONDS_IN_DAY = 86400;
    private static volatile RollingTimeUtil me;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RollingTimeUtil getInstance() {
        RollingTimeUtil result = me;
        if (result != null) return result;
        Class<RollingTimeUtil> clazz = RollingTimeUtil.class;
        synchronized (RollingTimeUtil.class) {
            result = me;
            if (result != null) return result;
            me = result = new RollingTimeUtil();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void main(String[] args) {
        Date nextRollOvertime;
        String rollOverPeriod = "";
        RollingTimeUtil rollingTimeUtil = new RollingTimeUtil();
        int duration = 86400;
        try {
            nextRollOvertime = rollingTimeUtil.computeNextRollingTime(rollOverPeriod);
        }
        catch (Exception e) {
            rollOverPeriod = rollingTimeUtil.convertRolloverSecondsToRolloverPeriod(duration);
            System.out.println(rollOverPeriod);
            try {
                nextRollOvertime = rollingTimeUtil.computeNextRollingTime(rollOverPeriod);
                System.out.println(nextRollOvertime);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            long rollOverTime = rollingTimeUtil.computeNextRollingTime(duration, null);
            nextRollOvertime = new Date(rollOverTime);
        }
        System.out.println(nextRollOvertime);
    }

    public Date computeNextRollingTime(String rollingTimePeriod) throws Exception {
        Date ret;
        if (!StringUtils.isEmpty((String)rollingTimePeriod)) {
            String computePeriod = this.getTimeLiteral(rollingTimePeriod);
            int timeNumeral = this.getTimeNumeral(rollingTimePeriod, computePeriod);
            switch (computePeriod) {
                case "m": {
                    ret = this.computeTopOfMinuteDate(timeNumeral);
                    break;
                }
                case "h": {
                    ret = this.computeTopOfHourDate(timeNumeral);
                    break;
                }
                case "d": {
                    ret = this.computeTopOfDayDate(timeNumeral);
                    break;
                }
                case "w": {
                    ret = this.computeTopOfWeekDate(timeNumeral);
                    break;
                }
                case "M": {
                    ret = this.computeTopofMonthDate(timeNumeral);
                    break;
                }
                case "y": {
                    ret = this.computeTopOfYearDate(timeNumeral);
                    break;
                }
                default: {
                    ret = null;
                    break;
                }
            }
        } else {
            throw new Exception("Unable to compute Next Rolling using the given Rollover period");
        }
        return ret;
    }

    public String convertRolloverSecondsToRolloverPeriod(long duration) {
        int days = (int)(duration / 86400L);
        int hours = (int)((duration %= 86400L) / 3600L);
        int minutes = (int)((duration %= 3600L) / 60L);
        String ret = null;
        if (days != 0) {
            if (hours == 0 && minutes == 0) {
                ret = days + DAYS;
            }
        } else if (hours != 0) {
            if (minutes == 0) {
                ret = hours + HOURS;
            }
        } else if (minutes != 0) {
            ret = minutes + MINUTES;
        }
        return ret;
    }

    public long computeNextRollingTime(long durationSeconds, Date previousRolloverTime) {
        long nextRolloverTime;
        long now = System.currentTimeMillis();
        long durationMillis = (durationSeconds < 1L ? 1L : durationSeconds) * 1000L;
        for (nextRolloverTime = previousRolloverTime == null ? now : previousRolloverTime.getTime(); nextRolloverTime <= now; nextRolloverTime += durationMillis) {
        }
        return nextRolloverTime;
    }

    private Date computeTopOfYearDate(int years) {
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.add(1, years);
        calendarStart.set(2, 0);
        calendarStart.set(5, 1);
        calendarStart.set(11, 0);
        calendarStart.clear(12);
        calendarStart.clear(13);
        calendarStart.clear(14);
        return calendarStart.getTime();
    }

    private Date computeTopofMonthDate(int months) {
        Calendar calendarMonth = Calendar.getInstance();
        calendarMonth.set(5, 1);
        calendarMonth.add(2, months);
        calendarMonth.set(11, 0);
        calendarMonth.clear(12);
        calendarMonth.clear(13);
        calendarMonth.clear(14);
        return calendarMonth.getTime();
    }

    private Date computeTopOfWeekDate(int weeks) {
        Calendar calendarWeek = Calendar.getInstance();
        calendarWeek.set(7, calendarWeek.getFirstDayOfWeek());
        calendarWeek.add(3, weeks);
        calendarWeek.set(11, 0);
        calendarWeek.clear(12);
        calendarWeek.clear(13);
        calendarWeek.clear(14);
        return calendarWeek.getTime();
    }

    private Date computeTopOfDayDate(int days) {
        Calendar calendarDay = Calendar.getInstance();
        calendarDay.add(5, days);
        calendarDay.set(11, 0);
        calendarDay.clear(12);
        calendarDay.clear(13);
        calendarDay.clear(14);
        return calendarDay.getTime();
    }

    private Date computeTopOfHourDate(int hours) {
        Calendar calendarHour = Calendar.getInstance();
        calendarHour.add(11, hours);
        calendarHour.clear(12);
        calendarHour.clear(13);
        calendarHour.clear(14);
        return calendarHour.getTime();
    }

    private Date computeTopOfMinuteDate(int mins) {
        Calendar calendarMin = Calendar.getInstance();
        calendarMin.add(12, mins);
        calendarMin.clear(13);
        calendarMin.clear(14);
        return calendarMin.getTime();
    }

    private int getTimeNumeral(String rollOverPeriod, String timeLiteral) {
        return Integer.parseInt(rollOverPeriod.substring(0, rollOverPeriod.length() - (rollOverPeriod.length() - rollOverPeriod.indexOf(timeLiteral))));
    }

    private String getTimeLiteral(String rollOverPeriod) throws Exception {
        String ret;
        if (StringUtils.isEmpty((String)rollOverPeriod)) {
            throw new Exception("empty rollover period");
        }
        if (rollOverPeriod.endsWith(MINUTES)) {
            ret = MINUTES;
        } else if (rollOverPeriod.endsWith(HOURS)) {
            ret = HOURS;
        } else if (rollOverPeriod.endsWith(DAYS)) {
            ret = DAYS;
        } else if (rollOverPeriod.endsWith(WEEKS)) {
            ret = WEEKS;
        } else if (rollOverPeriod.endsWith(MONTHS)) {
            ret = MONTHS;
        } else if (rollOverPeriod.endsWith(YEARS)) {
            ret = YEARS;
        } else {
            throw new Exception(rollOverPeriod + ": invalid rollover period");
        }
        return ret;
    }
}

