/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.ranger.audit.utils.KerberosUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKerberosUser
implements KerberosUser {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKerberosUser.class);
    static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    static final float TICKET_RENEW_WINDOW = 0.8f;
    protected final AtomicBoolean loggedIn = new AtomicBoolean(false);
    protected Subject subject;
    protected LoginContext loginContext;

    @Override
    public synchronized void login() throws LoginException {
        if (this.isLoggedIn()) {
            return;
        }
        try {
            if (this.loginContext == null) {
                LOG.debug("Initializing new login context...");
                if (this.subject == null) {
                    this.subject = new Subject();
                }
                this.loginContext = this.createLoginContext(this.subject);
            }
            this.loginContext.login();
            this.loggedIn.set(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successful login for {}", (Object)this.getPrincipal());
            }
        }
        catch (LoginException le) {
            LoginException loginException = new LoginException("Unable to login with " + this.getPrincipal() + " due to: " + le.getMessage());
            loginException.setStackTrace(le.getStackTrace());
            throw loginException;
        }
    }

    @Override
    public synchronized void logout() throws LoginException {
        if (!this.isLoggedIn()) {
            return;
        }
        try {
            this.loginContext.logout();
            this.loggedIn.set(false);
            LOG.debug("Successful logout for {}", (Object)this.getPrincipal());
            this.loginContext = null;
        }
        catch (LoginException e) {
            throw new LoginException("Logout failed due to: " + e.getMessage());
        }
    }

    @Override
    public <T> T doAs(PrivilegedAction<T> action) throws IllegalStateException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("Must login before executing actions");
        }
        return Subject.doAs(this.subject, action);
    }

    @Override
    public <T> T doAs(PrivilegedExceptionAction<T> action) throws IllegalStateException, PrivilegedActionException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("Must login before executing actions");
        }
        return Subject.doAs(this.subject, action);
    }

    @Override
    public synchronized boolean checkTGTAndRelogin() throws LoginException {
        KerberosTicket tgt = this.getTGT();
        if (tgt == null) {
            LOG.debug("TGT was not found");
        }
        if (tgt != null && System.currentTimeMillis() < this.getRefreshTime(tgt)) {
            LOG.debug("TGT was found, but has not reached expiration window");
            return false;
        }
        LOG.debug("Performing relogin for {}", (Object)this.getPrincipal());
        this.logout();
        this.login();
        return true;
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn.get();
    }

    public String toString() {
        return "KerberosUser{principal='" + this.getPrincipal() + '\'' + ", loggedIn=" + this.loggedIn + '}';
    }

    protected abstract LoginContext createLoginContext(Subject var1) throws LoginException;

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!this.isTGSPrincipal(ticket.getServer())) continue;
            return ticket;
        }
        return null;
    }

    private boolean isTGSPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        if (principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found TGT principal: {}", (Object)principal.getName());
            }
            return true;
        }
        return false;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        if (LOG.isTraceEnabled()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            String startDate = dateFormat.format(new Date(start));
            String endDate = dateFormat.format(new Date(end));
            LOG.trace("TGT valid starting at: {}", (Object)startDate);
            LOG.trace("TGT expires at: {}", (Object)endDate);
        }
        return start + (long)((float)(end - start) * 0.8f);
    }
}

