/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.queue.AuditQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AuditSummaryQueue
extends AuditQueue
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AuditSummaryQueue.class);
    public static final String PROP_SUMMARY_INTERVAL = "summary.interval.ms";
    private static final int MAX_DRAIN = 100000;
    static final String DEFAULT_NAME = "summary";
    static int threadCount;
    Thread consumerThread;
    LinkedBlockingQueue<AuditEventBase> queue = new LinkedBlockingQueue();
    HashMap<String, AuditSummary> summaryMap = new HashMap();
    private int maxSummaryIntervalMs = 5000;

    public AuditSummaryQueue(AuditHandler consumer) {
        super(consumer);
        this.setName(DEFAULT_NAME);
    }

    @Override
    public void init(Properties props, String propPrefix) {
        super.init(props, propPrefix);
        this.maxSummaryIntervalMs = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_SUMMARY_INTERVAL, this.maxSummaryIntervalMs);
        logger.info("maxSummaryInterval={}, name={}", (Object)this.maxSummaryIntervalMs, (Object)this.getName());
    }

    @Override
    public boolean log(AuditEventBase event) {
        if (this.queue.size() >= this.getMaxQueueSize()) {
            return false;
        }
        this.queue.add(event);
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        AuditEventBase event;
        boolean ret = true;
        Iterator<AuditEventBase> iterator = events.iterator();
        while (iterator.hasNext() && (ret = this.log(event = iterator.next()))) {
        }
        return ret;
    }

    @Override
    public void start() {
        if (this.consumer != null) {
            this.consumer.start();
        }
        this.consumerThread = new Thread((Runnable)this, this.getClass().getName() + threadCount++);
        this.consumerThread.setDaemon(true);
        this.consumerThread.start();
    }

    @Override
    public void stop() {
        logger.info("Stop called. name={}", (Object)this.getName());
        this.setDrain(true);
        try {
            if (this.consumerThread != null) {
                logger.info("Interrupting consumerThread. name={}, consumer={}", (Object)this.getName(), this.consumer == null ? null : this.consumer.getName());
                this.consumerThread.interrupt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.consumerThread = null;
    }

    @Override
    public void run() {
        try {
            MDC.clear();
            this.runLogAudit();
        }
        catch (Throwable t) {
            logger.error("Exited thread without abnormaly. queue={}", (Object)this.getName(), (Object)t);
        }
    }

    public void runLogAudit() {
        long lastDispatchTime = System.currentTimeMillis();
        while (true) {
            long nextDispatchDuration = lastDispatchTime - System.currentTimeMillis() + (long)this.maxSummaryIntervalMs;
            ArrayList<AuditEventBase> eventList = new ArrayList<AuditEventBase>();
            try {
                AuditEventBase event = !this.isDrain() && nextDispatchDuration > 0L ? this.queue.poll(nextDispatchDuration, TimeUnit.MILLISECONDS) : this.queue.poll();
                if (event != null) {
                    eventList.add(event);
                    this.queue.drainTo(eventList, 99999);
                } else {
                    nextDispatchDuration = lastDispatchTime - System.currentTimeMillis() + (long)this.maxSummaryIntervalMs;
                    lastDispatchTime = System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                logger.info("Caught exception in consumer thread. Shutdown might be in progress");
            }
            catch (Throwable t) {
                logger.error("Caught error during processing request.", t);
            }
            for (AuditEventBase auditEventBase : eventList) {
                String key = auditEventBase.getEventKey();
                AuditSummary auditSummary = this.summaryMap.get(key);
                if (auditSummary == null) {
                    auditSummary = new AuditSummary();
                    auditSummary.event = auditEventBase;
                    auditSummary.startTime = auditEventBase.getEventTime();
                    auditSummary.endTime = auditEventBase.getEventTime();
                    auditSummary.count = 1;
                    this.summaryMap.put(key, auditSummary);
                    continue;
                }
                auditSummary.endTime = auditEventBase.getEventTime();
                ++auditSummary.count;
            }
            if (this.isDrain() || nextDispatchDuration <= 0L) {
                lastDispatchTime = System.currentTimeMillis();
                for (Map.Entry entry : this.summaryMap.entrySet()) {
                    AuditSummary auditSummary = (AuditSummary)entry.getValue();
                    auditSummary.event.setEventCount(auditSummary.count);
                    long timeDiff = auditSummary.endTime.getTime() - auditSummary.startTime.getTime();
                    timeDiff = timeDiff > 0L ? timeDiff : 1L;
                    auditSummary.event.setEventDurationMS(timeDiff);
                    boolean ret = this.consumer.log(auditSummary.event);
                    if (ret) continue;
                    this.logFailedEvent(auditSummary.event);
                }
                this.summaryMap.clear();
            }
            if (!this.isDrain()) continue;
            if (this.summaryMap.isEmpty() && this.queue.isEmpty()) break;
            if (!this.isDrainMaxTimeElapsed()) continue;
            logger.warn("Exiting polling loop because max time allowed reached. name={}, waited for {} ms", (Object)this.getName(), (Object)(this.stopTime - System.currentTimeMillis()));
        }
        logger.info("Exiting polling loop. name={}", (Object)this.getName());
        try {
            logger.info("Calling to stop consumer. name={}, consumer.name={}", (Object)this.getName(), (Object)this.consumer.getName());
            this.consumer.stop();
        }
        catch (Throwable t) {
            logger.error("Error while calling stop on consumer.", t);
        }
        logger.info("Exiting consumerThread.run() method. name={}", (Object)this.getName());
    }

    static class AuditSummary {
        Date startTime;
        Date endTime;
        int count;
        AuditEventBase event;

        AuditSummary() {
        }
    }
}

