/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.queue;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AuditFileCacheProviderSpool
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AuditFileCacheProviderSpool.class);
    public static final String PROP_FILE_SPOOL_LOCAL_DIR = "filespool.dir";
    public static final String PROP_FILE_SPOOL_LOCAL_FILE_NAME = "filespool.filename.format";
    public static final String PROP_FILE_SPOOL_ARCHIVE_DIR = "filespool.archive.dir";
    public static final String PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT = "filespool.archive.max.files";
    public static final String PROP_FILE_SPOOL_FILENAME_PREFIX = "filespool.file.prefix";
    public static final String PROP_FILE_SPOOL_FILE_ROLLOVER = "filespool.file.rollover.sec";
    public static final String PROP_FILE_SPOOL_INDEX_FILE = "filespool.index.filename";
    public static final String PROP_FILE_SPOOL_DEST_RETRY_MS = "filespool.destination.retry.ms";
    public static final String PROP_FILE_SPOOL_BATCH_SIZE = "filespool.buffer.size";
    public static final String AUDIT_IS_FILE_CACHE_PROVIDER_ENABLE_PROP = "xasecure.audit.provider.filecache.is.enabled";
    public static final String FILE_CACHE_PROVIDER_NAME = "AuditFileCacheProviderSpool";
    AuditHandler consumerProvider;
    BlockingQueue<AuditIndexRecord> indexQueue = new LinkedBlockingQueue<AuditIndexRecord>();
    List<AuditIndexRecord> indexRecords = new ArrayList<AuditIndexRecord>();
    File logFolder;
    String logFileNameFormat;
    File archiveFolder;
    String fileNamePrefix;
    String indexFileName;
    File indexFile;
    String indexDoneFileName;
    File indexDoneFile;
    long lastErrorLogMS;
    boolean isAuditFileCacheProviderEnabled;
    boolean closeFile;
    boolean isPending;
    long lastAttemptTime;
    boolean initDone;
    PrintWriter logWriter;
    AuditIndexRecord currentWriterIndexRecord;
    AuditIndexRecord currentConsumerIndexRecord;
    Thread destinationThread;
    boolean isDrain;
    boolean isDestDown;
    int retryDestinationMS = 30000;
    int fileRolloverSec = 86400;
    int maxArchiveFiles = 100;
    int errorLogIntervalMS = 30000;
    int auditBatchSize = 1000;
    boolean isWriting = true;
    boolean isSpoolingSuccessful = true;

    public AuditFileCacheProviderSpool(AuditHandler consumerProvider) {
        this.consumerProvider = consumerProvider;
    }

    public void init(Properties prop) {
        this.init(prop, null);
    }

    public boolean init(Properties props, String basePropertyName) {
        logger.debug("==> AuditFileCacheProviderSpool.init()");
        if (this.initDone) {
            logger.error("init() called more than once. queueProvider=, consumerProvider={}", (Object)this.consumerProvider.getName());
            return true;
        }
        String propPrefix = "xasecure.audit.filespool";
        if (basePropertyName != null) {
            propPrefix = basePropertyName;
        }
        try {
            boolean ret;
            boolean ret2;
            boolean result;
            String logFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_LOCAL_DIR);
            String archiveFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_ARCHIVE_DIR);
            this.logFileNameFormat = MiscUtil.getStringProperty(props, basePropertyName + "." + PROP_FILE_SPOOL_LOCAL_FILE_NAME);
            this.fileNamePrefix = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_FILENAME_PREFIX);
            this.indexFileName = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_INDEX_FILE);
            this.retryDestinationMS = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_DEST_RETRY_MS, this.retryDestinationMS);
            this.fileRolloverSec = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_FILE_ROLLOVER, this.fileRolloverSec);
            this.maxArchiveFiles = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT, this.maxArchiveFiles);
            this.isAuditFileCacheProviderEnabled = MiscUtil.getBooleanProperty(props, AUDIT_IS_FILE_CACHE_PROVIDER_ENABLE_PROP, false);
            logger.info("retryDestinationMS={}, queueName={}", (Object)this.retryDestinationMS, (Object)FILE_CACHE_PROVIDER_NAME);
            logger.info("fileRolloverSec={}, queueName={}", (Object)this.fileRolloverSec, (Object)FILE_CACHE_PROVIDER_NAME);
            logger.info("maxArchiveFiles={}, queueName={}", (Object)this.maxArchiveFiles, (Object)FILE_CACHE_PROVIDER_NAME);
            if (logFolderProp == null || logFolderProp.isEmpty()) {
                logger.error("Audit spool folder is not configured. Please set {}.{}.queueName={}", new Object[]{propPrefix, PROP_FILE_SPOOL_LOCAL_DIR, FILE_CACHE_PROVIDER_NAME});
                return false;
            }
            this.logFolder = new File(logFolderProp);
            if (!this.logFolder.isDirectory()) {
                result = this.logFolder.mkdirs();
                if (!this.logFolder.isDirectory() || !result) {
                    logger.error("File Spool folder not found and can't be created. folder={}, queueName={}", (Object)this.logFolder.getAbsolutePath(), (Object)FILE_CACHE_PROVIDER_NAME);
                    return false;
                }
            }
            logger.info("logFolder={}, queueName={}", (Object)this.logFolder, (Object)FILE_CACHE_PROVIDER_NAME);
            if (this.logFileNameFormat == null || this.logFileNameFormat.isEmpty()) {
                this.logFileNameFormat = "spool_%app-type%_%time:yyyyMMdd-HHmm.ss%.log";
            }
            logger.info("logFileNameFormat={}, queueName={}", (Object)this.logFileNameFormat, (Object)FILE_CACHE_PROVIDER_NAME);
            this.archiveFolder = archiveFolderProp == null || archiveFolderProp.isEmpty() ? new File(this.logFolder, "archive") : new File(archiveFolderProp);
            if (!this.archiveFolder.isDirectory()) {
                result = this.archiveFolder.mkdirs();
                if (!this.archiveFolder.isDirectory() || !result) {
                    logger.error("File Spool archive folder not found and can't be created. folder={}, queueName={}", (Object)this.archiveFolder.getAbsolutePath(), (Object)FILE_CACHE_PROVIDER_NAME);
                    return false;
                }
            }
            logger.info("archiveFolder={}, queueName={}", (Object)this.archiveFolder, (Object)FILE_CACHE_PROVIDER_NAME);
            if (this.indexFileName == null || this.indexFileName.isEmpty()) {
                if (this.fileNamePrefix == null || this.fileNamePrefix.isEmpty()) {
                    this.fileNamePrefix = "AuditFileCacheProviderSpool_" + this.consumerProvider.getName();
                }
                this.indexFileName = "index_" + this.fileNamePrefix + "_%app-type%.json";
                this.indexFileName = MiscUtil.replaceTokens(this.indexFileName, System.currentTimeMillis());
            }
            this.indexFile = new File(this.logFolder, this.indexFileName);
            if (!this.indexFile.exists() && !(ret2 = this.indexFile.createNewFile())) {
                logger.error("Error creating index file. fileName={}", (Object)this.indexFile.getPath());
                return false;
            }
            logger.info("indexFile={}, queueName={}", (Object)this.indexFile, (Object)FILE_CACHE_PROVIDER_NAME);
            int lastDot = this.indexFileName.lastIndexOf(46);
            if (lastDot < 0) {
                lastDot = this.indexFileName.length() - 1;
            }
            this.indexDoneFileName = this.indexFileName.substring(0, lastDot) + "_closed.json";
            this.indexDoneFile = new File(this.logFolder, this.indexDoneFileName);
            if (!this.indexDoneFile.exists() && !(ret = this.indexDoneFile.createNewFile())) {
                logger.error("Error creating index done file. fileName={}", (Object)this.indexDoneFile.getPath());
                return false;
            }
            logger.info("indexDoneFile={}, queueName={}", (Object)this.indexDoneFile, (Object)FILE_CACHE_PROVIDER_NAME);
            this.loadIndexFile();
            for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
                if (!auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.done)) {
                    this.isPending = true;
                }
                if (auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.write_inprogress)) {
                    this.currentWriterIndexRecord = auditIndexRecord;
                    logger.info("currentWriterIndexRecord={}, queueName={}", (Object)this.currentWriterIndexRecord.filePath, (Object)FILE_CACHE_PROVIDER_NAME);
                }
                if (!auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.read_inprogress)) continue;
                this.indexQueue.add(auditIndexRecord);
            }
            this.printIndex();
            for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
                if (!auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.pending)) continue;
                File consumerFile = new File(auditIndexRecord.filePath);
                if (!consumerFile.exists()) {
                    logger.error("INIT: Consumer file={} not found.", (Object)consumerFile.getPath());
                    continue;
                }
                this.indexQueue.add(auditIndexRecord);
            }
        }
        catch (Throwable t) {
            logger.error("Error initializing File Spooler. queue={}", (Object)FILE_CACHE_PROVIDER_NAME, (Object)t);
            return false;
        }
        this.auditBatchSize = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_BATCH_SIZE, this.auditBatchSize);
        this.initDone = true;
        logger.debug("<== AuditFileCacheProviderSpool.init()");
        return true;
    }

    public void start() {
        if (!this.initDone) {
            logger.error("Cannot start Audit File Spooler. Initilization not done yet. queueName={}", (Object)FILE_CACHE_PROVIDER_NAME);
            return;
        }
        logger.info("Starting writerThread, queueName={}, consumer={}", (Object)FILE_CACHE_PROVIDER_NAME, (Object)this.consumerProvider.getName());
        this.destinationThread = new Thread((Runnable)this, "AuditFileCacheProviderSpool_" + this.consumerProvider.getName() + "_destWriter");
        this.destinationThread.setDaemon(true);
        this.destinationThread.start();
    }

    public void stop() {
        if (!this.initDone) {
            logger.error("Cannot stop Audit File Spooler. Initilization not done. queueName={}", (Object)FILE_CACHE_PROVIDER_NAME);
            return;
        }
        logger.info("Stop called, queueName={}, consumer={}", (Object)FILE_CACHE_PROVIDER_NAME, (Object)this.consumerProvider.getName());
        this.isDrain = true;
        this.flush();
        PrintWriter out = this.getOpenLogFileStream();
        if (out != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.isWriting) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    logger.info("Closing open file, queueName={}, consumer={}", (Object)FILE_CACHE_PROVIDER_NAME, (Object)this.consumerProvider.getName());
                    out.flush();
                    out.close();
                    break;
                }
                catch (Throwable t) {
                    logger.debug("Error closing spool out file.", t);
                }
            }
        }
        try {
            if (this.destinationThread != null) {
                this.destinationThread.interrupt();
            }
            this.destinationThread = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void flush() {
        if (!this.initDone) {
            logger.error("Cannot flush Audit File Spooler. Initilization not done. queueName={}", (Object)FILE_CACHE_PROVIDER_NAME);
            return;
        }
        PrintWriter out = this.getOpenLogFileStream();
        if (out != null) {
            out.flush();
        }
    }

    public boolean isPending() {
        if (!this.initDone) {
            this.logError("isPending(): File Spooler not initialized. queueName=AuditFileCacheProviderSpool");
            return false;
        }
        return this.isPending;
    }

    public long getLastAttemptTimeDelta() {
        if (this.lastAttemptTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.lastAttemptTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stashLogs(AuditEventBase event) {
        if (this.isDrain) {
            logger.error("stashLogs() is called after stop is called. event={}", (Object)event);
            return;
        }
        try {
            this.isWriting = true;
            PrintWriter logOut = this.getLogFileStream();
            String jsonStr = MiscUtil.stringify(event);
            logOut.println(jsonStr);
            logOut.flush();
            this.isPending = true;
            this.isSpoolingSuccessful = true;
        }
        catch (Throwable t) {
            this.isSpoolingSuccessful = false;
            logger.error("Error writing to file. event={}", (Object)event, (Object)t);
        }
        finally {
            this.isWriting = false;
        }
    }

    public synchronized void stashLogs(Collection<AuditEventBase> events) {
        for (AuditEventBase event : events) {
            this.stashLogs(event);
        }
        this.flush();
    }

    public synchronized void stashLogsString(String event) {
        if (this.isDrain) {
            logger.error("stashLogs() is called after stop is called. event={}", (Object)event);
            return;
        }
        try {
            this.isWriting = true;
            PrintWriter logOut = this.getLogFileStream();
            logOut.println(event);
        }
        catch (Exception ex) {
            logger.error("Error writing to file. event={}", (Object)event, (Object)ex);
        }
        finally {
            this.isWriting = false;
        }
    }

    public synchronized boolean isSpoolingSuccessful() {
        return this.isSpoolingSuccessful;
    }

    public synchronized void stashLogsString(Collection<String> events) {
        for (String event : events) {
            this.stashLogsString(event);
        }
        this.flush();
    }

    @Override
    public void run() {
        try {
            MDC.clear();
            this.runLogAudit();
        }
        catch (Throwable t) {
            logger.error("Exited thread without abnormaly. queue={}", (Object)this.consumerProvider.getName(), (Object)t);
        }
    }

    public void runLogAudit() {
        block10: while (true) {
            try {
                while (true) {
                    if (this.isDestDown) {
                        logger.info("Destination is down. sleeping for {} milli seconds. indexQueue={}, queueName={}, consumer={}", new Object[]{this.retryDestinationMS, this.indexQueue.size(), FILE_CACHE_PROVIDER_NAME, this.consumerProvider.getName()});
                        Thread.sleep(this.retryDestinationMS);
                    }
                    if (this.currentConsumerIndexRecord == null) {
                        this.currentConsumerIndexRecord = this.indexQueue.poll(this.retryDestinationMS, TimeUnit.MILLISECONDS);
                    } else {
                        Thread.sleep(this.retryDestinationMS);
                    }
                    if (this.isDrain) break block10;
                    if (this.currentConsumerIndexRecord == null) {
                        this.closeFileIfNeeded();
                        continue;
                    }
                    boolean isRemoveIndex = false;
                    File consumerFile = new File(this.currentConsumerIndexRecord.filePath);
                    if (!consumerFile.exists()) {
                        logger.error("Consumer file={} not found.", (Object)consumerFile.getPath());
                        this.printIndex();
                        isRemoveIndex = true;
                    } else {
                        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.currentConsumerIndexRecord.filePath), StandardCharsets.UTF_8));){
                            int startLine = this.currentConsumerIndexRecord.linePosition;
                            int currLine = 0;
                            ArrayList<AuditEventBase> events = new ArrayList<AuditEventBase>();
                            String line = br.readLine();
                            while (line != null) {
                                if (++currLine >= startLine) {
                                    AuditEventBase event = MiscUtil.fromJson(line, AuthzAuditEvent.class);
                                    events.add(event);
                                    if (events.size() == this.auditBatchSize) {
                                        boolean ret = this.sendEvent(events, this.currentConsumerIndexRecord, currLine);
                                        if (!ret) {
                                            throw new Exception("Destination down");
                                        }
                                        events.clear();
                                    }
                                }
                                line = br.readLine();
                            }
                            if (!events.isEmpty()) {
                                boolean ret = this.sendEvent(events, this.currentConsumerIndexRecord, currLine);
                                if (!ret) {
                                    throw new Exception("Destination down");
                                }
                                events.clear();
                            }
                            logger.info("Done reading file. file={}, queueName={}, consumer={}", new Object[]{this.currentConsumerIndexRecord.filePath, FILE_CACHE_PROVIDER_NAME, this.consumerProvider.getName()});
                            this.currentConsumerIndexRecord.status = SPOOL_FILE_STATUS.done;
                            this.currentConsumerIndexRecord.doneCompleteTime = new Date();
                            this.currentConsumerIndexRecord.lastAttempt = true;
                            isRemoveIndex = true;
                        }
                        catch (Exception ex) {
                            this.isDestDown = true;
                            this.logError("Destination down. queueName=AuditFileCacheProviderSpool, consumer=" + this.consumerProvider.getName());
                            this.lastAttemptTime = System.currentTimeMillis();
                            this.currentConsumerIndexRecord.lastFailedTime = new Date();
                            ++this.currentConsumerIndexRecord.failedAttemptCount;
                            this.currentConsumerIndexRecord.lastAttempt = false;
                            this.saveIndexFile();
                        }
                    }
                    if (!isRemoveIndex) continue;
                    this.removeIndexRecord(this.currentConsumerIndexRecord);
                    this.currentConsumerIndexRecord = null;
                    this.closeFileIfNeeded();
                }
            }
            catch (InterruptedException e) {
                logger.info("Caught exception in consumer thread. Shutdown might be in progress");
                continue;
            }
            catch (Throwable t) {
                logger.error("Exception in destination writing thread.", t);
                continue;
            }
            break;
        }
        logger.info("Exiting file spooler. provider={}, consumer={}", (Object)FILE_CACHE_PROVIDER_NAME, (Object)this.consumerProvider.getName());
    }

    void loadIndexFile() throws IOException {
        logger.info("Loading index file. fileName={}", (Object)this.indexFile.getPath());
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.indexFile), StandardCharsets.UTF_8));){
            this.indexRecords.clear();
            String line = br.readLine();
            while (line != null) {
                if (!line.isEmpty() && !line.startsWith("#")) {
                    try {
                        AuditIndexRecord record = MiscUtil.fromJson(line, AuditIndexRecord.class);
                        this.indexRecords.add(record);
                    }
                    catch (Exception e) {
                        logger.error("Error parsing following JSON: {}", (Object)line, (Object)e);
                    }
                }
                line = br.readLine();
            }
        }
    }

    synchronized void printIndex() {
        logger.info("INDEX printIndex() ==== START");
        for (AuditIndexRecord record : this.indexRecords) {
            logger.info("INDEX={}, isFileExist={}", (Object)record, (Object)new File(record.filePath).exists());
        }
        logger.info("INDEX printIndex() ==== END");
    }

    synchronized void removeIndexRecord(AuditIndexRecord indexRecord) throws IOException {
        Iterator<AuditIndexRecord> iter = this.indexRecords.iterator();
        while (iter.hasNext()) {
            AuditIndexRecord record = iter.next();
            if (!record.id.equals(indexRecord.id)) continue;
            logger.info("Removing file from index. file={}, queueName={}, consumer={}", new Object[]{record.filePath, FILE_CACHE_PROVIDER_NAME, this.consumerProvider.getName()});
            iter.remove();
            this.appendToDoneFile(record);
        }
        this.saveIndexFile();
        if (this.indexRecords.isEmpty()) {
            this.isPending = false;
        }
    }

    synchronized void saveIndexFile() throws IOException {
        PrintWriter out = new PrintWriter(this.indexFile, StandardCharsets.UTF_8.name());
        for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
            out.println(MiscUtil.stringify(auditIndexRecord));
        }
        out.close();
    }

    void appendToDoneFile(AuditIndexRecord indexRecord) throws IOException {
        block22: {
            logger.info("Moving to done file. {}, queueName={}, consumer={}", new Object[]{indexRecord.filePath, FILE_CACHE_PROVIDER_NAME, this.consumerProvider.getName()});
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.indexDoneFile, true), StandardCharsets.UTF_8)));){
                String line = MiscUtil.stringify(indexRecord);
                out.println(line);
                out.flush();
            }
            this.consumerProvider.flush();
            File logFile = null;
            File archiveFile = null;
            try {
                logFile = new File(indexRecord.filePath);
                archiveFile = new File(this.archiveFolder, logFile.getName());
                logger.info("Moving logFile {} to {}", (Object)logFile, (Object)archiveFile);
                boolean result = logFile.renameTo(archiveFile);
                if (!result) {
                    logger.error("Error moving log file to archive folder. Unable to rename {} to archiveFile={}", (Object)logFile, (Object)archiveFile);
                }
            }
            catch (Throwable t) {
                logger.error("Error moving log file to archive folder. logFile={}, archiveFile={}", new Object[]{logFile, archiveFile, t});
            }
            this.consumerProvider.flush();
            archiveFile = null;
            try {
                File[] logFiles = this.archiveFolder.listFiles(pathname -> pathname.getName().toLowerCase().endsWith(".log"));
                if (logFiles == null || logFiles.length <= this.maxArchiveFiles) break block22;
                int filesToDelete = logFiles.length - this.maxArchiveFiles;
                try (BufferedReader br = new BufferedReader(new FileReader(this.indexDoneFile));){
                    int filesDeletedCount = 0;
                    String line = br.readLine();
                    while (line != null) {
                        block23: {
                            if (!line.isEmpty() && !line.startsWith("#")) {
                                try {
                                    AuditIndexRecord record = MiscUtil.fromJson(line, AuditIndexRecord.class);
                                    if (record == null) {
                                        logger.warn("failed to parse index record: {}", (Object)line);
                                        break block23;
                                    }
                                    logFile = new File(record.filePath);
                                    archiveFile = new File(this.archiveFolder, logFile.getName());
                                    if (!archiveFile.exists()) break block23;
                                    logger.info("Deleting archive file {}", (Object)archiveFile);
                                    boolean ret = archiveFile.delete();
                                    if (!ret) {
                                        logger.error("Error deleting archive file. archiveFile={}", (Object)archiveFile);
                                    }
                                    if (++filesDeletedCount < filesToDelete) break block23;
                                    logger.info("Deleted {} files", (Object)filesDeletedCount);
                                    break;
                                }
                                catch (Exception e) {
                                    logger.error("Error parsing following JSON: {}", (Object)line, (Object)e);
                                }
                            }
                        }
                        line = br.readLine();
                    }
                }
            }
            catch (Throwable t) {
                logger.error("Error deleting older archive file. archiveFile={}", (Object)archiveFile, (Object)t);
            }
        }
    }

    void logError(String msg) {
        long currTimeMS = System.currentTimeMillis();
        if (currTimeMS - this.lastErrorLogMS > (long)this.errorLogIntervalMS) {
            logger.error(msg);
            this.lastErrorLogMS = currTimeMS;
        }
    }

    private synchronized PrintWriter getOpenLogFileStream() {
        return this.logWriter;
    }

    private synchronized PrintWriter getLogFileStream() throws Exception {
        this.closeFileIfNeeded();
        if (this.currentWriterIndexRecord == null) {
            File outLogFile;
            String fileName;
            Date currentTime = new Date();
            String newFileName = fileName = MiscUtil.replaceTokens(this.logFileNameFormat, currentTime.getTime());
            int i = 0;
            while (true) {
                outLogFile = new File(this.logFolder, newFileName);
                File archiveLogFile = new File(this.archiveFolder, newFileName);
                if (!outLogFile.exists() && !archiveLogFile.exists()) break;
                int lastDot = fileName.lastIndexOf(46);
                String baseName = fileName.substring(0, lastDot);
                String extension = fileName.substring(lastDot);
                newFileName = baseName + "." + ++i + extension;
            }
            fileName = newFileName;
            logger.info("Creating new file. queueName={}, fileName={}", (Object)FILE_CACHE_PROVIDER_NAME, (Object)fileName);
            this.logWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outLogFile), StandardCharsets.UTF_8)));
            AuditIndexRecord tmpIndexRecord = new AuditIndexRecord();
            tmpIndexRecord.id = MiscUtil.generateUniqueId();
            tmpIndexRecord.filePath = outLogFile.getPath();
            tmpIndexRecord.status = SPOOL_FILE_STATUS.write_inprogress;
            tmpIndexRecord.fileCreateTime = currentTime;
            tmpIndexRecord.lastAttempt = true;
            this.currentWriterIndexRecord = tmpIndexRecord;
            this.indexRecords.add(this.currentWriterIndexRecord);
            this.saveIndexFile();
        } else if (this.logWriter == null) {
            logger.info("Opening existing file for append. queueName={}, fileName={}", (Object)FILE_CACHE_PROVIDER_NAME, (Object)this.currentWriterIndexRecord.filePath);
            this.logWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentWriterIndexRecord.filePath, true), StandardCharsets.UTF_8)));
        }
        return this.logWriter;
    }

    private synchronized void closeFileIfNeeded() throws IOException {
        if (this.currentWriterIndexRecord != null) {
            this.rollOverSpoolFileByTime();
            if (this.closeFile) {
                if (this.logWriter != null) {
                    this.logWriter.flush();
                    this.logWriter.close();
                    this.logWriter = null;
                    this.closeFile = false;
                }
                this.currentWriterIndexRecord.status = SPOOL_FILE_STATUS.pending;
                this.currentWriterIndexRecord.writeCompleteTime = new Date();
                this.saveIndexFile();
                logger.info("Adding file to queue. queueName={}, fileName={}", (Object)FILE_CACHE_PROVIDER_NAME, (Object)this.currentWriterIndexRecord.filePath);
                this.indexQueue.add(this.currentWriterIndexRecord);
                this.currentWriterIndexRecord = null;
            }
        }
    }

    private void rollOverSpoolFileByTime() {
        if (System.currentTimeMillis() - this.currentWriterIndexRecord.fileCreateTime.getTime() > (long)this.fileRolloverSec * 1000L) {
            this.closeFile = true;
            logger.info("Closing file. Rolling over. queueName={}, fileName={}", (Object)FILE_CACHE_PROVIDER_NAME, (Object)this.currentWriterIndexRecord.filePath);
        }
    }

    private boolean sendEvent(List<AuditEventBase> events, AuditIndexRecord indexRecord, int currLine) {
        boolean ret = true;
        try {
            ret = this.consumerProvider.log(events);
            if (!ret) {
                this.logError("Error sending logs to consumer. provider=AuditFileCacheProviderSpool, consumer=" + this.consumerProvider.getName());
            } else {
                indexRecord.linePosition = currLine;
                indexRecord.status = SPOOL_FILE_STATUS.read_inprogress;
                indexRecord.lastSuccessTime = new Date();
                indexRecord.lastAttempt = true;
                this.saveIndexFile();
                if (this.isDestDown) {
                    this.isDestDown = false;
                    logger.info("Destination up now. {}, queueName={}, consumer={}", new Object[]{indexRecord.filePath, FILE_CACHE_PROVIDER_NAME, this.consumerProvider.getName()});
                }
            }
        }
        catch (Throwable t) {
            logger.error("Error while sending logs to consumer. provider={}, consumer={}, log={}", new Object[]{FILE_CACHE_PROVIDER_NAME, this.consumerProvider.getName(), events, t});
        }
        return ret;
    }

    static class AuditIndexRecord {
        String id;
        String filePath;
        int linePosition;
        SPOOL_FILE_STATUS status = SPOOL_FILE_STATUS.write_inprogress;
        Date fileCreateTime;
        Date writeCompleteTime;
        Date doneCompleteTime;
        Date lastSuccessTime;
        Date lastFailedTime;
        int failedAttemptCount;
        boolean lastAttempt;

        AuditIndexRecord() {
        }

        public String toString() {
            return "AuditIndexRecord [id=" + this.id + ", filePath=" + this.filePath + ", linePosition=" + this.linePosition + ", status=" + (Object)((Object)this.status) + ", fileCreateTime=" + this.fileCreateTime + ", writeCompleteTime=" + this.writeCompleteTime + ", doneCompleteTime=" + this.doneCompleteTime + ", lastSuccessTime=" + this.lastSuccessTime + ", lastFailedTime=" + this.lastFailedTime + ", failedAttemptCount=" + this.failedAttemptCount + ", lastAttempt=" + this.lastAttempt + "]";
        }
    }

    public static enum SPOOL_FILE_STATUS {
        pending,
        write_inprogress,
        read_inprogress,
        done;

    }
}

