/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.BaseAuditHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDestAuditProvider
extends BaseAuditHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MultiDestAuditProvider.class);
    static final String DEFAULT_NAME = "multi_dest";
    protected List<AuditHandler> mProviders = new ArrayList<AuditHandler>();

    public MultiDestAuditProvider() {
        LOG.info("MultiDestAuditProvider: creating..");
        this.setName(DEFAULT_NAME);
    }

    public MultiDestAuditProvider(AuditHandler provider) {
        LOG.info("MultiDestAuditProvider(): provider={}", (Object)(provider == null ? null : provider.getName()));
        this.setName(DEFAULT_NAME);
        this.addAuditProvider(provider);
    }

    public void addAuditProvider(AuditHandler provider) {
        if (provider != null) {
            LOG.debug("MultiDestAuditProvider.addAuditProvider(providerType={})", (Object)provider.getClass().getCanonicalName());
            this.mProviders.add(provider);
            if (provider instanceof BaseAuditHandler) {
                ((BaseAuditHandler)provider).setParentPath(this.getName());
            }
        }
    }

    public void addAuditProviders(List<AuditHandler> providers) {
        if (providers != null) {
            for (AuditHandler provider : providers) {
                LOG.info("Adding {} as consumer to MultiDestination {}", (Object)provider.getName(), (Object)this.getName());
                this.addAuditProvider(provider);
            }
        }
    }

    @Override
    public boolean log(AuditEventBase event) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.log(event);
            }
            catch (Throwable excp) {
                this.logFailedEvent(event, excp);
            }
        }
        return true;
    }

    @Override
    public boolean logJSON(String event) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.logJSON(event);
            }
            catch (Throwable excp) {
                this.logFailedEventJSON(event, excp);
            }
        }
        return true;
    }

    @Override
    public boolean logJSON(Collection<String> events) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.logJSON(events);
            }
            catch (Throwable excp) {
                this.logFailedEventJSON(events, excp);
            }
        }
        return true;
    }

    @Override
    public boolean logFile(File file) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.logFile(file);
            }
            catch (Throwable excp) {
                this.logFailedEventJSON(file.getAbsolutePath(), excp);
            }
        }
        return true;
    }

    @Override
    public void init(Properties props) {
        LOG.info("MultiDestAuditProvider.init()");
        super.init(props);
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.init(props);
            }
            catch (Throwable excp) {
                LOG.info("MultiDestAuditProvider.init(): failed {}", (Object)provider.getClass().getCanonicalName(), (Object)excp);
            }
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        for (AuditHandler provider : this.mProviders) {
            if (!(provider instanceof BaseAuditHandler)) continue;
            ((BaseAuditHandler)provider).setParentPath(this.getName());
        }
    }

    @Override
    public void setParentPath(String parentPath) {
        super.setParentPath(parentPath);
        for (AuditHandler provider : this.mProviders) {
            if (!(provider instanceof BaseAuditHandler)) continue;
            ((BaseAuditHandler)provider).setParentPath(this.getName());
        }
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.log(events);
            }
            catch (Throwable excp) {
                this.logFailedEvent(events, excp);
            }
        }
        return true;
    }

    @Override
    public void start() {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.start();
            }
            catch (Throwable excp) {
                LOG.error("MultiDestAuditProvider.start(): failed for provider { {} }", (Object)provider.getClass().getName(), (Object)excp);
            }
        }
    }

    @Override
    public void stop() {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.stop();
            }
            catch (Throwable excp) {
                LOG.error("MultiDestAuditProvider.stop(): failed for provider { {} }", (Object)provider.getClass().getName(), (Object)excp);
            }
        }
    }

    @Override
    public void waitToComplete() {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.waitToComplete();
            }
            catch (Throwable excp) {
                LOG.error("MultiDestAuditProvider.waitToComplete(): failed for provider { {} }", (Object)provider.getClass().getName(), (Object)excp);
            }
        }
    }

    @Override
    public void waitToComplete(long timeout) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.waitToComplete(timeout);
            }
            catch (Throwable excp) {
                LOG.error("MultiDestAuditProvider.waitToComplete(): failed for provider { {} }", (Object)provider.getClass().getName(), (Object)excp);
            }
        }
    }

    @Override
    public void flush() {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.flush();
            }
            catch (Throwable excp) {
                LOG.error("MultiDestAuditProvider.flush(): failed for provider { {} }", (Object)provider.getClass().getName(), (Object)excp);
            }
        }
    }
}

