/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.dgc.VMID;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.util.PlatformName;
import org.apache.ranger.authorization.hadoop.utils.RangerCredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiscUtil {
    private static final Logger logger = LoggerFactory.getLogger(MiscUtil.class);
    public static final String TOKEN_START = "%";
    public static final String TOKEN_END = "%";
    public static final String TOKEN_HOSTNAME = "hostname";
    public static final String TOKEN_APP_TYPE = "app-type";
    public static final String TOKEN_JVM_INSTANCE = "jvm-instance";
    public static final String TOKEN_TIME = "time:";
    public static final String TOKEN_PROPERTY = "property:";
    public static final String TOKEN_ENV = "env:";
    public static final String ESCAPE_STR = "\\";
    public static final String LINE_SEPARATOR = System.lineSeparator();
    private static String sApplicationType;
    private static UserGroupInformation ugiLoginUser;
    private static Subject subjectLoginUser;
    private static String localHostname;
    private static final Map<String, LogHistory> logHistoryList;
    private static final int logInterval = 30000;
    private static final VMID sJvmID;
    private static final ThreadLocal<ObjectMapper> MAPPER;

    private MiscUtil() {
    }

    public static ObjectMapper getMapper() {
        return MAPPER.get();
    }

    public static String replaceTokens(String str, long time) {
        int tagEndPos;
        int tagStartPos;
        if (str == null) {
            return str;
        }
        if (time <= 0L) {
            time = System.currentTimeMillis();
        }
        int startPos = 0;
        while (startPos < str.length() && (tagStartPos = str.indexOf("%", startPos)) != -1 && (tagEndPos = str.indexOf("%", tagStartPos + "%".length())) != -1) {
            String tag = str.substring(tagStartPos, tagEndPos + "%".length());
            String token = tag.substring("%".length(), tag.lastIndexOf("%"));
            String val = "";
            if (token.equals(TOKEN_HOSTNAME)) {
                val = MiscUtil.getHostname();
            } else if (token.equals(TOKEN_APP_TYPE)) {
                val = MiscUtil.getApplicationType();
            } else if (token.equals(TOKEN_JVM_INSTANCE)) {
                val = MiscUtil.getJvmInstanceId();
            } else if (token.startsWith(TOKEN_PROPERTY)) {
                String propertyName = token.substring(TOKEN_PROPERTY.length());
                val = MiscUtil.getSystemProperty(propertyName);
            } else if (token.startsWith(TOKEN_ENV)) {
                String envName = token.substring(TOKEN_ENV.length());
                val = MiscUtil.getEnv(envName);
            } else if (token.startsWith(TOKEN_TIME)) {
                String dtFormat = token.substring(TOKEN_TIME.length());
                val = MiscUtil.getFormattedTime(time, dtFormat);
            }
            if (val == null) {
                val = "";
            }
            str = str.substring(0, tagStartPos) + val + str.substring(tagEndPos + "%".length());
            startPos = tagStartPos + val.length();
        }
        return str;
    }

    public static String getHostname() {
        String ret = localHostname;
        if (ret == null) {
            MiscUtil.initLocalHost();
            ret = localHostname;
            if (ret == null) {
                ret = "unknown";
            }
        }
        return ret;
    }

    public static String getApplicationType() {
        return sApplicationType;
    }

    public static void setApplicationType(String applicationType) {
        sApplicationType = applicationType;
    }

    public static String getJvmInstanceId() {
        int val = sJvmID.toString().hashCode();
        return Long.toString(Math.abs((long)val));
    }

    public static String getSystemProperty(String propertyName) {
        String ret = null;
        try {
            ret = propertyName != null ? System.getProperty(propertyName) : null;
        }
        catch (Exception excp) {
            logger.warn("getSystemProperty({}) failed", (Object)propertyName, (Object)excp);
        }
        return ret;
    }

    public static String getEnv(String envName) {
        String ret = null;
        try {
            ret = envName != null ? System.getenv(envName) : null;
        }
        catch (Exception excp) {
            logger.warn("getenv({}) failed", (Object)envName, (Object)excp);
        }
        return ret;
    }

    public static String getFormattedTime(long time, String format) {
        String ret = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            ret = sdf.format(time);
        }
        catch (Exception excp) {
            logger.warn("SimpleDateFormat.format() failed: {}", (Object)format, (Object)excp);
        }
        return ret;
    }

    public static void createParents(File file) {
        File parentDir;
        String parentName;
        if (file != null && (parentName = file.getParent()) != null && !(parentDir = new File(parentName)).exists() && !parentDir.mkdirs()) {
            logger.warn("createParents(): failed to create {}", (Object)parentDir.getAbsolutePath());
        }
    }

    public static long getNextRolloverTime(long lastRolloverTime, long interval) {
        long now = System.currentTimeMillis() / 1000L * 1000L;
        if (lastRolloverTime <= 0L) {
            return now + interval;
        }
        if (lastRolloverTime <= now) {
            long nextRolloverTime = now + interval;
            long trimInterval = (nextRolloverTime - lastRolloverTime) % interval;
            return nextRolloverTime - trimInterval;
        }
        return lastRolloverTime;
    }

    public static long getRolloverStartTime(long nextRolloverTime, long interval) {
        return nextRolloverTime <= interval ? System.currentTimeMillis() : nextRolloverTime - interval;
    }

    public static int parseInteger(String str, int defValue) {
        int ret = defValue;
        if (str != null) {
            try {
                ret = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String generateUniqueId() {
        return UUID.randomUUID().toString();
    }

    public static String generateGuid() {
        byte[] randomBytes = new byte[16];
        RandomHolder.random.nextBytes(randomBytes);
        UUID uuid = UUID.nameUUIDFromBytes(randomBytes);
        return uuid.toString();
    }

    public static <T> String stringify(T log) {
        String ret = null;
        if (log != null) {
            if (log instanceof String) {
                ret = (String)log;
            } else if (MiscUtil.getMapper() != null) {
                try {
                    ret = MiscUtil.getMapper().writeValueAsString(log);
                }
                catch (Exception e) {
                    logger.error("Error occurred while processing JSOn object {}", log, (Object)e);
                    ret = log.toString();
                }
            } else {
                ret = log.toString();
            }
        }
        return ret;
    }

    public static <T> T fromJson(String jsonStr, Class<T> clazz) {
        try {
            return (T)MiscUtil.getMapper().readValue(jsonStr, clazz);
        }
        catch (Exception exception) {
            logger.error("Error occurred while processing JSOn object {}", (Object)jsonStr, (Object)exception);
            return null;
        }
    }

    public static String getStringProperty(Properties props, String propName) {
        String val;
        String ret = null;
        if (props != null && propName != null && (val = props.getProperty(propName)) != null) {
            ret = val;
        }
        return ret;
    }

    public static String getStringProperty(Properties props, String propName, String defValue) {
        String val;
        String ret = defValue;
        if (props != null && propName != null && (val = props.getProperty(propName)) != null) {
            ret = val;
        }
        return ret;
    }

    public static boolean getBooleanProperty(Properties props, String propName, boolean defValue) {
        String val;
        boolean ret = defValue;
        if (props != null && propName != null && (val = props.getProperty(propName)) != null) {
            ret = Boolean.parseBoolean(val);
        }
        return ret;
    }

    public static int getIntProperty(Properties props, String propName, int defValue) {
        String val;
        int ret = defValue;
        if (props != null && propName != null && (val = props.getProperty(propName)) != null) {
            try {
                ret = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static long getLongProperty(Properties props, String propName, long defValue) {
        String val;
        long ret = defValue;
        if (props != null && propName != null && (val = props.getProperty(propName)) != null) {
            try {
                ret = Long.parseLong(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static Map<String, String> getPropertiesWithPrefix(Properties props, String prefix) {
        HashMap<String, String> prefixedProperties = new HashMap<String, String>();
        if (props != null && prefix != null) {
            for (String key : props.stringPropertyNames()) {
                if (key == null) continue;
                String val = props.getProperty(key);
                if (!key.startsWith(prefix)) continue;
                key = key.substring(prefix.length());
                prefixedProperties.put(key, val);
            }
        }
        return prefixedProperties;
    }

    public static List<String> toArray(String destListStr, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        if (destListStr != null && !destListStr.isEmpty()) {
            StringTokenizer tokenizer = new StringTokenizer(destListStr, delim.trim());
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        return list;
    }

    public static String getCredentialString(String url, String alias) {
        if (url != null && alias != null) {
            return RangerCredentialProvider.getInstance().getCredentialString(url, alias);
        }
        return null;
    }

    public static UserGroupInformation createUGIFromSubject(Subject subject) throws IOException {
        logger.info("SUBJECT {}", (Object)(subject == null ? "not found" : "found"));
        UserGroupInformation ugi = null;
        if (subject != null) {
            logger.info("SUBJECT.PRINCIPALS.size()={}", (Object)subject.getPrincipals().size());
            Set<Principal> principals = subject.getPrincipals();
            for (Principal principal : principals) {
                logger.info("SUBJECT.PRINCIPAL.NAME={}", (Object)principal.getName());
            }
            try {
                UserGroupInformation.getLoginUser();
                logger.info("Default UGI before using new Subject:{}", (Object)UserGroupInformation.getLoginUser());
            }
            catch (Throwable t) {
                logger.error("failed to get login user", t);
            }
            ugi = UserGroupInformation.getUGIFromSubject((Subject)subject);
            logger.info("SUBJECT.UGI.NAME={}, ugi={}", (Object)ugi.getUserName(), (Object)ugi);
        } else {
            logger.info("Server username is not available");
        }
        return ugi;
    }

    public static void setUGILoginUser(UserGroupInformation newUGI, Subject newSubject) {
        if (newUGI != null) {
            UserGroupInformation.setLoginUser((UserGroupInformation)newUGI);
            ugiLoginUser = newUGI;
            logger.info("Setting UGI={}", (Object)newUGI);
        } else {
            logger.error("UGI is null. Not setting it.");
        }
        if (newSubject != null) {
            logger.info("Setting SUBJECT");
            subjectLoginUser = newSubject;
        }
    }

    public static UserGroupInformation getUGILoginUser() {
        UserGroupInformation ret = ugiLoginUser;
        if (ret == null) {
            try {
                ret = MiscUtil.getLoginUser();
            }
            catch (IOException e) {
                logger.error("Error getting UGI.", (Throwable)e);
            }
        }
        if (ret != null) {
            try {
                ret.checkTGTAndReloginFromKeytab();
            }
            catch (IOException ioe) {
                logger.error("Error renewing TGT and relogin. Ignoring Exception, and continuing with the old TGT", (Throwable)ioe);
            }
        }
        return ret;
    }

    public static <X> X executePrivilegedAction(PrivilegedExceptionAction<X> action) throws Exception {
        UserGroupInformation ugi = MiscUtil.getUGILoginUser();
        if (ugi != null) {
            return (X)ugi.doAs(action);
        }
        return action.run();
    }

    public static <X> X executePrivilegedAction(PrivilegedAction<X> action) {
        UserGroupInformation ugi = MiscUtil.getUGILoginUser();
        if (ugi != null) {
            return (X)ugi.doAs(action);
        }
        return action.run();
    }

    public static Subject getSubjectLoginUser() {
        return subjectLoginUser;
    }

    public static String getKerberosNamesRules() {
        return KerberosName.getRules();
    }

    public static String getShortNameFromPrincipalName(String principal) {
        if (principal == null) {
            return null;
        }
        try {
            KerberosName kerbrosName = new KerberosName(principal);
            String userName = kerbrosName.getShortName();
            userName = StringUtils.substringBefore((String)userName, (String)"/");
            userName = StringUtils.substringBefore((String)userName, (String)"@");
            return userName;
        }
        catch (Throwable t) {
            logger.error("Error converting kerberos name. principal={}, KerberosName.rules={}", (Object)principal, (Object)KerberosName.getRules());
            return principal;
        }
    }

    public static Set<String> getGroupsForRequestUser(String userName) {
        if (userName != null) {
            try {
                UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)userName);
                String[] groups = ugi.getGroupNames();
                if (groups != null && groups.length > 0) {
                    return new HashSet<String>(Arrays.asList(groups));
                }
            }
            catch (Throwable e) {
                MiscUtil.logErrorMessageByInterval(logger, "Error getting groups for users. userName=" + userName, e);
            }
        }
        return Collections.emptySet();
    }

    public static boolean logErrorMessageByInterval(Logger useLogger, String message) {
        return MiscUtil.logErrorMessageByInterval(useLogger, message, null);
    }

    public static boolean logErrorMessageByInterval(Logger useLogger, String message, Throwable e) {
        if (message == null) {
            return false;
        }
        LogHistory log = logHistoryList.computeIfAbsent(message, k -> new LogHistory());
        if (System.currentTimeMillis() - log.lastLogTime > 30000L) {
            log.lastLogTime = System.currentTimeMillis();
            int counter = log.counter;
            log.counter = 0;
            if (counter > 0) {
                message = message + ". Messages suppressed before: " + counter;
            }
            if (e == null) {
                useLogger.error(message);
            } else {
                useLogger.error(message, e);
            }
            return true;
        }
        ++log.counter;
        return false;
    }

    public static void setUGIFromJAASConfig(String jaasConfigAppName) throws Exception {
        String keytabFile = null;
        String principal = null;
        UserGroupInformation ugi = null;
        logger.debug("===> MiscUtil.setUGIFromJAASConfig() jaasConfigAppName: {}", (Object)jaasConfigAppName);
        try {
            Object[] entries = Configuration.getConfiguration().getAppConfigurationEntry(jaasConfigAppName);
            if (!ArrayUtils.isEmpty((Object[])entries)) {
                for (Object entry : entries) {
                    if (((AppConfigurationEntry)entry).getOptions().get("keyTab") != null) {
                        keytabFile = (String)((AppConfigurationEntry)entry).getOptions().get("keyTab");
                    }
                    if (((AppConfigurationEntry)entry).getOptions().get("principal") != null) {
                        principal = (String)((AppConfigurationEntry)entry).getOptions().get("principal");
                    }
                    if (!StringUtils.isEmpty(principal) && !StringUtils.isEmpty((String)keytabFile)) break;
                }
                if (StringUtils.isEmpty(principal) || StringUtils.isEmpty(keytabFile)) {
                    String errorMesage = "Unable to get the principal/keytab from jaasConfigAppName: " + jaasConfigAppName;
                    logger.error(errorMesage);
                    throw new Exception(errorMesage);
                }
                UserGroupInformation.loginUserFromKeytab(principal, keytabFile);
                ugi = UserGroupInformation.getLoginUser();
                logger.info("MiscUtil.setUGIFromJAASConfig() UGI: {} principal: {} keytab: {}", new Object[]{ugi, principal, keytabFile});
            } else {
                logger.warn("JAASConfig file not found! Ranger Plugin will not working in a Secure Cluster...");
            }
        }
        catch (Exception e) {
            logger.error("Unable to set UGI for Principal: {} keytab: {}", principal, keytabFile);
            throw e;
        }
        logger.debug("<=== MiscUtil.setUGIFromJAASConfig() jaasConfigAppName: {} UGI: {} principal: {} keytab: {}", new Object[]{jaasConfigAppName, ugi, principal, keytabFile});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void authWithKerberos(String keytab, String principal, String nameRules) {
        block18: {
            if (keytab == null || principal == null) {
                return;
            }
            Subject serverSubject = new Subject();
            int successLoginCount = 0;
            try {
                boolean useKeytab;
                String[] spnegoPrincipals;
                if (principal.equals("*")) {
                    spnegoPrincipals = KerberosUtil.getPrincipalNames((String)keytab, (Pattern)Pattern.compile("HTTP/.*"));
                    if (spnegoPrincipals.length == 0) {
                        logger.error("No principals found in keytab={}", (Object)keytab);
                    }
                } else {
                    spnegoPrincipals = new String[]{principal};
                }
                if (nameRules != null) {
                    KerberosName.setRules((String)nameRules);
                }
                if (!(useKeytab = true)) {
                    logger.info("Creating UGI with subject");
                    LoginContext loginContext = null;
                    ArrayList<LoginContext> loginContexts = new ArrayList<LoginContext>();
                    for (String spnegoPrincipal : spnegoPrincipals) {
                        try {
                            logger.info("Login using keytab {}, for principal {}", (Object)keytab, (Object)spnegoPrincipal);
                            KerberosConfiguration kerberosConfiguration = new KerberosConfiguration(keytab, spnegoPrincipal);
                            loginContext = new LoginContext("", serverSubject, null, kerberosConfiguration);
                            loginContext.login();
                            ++successLoginCount;
                            logger.info("Login success keytab {}, for principal {}", (Object)keytab, (Object)spnegoPrincipal);
                            loginContexts.add(loginContext);
                        }
                        catch (Throwable t) {
                            logger.error("Login failed keytab {}, for principal {}", new Object[]{keytab, spnegoPrincipal, t});
                        }
                        if (successLoginCount > 0) {
                            logger.info("Total login success count={}", (Object)successLoginCount);
                            try {
                                UserGroupInformation.loginUserFromSubject((Subject)serverSubject);
                                continue;
                            }
                            catch (Throwable e) {
                                logger.error("Error creating UGI from subject. subject={}", (Object)serverSubject);
                                continue;
                            }
                            finally {
                                if (loginContext != null) {
                                    loginContext.logout();
                                }
                            }
                        }
                        logger.error("Total logins were successfull from keytab={}, principal={}", (Object)keytab, (Object)principal);
                    }
                    break block18;
                }
                logger.info("Creating UGI from keytab directly. keytab={}, principal={}", (Object)keytab, (Object)spnegoPrincipals[0]);
                UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)spnegoPrincipals[0], (String)keytab);
                MiscUtil.setUGILoginUser(ugi, null);
            }
            catch (Throwable t) {
                logger.error("Failed to login with given keytab and principal", t);
            }
        }
    }

    public static void loginWithKeyTab(String keytab, String principal, String nameRules) {
        logger.debug("==> MiscUtil.loginWithKeyTab() keytab={} principal={} nameRules={}}", new Object[]{keytab, principal, nameRules});
        if (keytab == null || principal == null) {
            logger.error("Failed to login as keytab or principal is null!");
            return;
        }
        try {
            String[] spnegoPrincipals;
            if (principal.equals("*")) {
                spnegoPrincipals = KerberosUtil.getPrincipalNames((String)keytab, (Pattern)Pattern.compile("HTTP/.*"));
                if (spnegoPrincipals.length == 0) {
                    logger.error("No principals found in keytab= {}", (Object)keytab);
                }
            } else {
                spnegoPrincipals = new String[]{principal};
            }
            if (nameRules != null) {
                KerberosName.setRules((String)nameRules);
            }
            logger.info("Creating UGI from keytab directly. keytab={}, principal={}", (Object)keytab, (Object)spnegoPrincipals[0]);
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)spnegoPrincipals[0], (String)keytab);
            MiscUtil.setUGILoginUser(ugi, null);
        }
        catch (Exception e) {
            logger.error("Failed to login with given keytab={} principal={} nameRules={}", new Object[]{keytab, principal, nameRules, e});
        }
        logger.debug("<== MiscUtil.loginWithKeyTab()");
    }

    public static UserGroupInformation getLoginUser() throws IOException {
        return UserGroupInformation.getLoginUser();
    }

    public static Date getUTCDateForLocalDate(Date date) {
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT+0");
        Calendar local = Calendar.getInstance();
        int offset = local.getTimeZone().getOffset(local.getTimeInMillis());
        GregorianCalendar utc = new GregorianCalendar(gmtTimeZone);
        utc.setTimeInMillis(date.getTime());
        utc.add(14, -offset);
        return utc.getTime();
    }

    public static Date getUTCDate() {
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT+0");
        Calendar local = Calendar.getInstance();
        int offset = local.getTimeZone().getOffset(local.getTimeInMillis());
        GregorianCalendar utc = new GregorianCalendar(gmtTimeZone);
        utc.setTimeInMillis(local.getTimeInMillis());
        utc.add(14, -offset);
        return utc.getTime();
    }

    public static int toInt(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value.toString().isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Throwable t) {
            logger.error("Error converting value to integer. Value={}", value, (Object)t);
            return 0;
        }
    }

    public static long toLong(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value.toString().isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (Throwable t) {
            logger.error("Error converting value to long. Value={}", value, (Object)t);
            return 0L;
        }
    }

    public static Date toDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        try {
            return new Date(value.toString());
        }
        catch (Throwable t) {
            logger.error("toDate => Error converting value to date. Value={}", value, (Object)t);
            return null;
        }
    }

    public static Date toLocalDate(Object value) {
        long lontong = new Long(value.toString());
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        try {
            Date currentTime1 = new Date(lontong);
            SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            String dateString1 = formatter1.format(currentTime1);
            Date date = formatter1.parse(dateString1);
            return date;
        }
        catch (Throwable t) {
            logger.error("toLocalDate => Error converting value to date. Value={}", value, (Object)t);
            return null;
        }
    }

    private static void initLocalHost() {
        logger.debug("==> MiscUtil.initLocalHost()");
        try {
            localHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable excp) {
            logger.warn("getHostname()", excp);
        }
        logger.debug("<== MiscUtil.initLocalHost()");
    }

    static {
        logHistoryList = new Hashtable<String, LogHistory>();
        sJvmID = new VMID();
        MAPPER = ThreadLocal.withInitial(() -> {
            ObjectMapper objectMapper = new ObjectMapper();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            objectMapper.setDateFormat((DateFormat)dateFormat);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            return objectMapper;
        });
        MiscUtil.initLocalHost();
    }

    private static class RandomHolder {
        static final Random random = new Random();

        private RandomHolder() {
        }
    }

    private static class KerberosConfiguration
    extends Configuration {
        private final String keytab;
        private final String principal;

        public KerberosConfiguration(String keytab, String principal) {
            this.keytab = keytab;
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                options.put("useKeytab", this.keytab.startsWith("file://") ? this.keytab : "file://" + this.keytab);
                options.put("principal", this.principal);
                options.put("credsType", "acceptor");
            } else {
                options.put("keyTab", this.keytab);
                options.put("principal", this.principal);
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("isInitiator", "false");
            }
            options.put("refreshKrb5Config", "true");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                if (PlatformName.IBM_JAVA) {
                    options.put("useDefaultCcache", "true");
                    System.setProperty("KRB5CCNAME", ticketCache);
                    options.put("renewTGT", "true");
                    options.put("credsType", "both");
                } else {
                    options.put("ticketCache", ticketCache);
                }
            }
            if (logger.isDebugEnabled()) {
                options.put("debug", "true");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    static class LogHistory {
        long lastLogTime;
        int counter;

        LogHistory() {
        }
    }
}

