/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAuditHandler
implements AuditHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAuditHandler.class);
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE = "xasecure.policymgr.clientssl.keystore";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE = "xasecure.policymgr.clientssl.keystore.type";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.keystore.credential.file";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS = "sslKeyStore";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE_DEFAULT = "jks";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE = "xasecure.policymgr.clientssl.truststore";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE = "xasecure.policymgr.clientssl.truststore.type";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.truststore.credential.file";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS = "sslTrustStore";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE_DEFAULT = "jks";
    public static final String RANGER_SSL_KEYMANAGER_ALGO_TYPE = KeyManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_TRUSTMANAGER_ALGO_TYPE = TrustManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_CONTEXT_ALGO_TYPE = "TLSv1.2";
    public static final String PROP_CONFIG = "config";
    public static final String FAILED_TO_LOG_AUDIT_EVENT = "failed to log audit event: {}";
    public static final String PROP_NAME = "name";
    public static final String PROP_CLASS_NAME = "classname";
    public static final String PROP_DEFAULT_PREFIX = "xasecure.audit.provider";
    static final String AUDIT_LOG_FAILURE_REPORT_MIN_INTERVAL_PROP = "xasecure.audit.log.failure.report.min.interval.ms";
    static final String AUDIT_LOG_STATUS_LOG_ENABLED = "xasecure.audit.log.status.log.enabled";
    static final String AUDIT_LOG_STATUS_LOG_INTERVAL_SEC = "xasecure.audit.log.status.log.interval.sec";
    static final boolean DEFAULT_AUDIT_LOG_STATUS_LOG_ENABLED = false;
    static final long DEFAULT_AUDIT_LOG_STATUS_LOG_INTERVAL_SEC = 300L;
    protected String propPrefix = "xasecure.audit.provider";
    protected String providerName;
    protected String parentPath;
    protected int failedRetryTimes = 3;
    protected int failedRetrySleep = 3000;
    protected Map<String, String> configProps = new HashMap<String, String>();
    protected Properties props;
    int errorLogIntervalMS = 30000;
    long lastErrorLogMS;
    long totalCount;
    long totalSuccessCount;
    long totalFailedCount;
    long totalStashedCount;
    long totalDeferredCount;
    long lastIntervalCount;
    long lastIntervalSuccessCount;
    long lastIntervalFailedCount;
    long lastStashedCount;
    long lastDeferredCount;
    boolean statusLogEnabled = false;
    long statusLogIntervalMS = 300000L;
    long lastStatusLogTime = System.currentTimeMillis();
    long nextStatusLogTime = this.lastStatusLogTime + this.statusLogIntervalMS;
    private int mLogFailureReportMinIntervalInMs = 60000;
    private final AtomicLong mFailedLogLastReportTime = new AtomicLong(0L);
    private final AtomicLong mFailedLogCountSinceLastReport = new AtomicLong(0L);
    private final AtomicLong mFailedLogCountLifeTime = new AtomicLong(0L);

    @Override
    public boolean log(AuditEventBase event) {
        return this.log(Collections.singletonList(event));
    }

    @Override
    public boolean logJSON(String event) {
        AuditEventBase eventObj = MiscUtil.fromJson(event, AuthzAuditEvent.class);
        return this.log(eventObj);
    }

    @Override
    public boolean logJSON(Collection<String> events) {
        ArrayList<AuditEventBase> eventList = new ArrayList<AuditEventBase>(events.size());
        for (String event : events) {
            eventList.add(MiscUtil.fromJson(event, AuthzAuditEvent.class));
        }
        return this.log(eventList);
    }

    @Override
    public boolean logFile(File file) {
        return false;
    }

    @Override
    public void init(Properties props) {
        this.init(props, null);
    }

    @Override
    public void init(Properties props, String basePropertyName) {
        List<String> tokens;
        LOG.info("BaseAuditProvider.init()");
        this.props = props;
        if (basePropertyName != null) {
            this.propPrefix = basePropertyName;
        }
        LOG.info("propPrefix={}", (Object)this.propPrefix);
        String name = MiscUtil.getStringProperty(props, basePropertyName + "." + PROP_NAME);
        if (name != null && !name.isEmpty()) {
            this.setName(name);
        }
        if (this.providerName == null && !(tokens = MiscUtil.toArray(this.propPrefix, ".")).isEmpty()) {
            String finalToken = tokens.get(tokens.size() - 1);
            this.setName(finalToken);
            LOG.info("Using providerName from property prefix. providerName={}", (Object)this.getName());
        }
        LOG.info("providerName={}", (Object)this.getName());
        this.mLogFailureReportMinIntervalInMs = MiscUtil.getIntProperty(props, AUDIT_LOG_FAILURE_REPORT_MIN_INTERVAL_PROP, 60000);
        boolean globalStatusLogEnabled = MiscUtil.getBooleanProperty(props, AUDIT_LOG_STATUS_LOG_ENABLED, false);
        long globalStatusLogIntervalSec = MiscUtil.getLongProperty(props, AUDIT_LOG_STATUS_LOG_INTERVAL_SEC, 300L);
        this.statusLogEnabled = MiscUtil.getBooleanProperty(props, basePropertyName + ".status.log.enabled", globalStatusLogEnabled);
        this.statusLogIntervalMS = MiscUtil.getLongProperty(props, basePropertyName + ".status.log.interval.sec", globalStatusLogIntervalSec) * 1000L;
        this.nextStatusLogTime = this.lastStatusLogTime + this.statusLogIntervalMS;
        LOG.info("{}={}", (Object)AUDIT_LOG_STATUS_LOG_ENABLED, (Object)globalStatusLogEnabled);
        LOG.info("{}={}", (Object)AUDIT_LOG_STATUS_LOG_INTERVAL_SEC, (Object)globalStatusLogIntervalSec);
        LOG.info("{}.status.log.enabled={}", (Object)basePropertyName, (Object)this.statusLogEnabled);
        LOG.info("{}.status.log.interval.sec={}", (Object)basePropertyName, (Object)(this.statusLogIntervalMS / 1000L));
        String configPropsNamePrefix = this.propPrefix + "." + PROP_CONFIG + ".";
        for (Object propNameObj : props.keySet()) {
            String propName = propNameObj.toString();
            if (!propName.startsWith(configPropsNamePrefix)) continue;
            String configName = propName.substring(configPropsNamePrefix.length());
            String configValue = props.getProperty(propName);
            this.configProps.put(configName, configValue);
            LOG.info("Found Config property: {} => {}", (Object)configName, (Object)configValue);
        }
    }

    @Override
    public String getName() {
        if (this.parentPath != null) {
            return this.parentPath + "." + this.providerName;
        }
        return this.providerName;
    }

    public void setName(String name) {
        this.providerName = name;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public String getFinalPath() {
        return this.getName();
    }

    public long addTotalCount(int count) {
        this.totalCount += (long)count;
        return this.totalCount;
    }

    public long addSuccessCount(int count) {
        this.totalSuccessCount += (long)count;
        return this.totalSuccessCount;
    }

    public long addFailedCount(int count) {
        this.totalFailedCount += (long)count;
        return this.totalFailedCount;
    }

    public long addStashedCount(int count) {
        this.totalStashedCount += (long)count;
        return this.totalStashedCount;
    }

    public long addDeferredCount(int count) {
        this.totalDeferredCount += (long)count;
        return this.totalDeferredCount;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getTotalSuccessCount() {
        return this.totalSuccessCount;
    }

    public long getTotalFailedCount() {
        return this.totalFailedCount;
    }

    public long getTotalStashedCount() {
        return this.totalStashedCount;
    }

    public long getLastStashedCount() {
        return this.lastStashedCount;
    }

    public long getTotalDeferredCount() {
        return this.totalDeferredCount;
    }

    public long getLastDeferredCount() {
        return this.lastDeferredCount;
    }

    public boolean isStatusLogEnabled() {
        return this.statusLogEnabled;
    }

    public void logStatusIfRequired() {
        if (System.currentTimeMillis() > this.nextStatusLogTime) {
            this.logStatus();
        }
    }

    public void logStatus() {
        try {
            long currTime = System.currentTimeMillis();
            long diffTime = currTime - this.lastStatusLogTime;
            this.lastStatusLogTime = currTime;
            this.nextStatusLogTime = currTime + this.statusLogIntervalMS;
            long diffCount = this.totalCount - this.lastIntervalCount;
            long diffSuccess = this.totalSuccessCount - this.lastIntervalSuccessCount;
            long diffFailed = this.totalFailedCount - this.lastIntervalFailedCount;
            long diffStashed = this.totalStashedCount - this.lastStashedCount;
            long diffDeferred = this.totalDeferredCount - this.lastDeferredCount;
            if (diffCount == 0L && diffSuccess == 0L && diffFailed == 0L && diffStashed == 0L && diffDeferred == 0L) {
                return;
            }
            this.lastIntervalCount = this.totalCount;
            this.lastIntervalSuccessCount = this.totalSuccessCount;
            this.lastIntervalFailedCount = this.totalFailedCount;
            this.lastStashedCount = this.totalStashedCount;
            this.lastDeferredCount = this.totalDeferredCount;
            if (this.statusLogEnabled) {
                String finalPath = "";
                String tFinalPath = this.getFinalPath();
                if (!this.getName().equals(tFinalPath)) {
                    finalPath = ", finalDestination=" + tFinalPath;
                }
                this.logAuditStatus(diffTime, diffCount, diffSuccess, diffFailed, diffStashed, diffDeferred, finalPath);
            }
        }
        catch (Exception t) {
            LOG.error("Error while printing stats. auditProvider={}", (Object)this.getName());
        }
    }

    public void logError(String msg, Object ... args) {
        long currTimeMS = System.currentTimeMillis();
        if (currTimeMS - this.lastErrorLogMS > (long)this.errorLogIntervalMS) {
            LOG.error(msg, args);
            this.lastErrorLogMS = currTimeMS;
        }
    }

    public void logError(String msg, Throwable ex) {
        long currTimeMS = System.currentTimeMillis();
        if (currTimeMS - this.lastErrorLogMS > (long)this.errorLogIntervalMS) {
            LOG.error(msg, ex);
            this.lastErrorLogMS = currTimeMS;
        }
    }

    public String getTimeDiffStr(long time1, long time2) {
        long timeInMs = Math.abs(time1 - time2);
        return this.formatIntervalForLog(timeInMs);
    }

    public String formatIntervalForLog(long timeInMs) {
        long hours = timeInMs / 3600000L;
        long minutes = timeInMs / 60000L % 60L;
        long seconds = timeInMs % 60000L / 1000L;
        long mSeconds = timeInMs % 1000L;
        if (hours > 0L) {
            return String.format("%02d:%02d:%02d.%03d hours", hours, minutes, seconds, mSeconds);
        }
        if (minutes > 0L) {
            return String.format("%02d:%02d.%03d minutes", minutes, seconds, mSeconds);
        }
        if (seconds > 0L) {
            return String.format("%02d.%03d seconds", seconds, mSeconds);
        }
        return String.format("%03d milli-seconds", mSeconds);
    }

    public void logFailedEvent(AuditEventBase event) {
        this.logFailedEvent(event, "");
    }

    public void logFailedEvent(AuditEventBase event, Throwable excp) {
        long now = System.currentTimeMillis();
        long timeSinceLastReport = now - this.mFailedLogLastReportTime.get();
        long countSinceLastReport = this.mFailedLogCountSinceLastReport.incrementAndGet();
        long countLifeTime = this.mFailedLogCountLifeTime.incrementAndGet();
        if (timeSinceLastReport >= (long)this.mLogFailureReportMinIntervalInMs) {
            this.mFailedLogLastReportTime.set(now);
            this.mFailedLogCountSinceLastReport.set(0L);
            if (excp != null) {
                LOG.warn(FAILED_TO_LOG_AUDIT_EVENT, (Object)MiscUtil.stringify(event), (Object)excp);
            } else {
                LOG.warn(FAILED_TO_LOG_AUDIT_EVENT, (Object)MiscUtil.stringify(event));
            }
            if (countLifeTime > 1L) {
                LOG.warn("Log failure count: {} in past {}; {} during process lifetime", new Object[]{countSinceLastReport, this.formatIntervalForLog(timeSinceLastReport), countLifeTime});
            }
        }
    }

    public void logFailedEvent(Collection<AuditEventBase> events) {
        this.logFailedEvent(events, "");
    }

    public void logFailedEvent(Collection<AuditEventBase> events, Throwable excp) {
        for (AuditEventBase event : events) {
            this.logFailedEvent(event, excp);
        }
    }

    public void logFailedEvent(AuditEventBase event, String message) {
        long now = System.currentTimeMillis();
        long timeSinceLastReport = now - this.mFailedLogLastReportTime.get();
        long countSinceLastReport = this.mFailedLogCountSinceLastReport.incrementAndGet();
        long countLifeTime = this.mFailedLogCountLifeTime.incrementAndGet();
        if (timeSinceLastReport >= (long)this.mLogFailureReportMinIntervalInMs) {
            this.mFailedLogLastReportTime.set(now);
            this.mFailedLogCountSinceLastReport.set(0L);
            LOG.warn("failed to log audit event: {} , errorMessage={}", (Object)MiscUtil.stringify(event), (Object)message);
            if (countLifeTime > 1L) {
                LOG.warn("Log failure count: {} in past {}; {} during process lifetime", new Object[]{countSinceLastReport, this.formatIntervalForLog(timeSinceLastReport), countLifeTime});
            }
        }
    }

    public void logFailedEvent(Collection<AuditEventBase> events, String errorMessage) {
        for (AuditEventBase event : events) {
            this.logFailedEvent(event, errorMessage);
        }
    }

    public void logFailedEventJSON(String event, Throwable excp) {
        long now = System.currentTimeMillis();
        long timeSinceLastReport = now - this.mFailedLogLastReportTime.get();
        long countSinceLastReport = this.mFailedLogCountSinceLastReport.incrementAndGet();
        long countLifeTime = this.mFailedLogCountLifeTime.incrementAndGet();
        if (timeSinceLastReport >= (long)this.mLogFailureReportMinIntervalInMs) {
            this.mFailedLogLastReportTime.set(now);
            this.mFailedLogCountSinceLastReport.set(0L);
            if (excp != null) {
                LOG.warn(FAILED_TO_LOG_AUDIT_EVENT, (Object)event, (Object)excp);
            } else {
                LOG.warn(FAILED_TO_LOG_AUDIT_EVENT, (Object)event);
            }
            if (countLifeTime > 1L) {
                LOG.warn("Log failure count: {} in past {}; {} during process lifetime", new Object[]{countSinceLastReport, this.formatIntervalForLog(timeSinceLastReport), countLifeTime});
            }
        }
    }

    public void logFailedEventJSON(Collection<String> events, Throwable excp) {
        for (String event : events) {
            this.logFailedEventJSON(event, excp);
        }
    }

    private void logAuditStatus(long diffTime, long diffCount, long diffSuccess, long diffFailed, long diffStashed, long diffDeferred, String finalPath) {
        String msg = "Audit Status Log: name=" + this.getName() + finalPath + ", interval=" + this.formatIntervalForLog(diffTime) + ", events=" + diffCount + (diffSuccess > 0L ? ", succcessCount=" + diffSuccess : "") + (diffFailed > 0L ? ", failedCount=" + diffFailed : "") + (diffStashed > 0L ? ", stashedCount=" + diffStashed : "") + (diffDeferred > 0L ? ", deferredCount=" + diffDeferred : "") + ", totalEvents=" + this.totalCount + (this.totalSuccessCount > 0L ? ", totalSuccessCount=" + this.totalSuccessCount : "") + (this.totalFailedCount > 0L ? ", totalFailedCount=" + this.totalFailedCount : "") + (this.totalStashedCount > 0L ? ", totalStashedCount=" + this.totalStashedCount : "") + (this.totalDeferredCount > 0L ? ", totalDeferredCount=" + this.totalDeferredCount : "");
        LOG.info(msg);
    }
}

