/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.provider.AsyncAuditProvider;
import org.apache.ranger.audit.provider.AuditFileCacheProvider;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.DummyAuditProvider;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.provider.MultiDestAuditProvider;
import org.apache.ranger.audit.queue.AuditAsyncQueue;
import org.apache.ranger.audit.queue.AuditBatchQueue;
import org.apache.ranger.audit.queue.AuditFileQueue;
import org.apache.ranger.audit.queue.AuditQueue;
import org.apache.ranger.audit.queue.AuditSummaryQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AuditProviderFactory.class);
    public static final String AUDIT_IS_ENABLED_PROP = "xasecure.audit.is.enabled";
    public static final String AUDIT_HDFS_IS_ENABLED_PROP = "xasecure.audit.hdfs.is.enabled";
    public static final String AUDIT_LOG4J_IS_ENABLED_PROP = "xasecure.audit.log4j.is.enabled";
    public static final String AUDIT_KAFKA_IS_ENABLED_PROP = "xasecure.audit.kafka.is.enabled";
    public static final String AUDIT_SOLR_IS_ENABLED_PROP = "xasecure.audit.solr.is.enabled";
    public static final String AUDIT_OPENSEARCH_IS_ENABLED_PROP = "xasecure.audit.opensearch.is.enabled";
    public static final String AUDIT_DEST_BASE = "xasecure.audit.destination";
    public static final String AUDIT_SHUTDOWN_HOOK_MAX_WAIT_SEC = "xasecure.audit.shutdown.hook.max.wait.seconds";
    public static final String AUDIT_IS_FILE_CACHE_PROVIDER_ENABLE_PROP = "xasecure.audit.provider.filecache.is.enabled";
    public static final String AUDIT_HDFS_IS_ASYNC_PROP = "xasecure.audit.hdfs.is.async";
    public static final String AUDIT_HDFS_MAX_QUEUE_SIZE_PROP = "xasecure.audit.hdfs.async.max.queue.size";
    public static final String AUDIT_HDFS_MAX_FLUSH_INTERVAL_PROP = "xasecure.audit.hdfs.async.max.flush.interval.ms";
    public static final String AUDIT_LOG4J_IS_ASYNC_PROP = "xasecure.audit.log4j.is.async";
    public static final String AUDIT_LOG4J_MAX_QUEUE_SIZE_PROP = "xasecure.audit.log4j.async.max.queue.size";
    public static final String AUDIT_LOG4J_MAX_FLUSH_INTERVAL_PROP = "xasecure.audit.log4j.async.max.flush.interval.ms";
    public static final String AUDIT_KAFKA_IS_ASYNC_PROP = "xasecure.audit.kafka.is.async";
    public static final String AUDIT_SOLR_IS_ASYNC_PROP = "xasecure.audit.solr.is.async";
    public static final String AUDIT_OPENSEARCH_IS_ASYNC_PROP = "xasecure.audit.opensearch.is.async";
    public static final String FILE_QUEUE_TYPE = "filequeue";
    public static final String DEFAULT_QUEUE_TYPE = "memoryqueue";
    public static final int AUDIT_SHUTDOWN_HOOK_MAX_WAIT_SEC_DEFAULT = 30;
    public static final int AUDIT_ASYNC_MAX_QUEUE_SIZE_DEFAULT = 10240;
    public static final int AUDIT_ASYNC_MAX_FLUSH_INTERVAL_DEFAULT = 5000;
    private static final int RANGER_AUDIT_SHUTDOWN_HOOK_PRIORITY = 30;
    private static volatile AuditProviderFactory sFactory;
    private AuditHandler mProvider;
    private String componentAppType = "";
    private boolean mInitDone;
    private JVMShutdownHook jvmShutdownHook;
    private final ArrayList<String> hbaseAppTypes = new ArrayList<String>(Arrays.asList("hbaseMaster", "hbaseRegional"));

    public AuditProviderFactory() {
        LOG.info("AuditProviderFactory: creating..");
        this.mProvider = this.getDefaultProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditProviderFactory getInstance() {
        AuditProviderFactory ret = sFactory;
        if (ret != null) return ret;
        Class<AuditProviderFactory> clazz = AuditProviderFactory.class;
        synchronized (AuditProviderFactory.class) {
            ret = sFactory;
            if (ret != null) return ret;
            sFactory = ret = new AuditProviderFactory();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    public AuditHandler getAuditProvider() {
        return this.mProvider;
    }

    public boolean isInitDone() {
        return this.mInitDone;
    }

    public void shutdown() {
        if (this.isInitDone() && this.jvmShutdownHook != null) {
            this.jvmShutdownHook.run();
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void init(Properties props, String appType) {
        LOG.info("AuditProviderFactory: initializing..");
        if (this.mInitDone) {
            LOG.warn("AuditProviderFactory.init(): already initialized! Will try to re-initialize");
        }
        this.mInitDone = true;
        this.componentAppType = appType;
        MiscUtil.setApplicationType(appType);
        boolean isEnabled = MiscUtil.getBooleanProperty(props, AUDIT_IS_ENABLED_PROP, true);
        if (!isEnabled) {
            LOG.info("AuditProviderFactory: Audit not enabled..");
            this.mProvider = this.getDefaultProvider();
            return;
        }
        boolean isAuditToHdfsEnabled = MiscUtil.getBooleanProperty(props, AUDIT_HDFS_IS_ENABLED_PROP, false);
        boolean isAuditToLog4jEnabled = MiscUtil.getBooleanProperty(props, AUDIT_LOG4J_IS_ENABLED_PROP, false);
        boolean isAuditToKafkaEnabled = MiscUtil.getBooleanProperty(props, AUDIT_KAFKA_IS_ENABLED_PROP, false);
        boolean isAuditToSolrEnabled = MiscUtil.getBooleanProperty(props, AUDIT_SOLR_IS_ENABLED_PROP, false);
        boolean isAuditToOpenSearchEnabled = MiscUtil.getBooleanProperty(props, AUDIT_OPENSEARCH_IS_ENABLED_PROP, false);
        boolean isAuditFileCacheProviderEnabled = MiscUtil.getBooleanProperty(props, AUDIT_IS_FILE_CACHE_PROVIDER_ENABLE_PROP, false);
        ArrayList<AuditHandler> providers = new ArrayList<AuditHandler>();
        for (Object object : props.keySet()) {
            LOG.info("AUDIT PROPERTY: {}={}", object, (Object)props.getProperty(object.toString()));
        }
        ArrayList<String> destNameList = new ArrayList<String>();
        for (Object propNameObj : props.keySet()) {
            String value;
            String destName;
            List<String> splits;
            String propName = propNameObj.toString();
            if (!propName.startsWith(AUDIT_DEST_BASE) || (splits = MiscUtil.toArray(destName = propName.substring(AUDIT_DEST_BASE.length() + 1), ".")).size() > 1 || !(value = props.getProperty(propName)).equalsIgnoreCase("enable") && !value.equalsIgnoreCase("enabled") && !value.equalsIgnoreCase("true")) continue;
            destNameList.add(destName);
            LOG.info("Audit destination {} is set to {}", (Object)propName, (Object)value);
        }
        for (String destName : destNameList) {
            String destPropPrefix = "xasecure.audit.destination." + destName;
            AuditHandler destProvider = this.getProviderFromConfig(props, destPropPrefix, destName, null);
            if (destProvider == null) continue;
            destProvider.init(props, destPropPrefix);
            String queueName = MiscUtil.getStringProperty(props, destPropPrefix + "." + "queue");
            if (queueName == null || queueName.isEmpty()) {
                LOG.info("{}.{} is not set. Setting queue to batch for {}", new Object[]{destPropPrefix, "queue", destName});
                queueName = "batch";
            }
            LOG.info("queue for {} is {}", (Object)destName, (Object)queueName);
            if (queueName != null && !queueName.isEmpty() && !queueName.equalsIgnoreCase("none")) {
                String queuePropPrefix = destPropPrefix + "." + queueName;
                AuditHandler queueProvider = this.getProviderFromConfig(props, queuePropPrefix, queueName, destProvider);
                if (queueProvider != null) {
                    if (queueProvider instanceof AuditQueue) {
                        AuditQueue qProvider = (AuditQueue)queueProvider;
                        qProvider.init(props, queuePropPrefix);
                        providers.add(queueProvider);
                        continue;
                    }
                    LOG.error("Provider queue doesn't extend AuditQueue. Destination={} can't be created. queueName={}", (Object)destName, (Object)queueName);
                    continue;
                }
                LOG.error("Queue provider for destination {} can't be created. queueName={}", (Object)destName, (Object)queueName);
                continue;
            }
            LOG.info("Audit destination {} added to provider list", (Object)destProvider.getName());
            providers.add(destProvider);
        }
        if (!providers.isEmpty()) {
            void var12_19;
            String propPrefix;
            boolean summaryEnabled;
            LOG.info("Using v3 audit configuration");
            AuditHandler auditHandler = (AuditHandler)providers.get(0);
            if (providers.size() > 1) {
                LOG.info("MultiDestAuditProvider is used. Destination count={}", (Object)providers.size());
                MultiDestAuditProvider multiDestProvider = new MultiDestAuditProvider();
                multiDestProvider.init(props);
                multiDestProvider.addAuditProviders(providers);
                MultiDestAuditProvider multiDestAuditProvider = multiDestProvider;
            }
            if (summaryEnabled = MiscUtil.getBooleanProperty(props, (propPrefix = "xasecure.audit.provider") + ".summary.enabled", false)) {
                void var12_17;
                LOG.info("AuditSummaryQueue is enabled");
                AuditSummaryQueue summaryQueue = new AuditSummaryQueue((AuditHandler)var12_17);
                summaryQueue.init(props, propPrefix);
                AuditSummaryQueue auditSummaryQueue = summaryQueue;
            } else {
                LOG.info("AuditSummaryQueue is disabled");
            }
            if (!isAuditFileCacheProviderEnabled) {
                AuditAsyncQueue asyncQueue = new AuditAsyncQueue((AuditHandler)var12_19);
                propPrefix = "xasecure.audit.provider.async";
                asyncQueue.init(props, propPrefix);
                asyncQueue.setParentPath(this.componentAppType);
                this.mProvider = asyncQueue;
                LOG.info("Starting audit queue {}", (Object)this.mProvider.getName());
                this.mProvider.start();
            } else {
                AuditFileCacheProvider auditFileCacheProvider = new AuditFileCacheProvider((AuditHandler)var12_19);
                propPrefix = "xasecure.audit.provider.filecache";
                auditFileCacheProvider.init(props, propPrefix);
                auditFileCacheProvider.setParentPath(this.componentAppType);
                this.mProvider = auditFileCacheProvider;
                LOG.info("Starting Audit File Cache Provider {}", (Object)this.mProvider.getName());
                this.mProvider.start();
            }
        } else {
            AsyncAuditProvider asyncProvider;
            LOG.info("No v3 audit configuration found. Trying v2 audit configurations");
            if (!(isEnabled && (isAuditToHdfsEnabled || isAuditToKafkaEnabled || isAuditToLog4jEnabled || isAuditToSolrEnabled || providers.isEmpty()))) {
                LOG.info("AuditProviderFactory: Audit not enabled..");
                this.mProvider = this.getDefaultProvider();
                return;
            }
            if (isAuditToHdfsEnabled) {
                LOG.info("HdfsAuditProvider is enabled");
                AuditHandler auditHandler = this.createAuditHandler("org.apache.ranger.audit.provider.hdfs.HdfsAuditProvider");
                boolean isAuditAsync = MiscUtil.getBooleanProperty(props, AUDIT_HDFS_IS_ASYNC_PROP, false);
                if (isAuditAsync) {
                    int maxQueueSize = MiscUtil.getIntProperty(props, AUDIT_HDFS_MAX_QUEUE_SIZE_PROP, 10240);
                    int maxFlushInterval = MiscUtil.getIntProperty(props, AUDIT_HDFS_MAX_FLUSH_INTERVAL_PROP, 5000);
                    asyncProvider = new AsyncAuditProvider("HdfsAuditProvider", maxQueueSize, maxFlushInterval, auditHandler);
                    providers.add(asyncProvider);
                } else {
                    providers.add(auditHandler);
                }
            }
            if (isAuditToKafkaEnabled) {
                LOG.info("KafkaAuditProvider is enabled");
                AuditDestination auditDestination = this.createDestination("org.apache.ranger.audit.provider.kafka.KafkaAuditProvider");
                boolean isAuditAsync = MiscUtil.getBooleanProperty(props, AUDIT_KAFKA_IS_ASYNC_PROP, false);
                if (isAuditAsync) {
                    AsyncAuditProvider asyncProvider2 = new AsyncAuditProvider("MyKafkaAuditProvider", 1000, 1000, auditDestination);
                    providers.add(asyncProvider2);
                } else {
                    providers.add(auditDestination);
                }
            }
            if (isAuditToSolrEnabled) {
                LOG.info("SolrAuditProvider is enabled");
                AuditDestination auditDestination = this.createDestination("org.apache.ranger.audit.provider.solr.SolrAuditProvider");
                boolean isAuditAsync = MiscUtil.getBooleanProperty(props, AUDIT_SOLR_IS_ASYNC_PROP, false);
                if (isAuditAsync) {
                    AsyncAuditProvider asyncProvider3 = new AsyncAuditProvider("MySolrAuditProvider", 1000, 1000, auditDestination);
                    providers.add(asyncProvider3);
                } else {
                    providers.add(auditDestination);
                }
            }
            if (isAuditToOpenSearchEnabled) {
                LOG.info("OpenSearch AuditProvider is enabled");
                AuditDestination auditDestination = this.createDestination("org.apache.ranger.audit.provider.opensearch.OpenSearchAuditProvider");
                boolean isAuditAsync = MiscUtil.getBooleanProperty(props, AUDIT_OPENSEARCH_IS_ASYNC_PROP, false);
                if (isAuditAsync) {
                    AsyncAuditProvider asyncProvider4 = new AsyncAuditProvider("MySolrAuditProvider", 1000, 1000, auditDestination);
                    providers.add(asyncProvider4);
                } else {
                    providers.add(auditDestination);
                }
            }
            if (isAuditToLog4jEnabled) {
                AuditDestination auditDestination = this.createDestination("org.apache.ranger.audit.provider.Log4jAuditProvider");
                boolean isAuditAsync = MiscUtil.getBooleanProperty(props, AUDIT_LOG4J_IS_ASYNC_PROP, false);
                if (isAuditAsync) {
                    int maxQueueSize = MiscUtil.getIntProperty(props, AUDIT_LOG4J_MAX_QUEUE_SIZE_PROP, 10240);
                    int maxFlushInterval = MiscUtil.getIntProperty(props, AUDIT_LOG4J_MAX_FLUSH_INTERVAL_PROP, 5000);
                    asyncProvider = new AsyncAuditProvider("Log4jAuditProvider", maxQueueSize, maxFlushInterval, auditDestination);
                    providers.add(asyncProvider);
                } else {
                    providers.add(auditDestination);
                }
            }
            if (providers.isEmpty()) {
                this.mProvider = this.getDefaultProvider();
            } else if (providers.size() == 1) {
                this.mProvider = (AuditHandler)providers.get(0);
            } else {
                MultiDestAuditProvider multiDestAuditProvider = new MultiDestAuditProvider();
                multiDestAuditProvider.addAuditProviders(providers);
                this.mProvider = multiDestAuditProvider;
            }
            this.mProvider.init(props);
            this.mProvider.start();
        }
        this.installJvmShutdownHook(props);
    }

    private AuditDestination createDestination(String destinationClass) {
        try {
            return (AuditDestination)Class.forName(destinationClass).newInstance();
        }
        catch (Exception e) {
            LOG.error("Failed to instantiate audit destination {}", (Object)destinationClass, (Object)e);
            throw new RuntimeException("Failed to create AuditDestination for class: " + destinationClass, e);
        }
    }

    private AuditHandler createAuditHandler(String providerClass) {
        try {
            return (AuditHandler)Class.forName(providerClass).newInstance();
        }
        catch (Exception e) {
            LOG.error("Failed to instantiate audit provider {}", (Object)providerClass, (Object)e);
            throw new RuntimeException("Failed to create AuditHandler for class: " + providerClass, e);
        }
    }

    private AuditHandler getProviderFromConfig(Properties props, String propPrefix, String providerName, AuditHandler consumer) {
        AuditHandler provider;
        block26: {
            provider = null;
            String className = MiscUtil.getStringProperty(props, propPrefix + "." + "classname");
            if (className != null && !className.isEmpty()) {
                try {
                    Class<AuditQueue> handlerClass = Class.forName(className);
                    if (handlerClass.isAssignableFrom(AuditQueue.class)) {
                        provider = (AuditHandler)handlerClass.getDeclaredConstructor(AuditHandler.class).newInstance(consumer);
                        break block26;
                    }
                    provider = (AuditHandler)handlerClass.newInstance();
                }
                catch (Exception e) {
                    LOG.error("Can't instantiate audit class for providerName={}, className={}, propertyPrefix={}", new Object[]{providerName, className, propPrefix, e});
                }
            } else if (providerName.equalsIgnoreCase("file")) {
                provider = this.createDestination("org.apache.ranger.audit.destination.FileAuditDestination");
            } else if (providerName.equalsIgnoreCase("hdfs")) {
                provider = this.createDestination("org.apache.ranger.audit.destination.HDFSAuditDestination");
            } else if (providerName.equalsIgnoreCase("solr")) {
                provider = this.createDestination("org.apache.ranger.audit.destination.SolrAuditDestination");
            } else if (providerName.equalsIgnoreCase("elasticsearch")) {
                provider = this.createDestination("org.apache.ranger.audit.destination.ElasticSearchAuditDestination");
            } else if (providerName.equalsIgnoreCase("opensearch")) {
                provider = this.createDestination("org.apache.ranger.audit.destination.OpenSearchAuditDestination");
            } else if (providerName.equalsIgnoreCase("amazon_cloudwatch")) {
                provider = this.createDestination("org.apache.ranger.audit.destination.AmazonCloudWatchAuditDestination");
            } else if (providerName.equalsIgnoreCase("kafka")) {
                provider = this.createDestination("org.apache.ranger.audit.provider.kafka.KafkaAuditProvider");
            } else if (providerName.equalsIgnoreCase("log4j")) {
                provider = this.createDestination("org.apache.ranger.audit.destination.Log4JAuditDestination");
            } else if (providerName.equalsIgnoreCase("batch")) {
                provider = this.getAuditProvider(props, propPrefix, consumer);
            } else if (providerName.equalsIgnoreCase("async")) {
                provider = new AuditAsyncQueue(consumer);
            } else {
                LOG.error("Provider name doesn't have any class associated with it. providerName={}, propertyPrefix={}", (Object)providerName, (Object)propPrefix);
            }
        }
        if (provider instanceof AuditQueue && consumer == null) {
            LOG.error("consumer can't be null for AuditQueue. queue={}, propertyPrefix={}", (Object)provider.getName(), (Object)propPrefix);
            provider = null;
        }
        return provider;
    }

    private AuditHandler getAuditProvider(Properties props, String propPrefix, AuditHandler consumer) {
        AuditBatchQueue ret;
        String queueType = MiscUtil.getStringProperty(props, propPrefix + ".queuetype", DEFAULT_QUEUE_TYPE);
        LOG.debug("==> AuditProviderFactory.getAuditProvider() propPerfix={}, queueType={}", (Object)propPrefix, (Object)queueType);
        if (FILE_QUEUE_TYPE.equalsIgnoreCase(queueType)) {
            AuditFileQueue auditFileQueue = new AuditFileQueue(consumer);
            String propPrefixFileQueue = propPrefix + "." + FILE_QUEUE_TYPE;
            auditFileQueue.init(props, propPrefixFileQueue);
            ret = new AuditBatchQueue(auditFileQueue);
        } else {
            ret = new AuditBatchQueue(consumer);
        }
        LOG.debug("<== AuditProviderFactory.getAuditProvider()");
        return ret;
    }

    private AuditHandler getDefaultProvider() {
        return new DummyAuditProvider();
    }

    private void installJvmShutdownHook(Properties props) {
        int shutdownHookMaxWaitSeconds = MiscUtil.getIntProperty(props, AUDIT_SHUTDOWN_HOOK_MAX_WAIT_SEC, 30);
        this.jvmShutdownHook = new JVMShutdownHook(this.mProvider, shutdownHookMaxWaitSeconds);
        String appType = this.componentAppType;
        if (appType != null && !this.hbaseAppTypes.contains(appType)) {
            ShutdownHookManager.get().addShutdownHook((Runnable)this.jvmShutdownHook, 30);
        }
    }

    private static class JVMShutdownHook
    extends Thread {
        final Semaphore startCleanup = new Semaphore(0);
        final Semaphore doneCleanup = new Semaphore(0);
        final AtomicBoolean done = new AtomicBoolean(false);
        final Thread cleanupThread;
        final int maxWait;

        public JVMShutdownHook(AuditHandler provider, int maxWait) {
            this.maxWait = maxWait;
            RangerAsyncAuditCleanup runnable = new RangerAsyncAuditCleanup(provider, this.startCleanup, this.doneCleanup);
            this.cleanupThread = new Thread((Runnable)runnable, "Ranger async Audit cleanup");
            this.cleanupThread.setDaemon(true);
            this.cleanupThread.start();
        }

        @Override
        public void run() {
            if (!this.done.compareAndSet(false, true)) {
                LOG.info("==> JVMShutdownHook.run() already done by another thread");
                return;
            }
            LOG.info("==> JVMShutdownHook.run()");
            LOG.info("JVMShutdownHook: Signalling async audit cleanup to start.");
            this.startCleanup.release();
            try {
                long start = System.currentTimeMillis();
                LOG.info("JVMShutdownHook: Waiting up to {} seconds for audit cleanup to finish.", (Object)this.maxWait);
                boolean cleanupFinishedInTime = this.doneCleanup.tryAcquire(this.maxWait, TimeUnit.SECONDS);
                if (cleanupFinishedInTime) {
                    LOG.info("JVMShutdownHook: Audit cleanup finished after {} milli seconds", (Object)(System.currentTimeMillis() - start));
                } else {
                    LOG.warn("JVMShutdownHook: could not detect finishing of audit cleanup even after waiting for {} seconds!", (Object)this.maxWait);
                }
            }
            catch (InterruptedException e) {
                LOG.error("JVMShutdownHook: Interrupted while waiting for completion of Async executor!", (Throwable)e);
            }
            LOG.info("JVMShutdownHook: Interrupting ranger async audit cleanup thread");
            this.cleanupThread.interrupt();
            LOG.info("<== JVMShutdownHook.run()");
        }
    }

    private static class RangerAsyncAuditCleanup
    implements Runnable {
        final Semaphore startCleanup;
        final Semaphore doneCleanup;
        final AuditHandler mProvider;

        RangerAsyncAuditCleanup(AuditHandler provider, Semaphore startCleanup, Semaphore doneCleanup) {
            this.startCleanup = startCleanup;
            this.doneCleanup = doneCleanup;
            this.mProvider = provider;
        }

        @Override
        public void run() {
            while (true) {
                LOG.info("RangerAsyncAuditCleanup: Waiting to audit cleanup start signal");
                try {
                    this.startCleanup.acquire();
                }
                catch (InterruptedException e) {
                    LOG.error("RangerAsyncAuditCleanup: Interrupted while waiting for audit startCleanup signal!  Exiting the thread...", (Throwable)e);
                    break;
                }
                LOG.info("RangerAsyncAuditCleanup: Starting cleanup");
                this.mProvider.waitToComplete();
                this.mProvider.stop();
                this.doneCleanup.release();
                LOG.info("RangerAsyncAuditCleanup: Done cleanup");
            }
        }
    }
}

