/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.atlas;

import com.google.gson.Gson;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.PasswordUtils;

public class RangerServiceAtlas
extends RangerBaseService {
    private static final Log LOG = LogFactory.getLog(RangerServiceAtlas.class);
    public static final String RESOURCE_SERVICE = "atlas-service";
    public static final String RESOURCE_TYPE_CATEGORY = "type-category";
    public static final String RESOURCE_TYPE_NAME = "type";
    public static final String RESOURCE_ENTITY_TYPE = "entity-type";
    public static final String RESOURCE_ENTITY_CLASSIFICATION = "entity-classification";
    public static final String RESOURCE_ENTITY_ID = "entity";
    public static final String RESOURCE_RELATIONSHIP_TYPE = "relationship-type";
    public static final String RESOURCE_END_ONE_ENTITY_TYPE = "end-one-entity-type";
    public static final String RESOURCE_END_ONE_ENTITY_CLASSIFICATION = "end-one-entity-classification";
    public static final String RESOURCE_END_ONE_ENTITY_ID = "end-one-entity";
    public static final String RESOURCE_END_TWO_ENTITY_TYPE = "end-two-entity-type";
    public static final String RESOURCE_END_TWO_ENTITY_CLASSIFICATION = "end-two-entity-classification";
    public static final String RESOURCE_END_TWO_ENTITY_ID = "end-two-entity";
    public static final String ACCESS_TYPE_ENTITY_READ = "entity-read";
    public static final String ADMIN_USERNAME_DEFAULT = "admin";
    public static final String TAGSYNC_USERNAME_DEFAULT = "rangertagsync";
    public static final String CONFIG_REST_ADDRESS = "atlas.rest.address";
    public static final String CONFIG_USERNAME = "username";
    public static final String CONFIG_PASSWORD = "password";
    public static final String ENTITY_NOT_CLASSIFIED = "_NOT_CLASSIFIED";
    private static final String TYPE_ENTITY = "entity";
    private static final String TYPE_CLASSIFICATION = "classification";
    private static final String TYPE_STRUCT = "struct";
    private static final String TYPE_ENUM = "enum";
    private static final String TYPE_RELATIONSHIP = "relationship";
    private static final String URL_LOGIN = "/j_spring_security_check";
    private static final String URL_GET_TYPESDEF_HEADERS = "/api/atlas/v2/types/typedefs/headers";
    private static final String URl_ENTITY_SEARCH = "v2/search/attribute?attrName=qualifiedName";
    private static final String WEB_RESOURCE_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String CONNECTION_ERROR_MSG = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerServiceAtlas.validateConfig()");
        }
        AtlasServiceClient client = new AtlasServiceClient(this.getServiceName(), this.configs);
        Map<String, Object> ret = client.validateConfig();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceAtlas.validateConfig(): " + ret));
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceAtlas.lookupResource(" + context + ")"));
        }
        AtlasServiceClient client = new AtlasServiceClient(this.getServiceName(), this.configs);
        List<String> ret = client.lookupResource(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceAtlas.lookupResource(" + context + "): " + ret));
        }
        return ret;
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerServiceAtlas.getDefaultRangerPolicies()");
        }
        List ret = super.getDefaultRangerPolicies();
        String adminUser = this.getStringConfig("atlas.admin.user", ADMIN_USERNAME_DEFAULT);
        String tagSyncUser = this.getStringConfig("atlas.rangertagsync.user", TAGSYNC_USERNAME_DEFAULT);
        boolean relationshipTypeAllowPublic = this.getBooleanConfig("atlas.default-policy.relationship-type.allow.public", true);
        for (RangerPolicy defaultPolicy : ret) {
            Map policyResources = defaultPolicy.getResources();
            for (RangerPolicy.RangerPolicyItem defaultPolicyItem : defaultPolicy.getPolicyItems()) {
                defaultPolicyItem.getUsers().add(adminUser);
            }
            if (policyResources.containsKey(RESOURCE_ENTITY_TYPE)) {
                RangerPolicy.RangerPolicyItem policyItemForTagSyncUser = new RangerPolicy.RangerPolicyItem();
                policyItemForTagSyncUser.setUsers(Collections.singletonList(tagSyncUser));
                policyItemForTagSyncUser.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_ENTITY_READ)));
                defaultPolicy.getPolicyItems().add(policyItemForTagSyncUser);
            }
            if (!relationshipTypeAllowPublic || !policyResources.containsKey(RESOURCE_RELATIONSHIP_TYPE)) continue;
            for (RangerPolicy.RangerPolicyItem defaultPolicyItem : defaultPolicy.getPolicyItems()) {
                defaultPolicyItem.getGroups().add("public");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerServiceAtlas.getDefaultRangerPolicies()");
        }
        return ret;
    }

    String getStringConfig(String configName, String defaultValue) {
        String val = (String)this.service.getConfigs().get(configName);
        return StringUtils.isBlank((String)val) ? defaultValue : val;
    }

    boolean getBooleanConfig(String configName, boolean defaultValue) {
        String val = (String)this.service.getConfigs().get(configName);
        return StringUtils.isBlank((String)val) ? defaultValue : Boolean.parseBoolean(val);
    }

    private static class AtlasServiceClient
    extends BaseClient {
        private static final String[] TYPE_CATEGORIES = new String[]{"classification", "enum", "entity", "relationship", "struct"};
        Map<String, List<String>> typesDef = new HashMap<String, List<String>>();

        public AtlasServiceClient(String serviceName, Map<String, String> serviceConfig) {
            super(serviceName, serviceConfig);
        }

        public Map<String, Object> validateConfig() {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            this.loginToAtlas(Client.create());
            BaseClient.generateResponseDataMap((boolean)true, (String)"ConnectionTest Successful", (String)"ConnectionTest Successful", null, null, ret);
            return ret;
        }

        public List<String> lookupResource(ResourceLookupContext lookupContext) {
            ArrayList<String> ret = new ArrayList<String>();
            String userInput = lookupContext.getUserInput();
            List currentValues = (List)lookupContext.getResources().get(lookupContext.getResourceName());
            switch (lookupContext.getResourceName()) {
                case "type-category": {
                    for (String typeCategory : TYPE_CATEGORIES) {
                        this.addIfStartsWithAndNotExcluded(ret, typeCategory, userInput, (List<String>)currentValues);
                    }
                    break;
                }
                case "type": {
                    this.refreshTypesDefs();
                    List typeCategories = (List)lookupContext.getResources().get(RangerServiceAtlas.RESOURCE_TYPE_CATEGORY);
                    if (this.emptyOrContainsMatch(typeCategories, RangerServiceAtlas.TYPE_CLASSIFICATION)) {
                        this.addIfStartsWithAndNotExcluded(ret, this.typesDef.get(RangerServiceAtlas.TYPE_CLASSIFICATION), userInput, (List<String>)currentValues);
                    }
                    if (this.emptyOrContainsMatch(typeCategories, "entity")) {
                        this.addIfStartsWithAndNotExcluded(ret, this.typesDef.get("entity"), userInput, (List<String>)currentValues);
                    }
                    if (this.emptyOrContainsMatch(typeCategories, RangerServiceAtlas.TYPE_ENUM)) {
                        this.addIfStartsWithAndNotExcluded(ret, this.typesDef.get(RangerServiceAtlas.TYPE_ENUM), userInput, (List<String>)currentValues);
                    }
                    if (this.emptyOrContainsMatch(typeCategories, RangerServiceAtlas.TYPE_STRUCT)) {
                        this.addIfStartsWithAndNotExcluded(ret, this.typesDef.get(RangerServiceAtlas.TYPE_STRUCT), userInput, (List<String>)currentValues);
                    }
                    if (!this.emptyOrContainsMatch(typeCategories, RangerServiceAtlas.TYPE_RELATIONSHIP)) break;
                    this.addIfStartsWithAndNotExcluded(ret, this.typesDef.get(RangerServiceAtlas.TYPE_RELATIONSHIP), userInput, (List<String>)currentValues);
                    break;
                }
                case "end-one-entity-type": 
                case "end-two-entity-type": 
                case "entity-type": {
                    this.refreshTypesDefs();
                    this.addIfStartsWithAndNotExcluded(ret, this.typesDef.get("entity"), userInput, (List<String>)currentValues);
                    break;
                }
                case "end-one-entity-classification": 
                case "end-two-entity-classification": 
                case "entity-classification": {
                    this.refreshTypesDefs();
                    this.addIfStartsWithAndNotExcluded(ret, this.typesDef.get(RangerServiceAtlas.TYPE_CLASSIFICATION), userInput, (List<String>)currentValues);
                    break;
                }
                case "entity": {
                    List searchTypes = (List)lookupContext.getResources().get(RangerServiceAtlas.RESOURCE_ENTITY_TYPE);
                    if (searchTypes == null || searchTypes.size() != 1) break;
                    List<String> values = this.searchEntities(userInput, (String)searchTypes.get(0));
                    this.addIfStartsWithAndNotExcluded(ret, values, userInput, (List<String>)currentValues);
                    break;
                }
                case "relationship-type": {
                    this.refreshTypesDefs();
                    this.addIfStartsWithAndNotExcluded(ret, this.typesDef.get(RangerServiceAtlas.TYPE_RELATIONSHIP), userInput, (List<String>)currentValues);
                    break;
                }
                case "end-one-entity": {
                    List searchTypes = (List)lookupContext.getResources().get(RangerServiceAtlas.RESOURCE_END_ONE_ENTITY_TYPE);
                    if (searchTypes == null || searchTypes.size() != 1) break;
                    List<String> values = this.searchEntities(userInput, (String)searchTypes.get(0));
                    this.addIfStartsWithAndNotExcluded(ret, values, userInput, (List<String>)currentValues);
                    break;
                }
                case "end-two-entity": {
                    List searchTypes = (List)lookupContext.getResources().get(RangerServiceAtlas.RESOURCE_END_TWO_ENTITY_TYPE);
                    if (searchTypes == null || searchTypes.size() != 1) break;
                    List<String> values = this.searchEntities(userInput, (String)searchTypes.get(0));
                    this.addIfStartsWithAndNotExcluded(ret, values, userInput, (List<String>)currentValues);
                    break;
                }
                default: {
                    ret.add(lookupContext.getResourceName());
                }
            }
            return ret;
        }

        private ClientResponse loginToAtlas(Client client) {
            ClientResponse ret = null;
            HadoopException excp = null;
            String loginUrl = null;
            for (String atlasUrl : this.getAtlasUrls()) {
                try {
                    loginUrl = atlasUrl + RangerServiceAtlas.URL_LOGIN;
                    WebResource webResource = client.resource(loginUrl);
                    MultivaluedMapImpl formData = new MultivaluedMapImpl();
                    String password = null;
                    try {
                        password = PasswordUtils.decryptPassword((String)this.getPassword());
                    }
                    catch (Exception ex) {
                        LOG.info((Object)"Password decryption failed; trying Atlas connection with received password string");
                    }
                    if (password == null) {
                        password = this.getPassword();
                    }
                    formData.add((Object)"j_username", (Object)this.getUserName());
                    formData.add((Object)"j_password", (Object)password);
                    try {
                        ret = (ClientResponse)webResource.type(RangerServiceAtlas.WEB_RESOURCE_CONTENT_TYPE).post(ClientResponse.class, (Object)formData);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("failed to login to Atlas at " + loginUrl), (Throwable)e);
                    }
                    if (ret == null) continue;
                    break;
                }
                catch (Throwable t) {
                    String msgDesc = "Exception while login to Atlas at : " + loginUrl;
                    LOG.error((Object)msgDesc, t);
                    excp = new HadoopException(msgDesc, t);
                    excp.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + RangerServiceAtlas.CONNECTION_ERROR_MSG, null, null);
                }
            }
            if (ret == null) {
                if (excp == null) {
                    String msgDesc = "Exception while login to Atlas at : " + loginUrl;
                    excp = new HadoopException(msgDesc);
                    excp.generateResponseDataMap(false, "", msgDesc + RangerServiceAtlas.CONNECTION_ERROR_MSG, null, null);
                }
                throw excp;
            }
            return ret;
        }

        private boolean refreshTypesDefs() {
            boolean ret = false;
            Subject subj = this.getLoginSubject();
            if (subj == null) {
                return ret;
            }
            Map<String, List<String>> typesDef = Subject.doAs(subj, new PrivilegedAction<Map<String, List<String>>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Map<String, List<String>> run() {
                    HashMap<String, ArrayList<String>> ret = null;
                    for (String atlasUrl : this.getAtlasUrls()) {
                        Client client = null;
                        try {
                            client = Client.create();
                            ClientResponse loginResponse = this.loginToAtlas(client);
                            WebResource webResource = client.resource(atlasUrl + RangerServiceAtlas.URL_GET_TYPESDEF_HEADERS);
                            WebResource.Builder builder = webResource.getRequestBuilder();
                            for (NewCookie cook : loginResponse.getCookies()) {
                                builder = (WebResource.Builder)builder.cookie((Cookie)cook);
                            }
                            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
                            if (response == null) continue;
                            String jsonString = (String)response.getEntity(String.class);
                            Gson gson = new Gson();
                            List types = (List)gson.fromJson(jsonString, List.class);
                            ret = new HashMap<String, ArrayList<String>>();
                            for (Object type : types) {
                                if (!(type instanceof Map)) continue;
                                Map typeDef = (Map)type;
                                Object name = typeDef.get("name");
                                Object category = typeDef.get("category");
                                if (name == null || category == null) continue;
                                String strCategory = category.toString().toLowerCase();
                                ArrayList<String> categoryList = (ArrayList<String>)ret.get(strCategory);
                                if (categoryList == null) {
                                    categoryList = new ArrayList<String>();
                                    ret.put(strCategory, categoryList);
                                }
                                categoryList.add(name.toString());
                            }
                            break;
                        }
                        catch (Throwable t) {
                            String msgDesc = "Exception while getting Atlas Resource List.";
                            LOG.error((Object)msgDesc, t);
                        }
                        finally {
                            if (client != null) {
                                client.destroy();
                            }
                        }
                    }
                    return ret;
                }
            });
            if (typesDef != null) {
                this.typesDef = typesDef;
                ret = true;
            }
            return ret;
        }

        private List<String> searchEntities(final String userInput, final String entityType) {
            Subject subj;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> RangerServiceAtlas.searchEntities(userInput=" + userInput + ", entityType=" + entityType + ")"));
            }
            if ((subj = this.getLoginSubject()) == null) {
                return null;
            }
            List<String> list = Subject.doAs(subj, new PrivilegedAction<List<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<String> run() {
                    ArrayList<String> ret = null;
                    for (String atlasUrl : this.getAtlasUrls()) {
                        Client client = null;
                        try {
                            client = Client.create();
                            ClientResponse loginResponse = this.loginToAtlas(client);
                            String entitySearcApiUrl = atlasUrl + "/api/atlas/" + RangerServiceAtlas.URl_ENTITY_SEARCH;
                            StringBuilder searchUrl = new StringBuilder();
                            searchUrl.append(entitySearcApiUrl).append("&typeName=").append(entityType).append("&attrValuePrefix=" + userInput + "&limit=25");
                            WebResource webResource = client.resource(searchUrl.toString());
                            WebResource.Builder builder = webResource.getRequestBuilder();
                            for (NewCookie cook : loginResponse.getCookies()) {
                                builder = (WebResource.Builder)builder.cookie((Cookie)cook);
                            }
                            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
                            if (response == null) continue;
                            String jsonString = (String)response.getEntity(String.class);
                            Gson gson = new Gson();
                            AtlasSearchResult searchResult = (AtlasSearchResult)gson.fromJson(jsonString, AtlasSearchResult.class);
                            ret = new ArrayList<String>();
                            if (searchResult == null) continue;
                            List entityHeaderList = searchResult.getEntities();
                            for (AtlasEntityHeader entity : entityHeaderList) {
                                ret.add((String)entity.getAttribute("qualifiedName"));
                            }
                        }
                        catch (Throwable t) {
                            String msgDesc = "Exception while getting Atlas Entity Resource List.";
                            LOG.error((Object)msgDesc, t);
                        }
                        finally {
                            if (client != null) {
                                client.destroy();
                            }
                        }
                    }
                    return ret;
                }
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== RangerServiceAtlas.searchEntities(userInput=" + userInput + ", entityType=" + entityType + "): " + list));
            }
            return list;
        }

        String[] getAtlasUrls() {
            String urlString = (String)this.connectionProperties.get(RangerServiceAtlas.CONFIG_REST_ADDRESS);
            String[] ret = urlString == null ? new String[]{} : urlString.split(",");
            for (int i = 0; i < ret.length; ++i) {
                String url = ret[i];
                while (url.length() > 0 && url.charAt(url.length() - 1) == '/') {
                    url = url.substring(0, url.length() - 1);
                }
                ret[i] = url;
            }
            return ret;
        }

        String getUserName() {
            return (String)this.connectionProperties.get(RangerServiceAtlas.CONFIG_USERNAME);
        }

        String getPassword() {
            return (String)this.connectionProperties.get(RangerServiceAtlas.CONFIG_PASSWORD);
        }

        boolean emptyOrContainsMatch(List<String> list, String value) {
            if (list == null || list.isEmpty()) {
                return true;
            }
            for (String item : list) {
                if (!StringUtils.equalsIgnoreCase((String)item, (String)value) && !FilenameUtils.wildcardMatch((String)value, (String)item, (IOCase)IOCase.INSENSITIVE)) continue;
                return true;
            }
            return false;
        }

        void addIfStartsWithAndNotExcluded(List<String> list, List<String> values, String prefix, List<String> excludeList) {
            if (list == null) {
                return;
            }
            if (values == null) {
                this.addIfStartsWithAndNotExcluded(list, RangerServiceAtlas.ENTITY_NOT_CLASSIFIED, prefix, excludeList);
            } else {
                for (String value : values) {
                    this.addIfStartsWithAndNotExcluded(list, value, prefix, excludeList);
                }
            }
        }

        void addIfStartsWithAndNotExcluded(List<String> list, String value, String prefix, List<String> excludeList) {
            if (value == null || list == null) {
                return;
            }
            if (prefix != null && !value.startsWith(prefix)) {
                return;
            }
            if (excludeList != null && excludeList.contains(value)) {
                return;
            }
            list.add(value);
        }
    }
}

