/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.atlas.authorizer;

import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasRelationshipAccessRequest;
import org.apache.atlas.authorize.AtlasSearchResultScrubRequest;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.authorize.AtlasTypesDefFilterRequest;
import org.apache.ranger.plugin.classloader.PluginClassLoaderActivator;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAtlasAuthorizer
implements AtlasAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAtlasAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "atlas";
    private static final String RANGER_ATLAS_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.atlas.authorizer.RangerAtlasAuthorizer";
    private AtlasAuthorizer rangerAtlasAuthorizerImpl;
    private RangerPluginClassLoader pluginClassLoader;

    public RangerAtlasAuthorizer() {
        LOG.debug("==> RangerAtlasAuthorizer.RangerAtlasAuthorizer()");
        this.init0();
        LOG.debug("<== RangerAtlasAuthorizer.RangerAtlasAuthorizer()");
    }

    public void init() {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "init");){
            this.rangerAtlasAuthorizerImpl.init();
        }
    }

    public void cleanUp() {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "cleanUp");){
            this.rangerAtlasAuthorizerImpl.cleanUp();
        }
    }

    public boolean isAccessAllowed(AtlasAdminAccessRequest request) throws AtlasAuthorizationException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "isAccessAllowed:adminAccess");){
            boolean bl = this.rangerAtlasAuthorizerImpl.isAccessAllowed(request);
            return bl;
        }
    }

    public boolean isAccessAllowed(AtlasEntityAccessRequest request) throws AtlasAuthorizationException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "isAccessAllowed:entityAccess");){
            boolean bl = this.rangerAtlasAuthorizerImpl.isAccessAllowed(request);
            return bl;
        }
    }

    public boolean isAccessAllowed(AtlasTypeAccessRequest request) throws AtlasAuthorizationException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "isAccessAllowed:typeAccess");){
            boolean bl = this.rangerAtlasAuthorizerImpl.isAccessAllowed(request);
            return bl;
        }
    }

    public boolean isAccessAllowed(AtlasRelationshipAccessRequest request) throws AtlasAuthorizationException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "isAccessAllowed:relationshipAccess");){
            boolean bl = this.rangerAtlasAuthorizerImpl.isAccessAllowed(request);
            return bl;
        }
    }

    public void scrubSearchResults(AtlasSearchResultScrubRequest request) throws AtlasAuthorizationException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "scrubSearchResults");){
            this.rangerAtlasAuthorizerImpl.scrubSearchResults(request);
        }
    }

    public void filterTypesDef(AtlasTypesDefFilterRequest request) throws AtlasAuthorizationException {
        try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "filterTypesDef");){
            this.rangerAtlasAuthorizerImpl.filterTypesDef(request);
        }
    }

    private void init0() {
        LOG.info("==> RangerAtlasPlugin.init0()");
        try {
            this.pluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_ATLAS_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.pluginClassLoader);
            try (PluginClassLoaderActivator ignored = new PluginClassLoaderActivator(this.pluginClassLoader, "init0");){
                this.rangerAtlasAuthorizerImpl = (AtlasAuthorizer)cls.newInstance();
            }
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerAtlasPlugin", (Throwable)e);
        }
        LOG.debug("<== RangerAtlasPlugin.init0()");
    }
}

