/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ldapconfigcheck;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.ranger.ldapconfigcheck.LdapConfig;

public class UserSync {
    private static final String[] userNameAttrValues = new String[]{"sAMAccountName", "uid", "cn"};
    private static final String[] userObjClassValues = new String[]{"person", "posixAccount"};
    private static final String[] userGroupMemAttrValues = new String[]{"memberOf", "ismemberOf"};
    private static final String[] groupObjectClassValues = new String[]{"group", "groupOfNames", "posixGroup"};
    private static final String[] groupNameAttrValues = new String[]{"distinguishedName", "cn"};
    private static final String[] groupMemAttrValues = new String[]{"member", "memberUid"};
    private String userNameAttribute;
    private String userObjClassName;
    private String userGroupMemberName;
    private String groupMemberName;
    private String groupNameAttrName;
    private String groupObjClassName;
    private String groupSearchBase;
    private String groupSearchFilter;
    private String userSearchBase;
    private String userSearchFilter;
    private String searchBase;
    private String groupName;
    private final PrintStream logFile;
    private final PrintStream ambariProps;
    private final PrintStream installProps;
    private final LdapConfig config;

    public UserSync(LdapConfig config, PrintStream logFile, PrintStream ambariProps, PrintStream installProps) {
        this.config = config;
        this.logFile = logFile;
        this.ambariProps = ambariProps;
        this.installProps = installProps;
        this.initUserSync();
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public String getUserObjClassName() {
        return this.userObjClassName;
    }

    public String getUserGroupMemberName() {
        return this.userGroupMemberName;
    }

    public String getGroupMemberName() {
        return this.groupMemberName;
    }

    public String getGroupNameAttrName() {
        return this.groupNameAttrName;
    }

    public String getGroupObjClassName() {
        return this.groupObjClassName;
    }

    public String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void findUserProperties(LdapContext ldapContext) throws Throwable {
        this.findBasicUserProperties(ldapContext, true);
        this.findAdvUserProperties(ldapContext, true);
    }

    public void getAllUsers(LdapContext ldapContext) throws Throwable {
        int noOfUsers = 0;
        Attribute userNameAttr = null;
        NamingEnumeration<SearchResult> userSearchResultEnum = null;
        SearchControls userSearchControls = new SearchControls();
        HashSet<String> userSearchAttributes = new HashSet<String>();
        userSearchControls.setSearchScope(this.config.getUserSearchScope());
        if (this.userNameAttribute != null) {
            userSearchAttributes.add(this.userNameAttribute);
        }
        if (this.userGroupMemberName != null) {
            userSearchAttributes.add(this.userGroupMemberName);
        }
        if (!userSearchAttributes.isEmpty()) {
            userSearchControls.setReturningAttributes(userSearchAttributes.toArray(new String[userSearchAttributes.size()]));
        } else {
            userSearchControls.setReturningAttributes(new String[]{"*", "+"});
        }
        String extendedUserSearchFilter = "(objectclass=" + this.userObjClassName + ")";
        if (this.userSearchFilter != null && !this.userSearchFilter.trim().isEmpty()) {
            String customFilter = this.userSearchFilter.trim();
            if (!customFilter.startsWith("(")) {
                customFilter = "(" + customFilter + ")";
            }
            extendedUserSearchFilter = "(&" + extendedUserSearchFilter + customFilter + ")";
        }
        byte[] cookie = null;
        this.logFile.println();
        this.logFile.println("INFO: First 20 Users and associated groups are:");
        try {
            do {
                userSearchResultEnum = ldapContext.search(this.userSearchBase, extendedUserSearchFilter, userSearchControls);
                while (userSearchResultEnum.hasMore()) {
                    String userName;
                    SearchResult userEntry = userSearchResultEnum.next();
                    if (userEntry == null) {
                        this.logFile.println("WARN: userEntry null");
                        continue;
                    }
                    Attributes attributes = userEntry.getAttributes();
                    if (attributes == null) {
                        this.logFile.println("WARN: Attributes missing for entry " + userEntry.getNameInNamespace());
                        continue;
                    }
                    if (this.userNameAttribute == null || this.userNameAttribute.isEmpty()) {
                        for (String userNameAttrValue : userNameAttrValues) {
                            userNameAttr = attributes.get(userNameAttrValue);
                            if (userNameAttr == null) continue;
                            this.userNameAttribute = userNameAttrValue;
                            break;
                        }
                        if (userNameAttr == null) {
                            this.logFile.print("WARN: Failed to find any of ( ");
                            for (String userNameAttrValue : userNameAttrValues) {
                                this.logFile.print(userNameAttrValue + " ");
                            }
                            this.logFile.println(") for entry " + userEntry.getNameInNamespace());
                            continue;
                        }
                    } else {
                        userNameAttr = attributes.get(this.userNameAttribute);
                        if (userNameAttr == null) {
                            this.logFile.println("WARN: Failed to find " + this.userNameAttribute + " for entry " + userEntry.getNameInNamespace());
                            continue;
                        }
                    }
                    if ((userName = userNameAttr.get().toString()) == null || userName.trim().isEmpty()) {
                        this.logFile.println("WARN: " + this.userNameAttribute + " empty for entry " + userEntry.getNameInNamespace());
                        continue;
                    }
                    userName = userName.toLowerCase();
                    HashSet<String> groups = new HashSet<String>();
                    Attribute groupMemberAttr = attributes.get(this.userGroupMemberName);
                    if (groupMemberAttr != null) {
                        NamingEnumeration<?> groupEnum = groupMemberAttr.getAll();
                        while (groupEnum.hasMore()) {
                            String groupRes = groupEnum.next().toString();
                            groups.add(groupRes);
                            if (this.groupName != null && !this.groupName.isEmpty()) continue;
                            this.groupName = groupRes;
                        }
                    }
                    if (noOfUsers < 20) {
                        this.logFile.println("Username: " + userName + ", Groups: " + groups);
                    }
                    ++noOfUsers;
                }
                Control[] controls = ldapContext.getResponseControls();
                if (controls != null) {
                    for (Control control : controls) {
                        if (!(control instanceof PagedResultsResponseControl)) continue;
                        PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                        cookie = prrc.getCookie();
                    }
                } else {
                    this.logFile.println("WARN: No controls were sent from the server");
                }
                if (!this.config.isPagedResultsEnabled()) continue;
                ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.config.getPagedResultsSize(), cookie, true)});
            } while (cookie != null);
            this.logFile.println("\nINFO: Total no. of users = " + noOfUsers);
        }
        catch (NamingException ne) {
            String msg = "Exception occured while retreiving users\n";
            if (this.config.getUserNameAttribute() != null && !this.config.getUserNameAttribute().isEmpty() || this.config.getUserObjectClass() != null && !this.config.getUserObjectClass().isEmpty() || this.config.getGroupNameAttribute() != null && !this.config.getGroupNameAttribute().isEmpty() || this.config.getUserSearchBase() != null && !this.config.getUserSearchBase().isEmpty() || this.config.getUserSearchFilter() != null && !this.config.getUserSearchFilter().isEmpty()) {
                throw new Exception("Please verify values for:\n ranger.usersync.ldap.user.nameattribute\n ranger.usersync.ldap.user.objectclass\nranger.usersync.ldap.user.groupnameattribute\nranger.usersync.ldap.user.searchbase\nranger.usersync.ldap.user.searchfilter\n");
            }
            throw new Exception(msg + ne);
        }
        finally {
            if (userSearchResultEnum != null) {
                userSearchResultEnum.close();
            }
        }
    }

    public void findGroupProperties(LdapContext ldapContext) throws Throwable {
        if (this.groupName == null || this.groupName.isEmpty()) {
            this.findBasicUserProperties(ldapContext, false);
        }
        if (this.groupName == null || this.groupName.isEmpty()) {
            this.findAdvUserProperties(ldapContext, false);
        }
        this.findBasicGroupProperties(ldapContext);
        this.findAdvGroupProperties(ldapContext);
    }

    public void getAllGroups(LdapContext ldapContext) throws Throwable {
        int noOfGroups = 0;
        NamingEnumeration<SearchResult> groupSearchResultEnum = null;
        SearchControls groupSearchControls = new SearchControls();
        HashSet<String> groupSearchAttributes = new HashSet<String>();
        groupSearchControls.setSearchScope(this.config.getGroupSearchScope());
        groupSearchAttributes.add(this.groupNameAttrName);
        groupSearchAttributes.add(this.groupMemberName);
        groupSearchAttributes.add("distinguishedName");
        groupSearchControls.setReturningAttributes(groupSearchAttributes.toArray(new String[groupSearchAttributes.size()]));
        String extendedGroupSearchFilter = "(objectclass=" + this.groupObjClassName + ")";
        if (this.groupSearchFilter != null && !this.groupSearchFilter.trim().isEmpty()) {
            String customFilter = this.groupSearchFilter.trim();
            if (!customFilter.startsWith("(")) {
                customFilter = "(" + customFilter + ")";
            }
            extendedGroupSearchFilter = "(&" + extendedGroupSearchFilter + customFilter + ")";
        }
        try {
            groupSearchResultEnum = ldapContext.search(this.groupSearchBase, extendedGroupSearchFilter, groupSearchControls);
            this.logFile.println("\nINFO: First 20 Groups and associated Users are:");
            while (groupSearchResultEnum.hasMore()) {
                SearchResult groupEntry = groupSearchResultEnum.next();
                if (groupEntry == null) continue;
                Attributes groupAttributes = groupEntry.getAttributes();
                if (groupAttributes == null) {
                    this.logFile.println("WARN: Attributes missing for entry " + groupEntry.getNameInNamespace());
                    continue;
                }
                Attribute groupMemberAttr = groupAttributes.get(this.groupMemberName);
                HashSet<String> users = new HashSet<String>();
                if (groupMemberAttr != null) {
                    NamingEnumeration<?> userEnum = groupMemberAttr.getAll();
                    while (userEnum.hasMore()) {
                        String userRes = userEnum.next().toString();
                        users.add(userRes);
                    }
                }
                Attribute groupNameAttr = groupAttributes.get(this.groupNameAttrName);
                if (noOfGroups < 20) {
                    this.logFile.println("Group name: " + groupNameAttr.get().toString() + ", Users: " + users);
                }
                ++noOfGroups;
            }
            this.logFile.println("\nINFO: Total no. of groups = " + noOfGroups);
        }
        catch (NamingException ne) {
            String msg = "Exception occured while retreiving groups\n";
            if (this.config.getGroupNameAttribute() != null && !this.config.getGroupNameAttribute().isEmpty() || this.config.getGroupObjectClass() != null && !this.config.getGroupObjectClass().isEmpty() || this.config.getUserGroupMemberAttributeName() != null && !this.config.getUserGroupMemberAttributeName().isEmpty() || this.config.getGroupSearchBase() != null && !this.config.getGroupSearchBase().isEmpty() || this.config.getGroupSearchFilter() != null && !this.config.getGroupSearchFilter().isEmpty()) {
                throw new Exception("Please verify values for:\n ranger.usersync.group.memberattributename\n ranger.usersync.group.nameattribute\nranger.usersync.group.objectclass\nranger.usersync.group.searchbase\nranger.usersync.group.searchfilter\n");
            }
            throw new Exception(msg + ne);
        }
        finally {
            if (groupSearchResultEnum != null) {
                groupSearchResultEnum.close();
            }
        }
    }

    private void initUserSync() {
        try {
            String bindDn = this.config.getLdapBindDn();
            this.userObjClassName = this.config.getUserObjectClass();
            this.userNameAttribute = this.config.getUserNameAttribute();
            this.userGroupMemberName = this.config.getUserGroupNameAttribute();
            this.userSearchBase = this.config.getUserSearchBase();
            this.userSearchFilter = this.config.getUserSearchFilter();
            this.groupObjClassName = this.config.getGroupObjectClass();
            this.groupNameAttrName = this.config.getGroupNameAttribute();
            this.groupMemberName = this.config.getUserGroupMemberAttributeName();
            this.groupSearchBase = this.config.getGroupSearchBase();
            this.groupSearchFilter = this.config.getGroupSearchFilter();
            if (bindDn.contains("@")) {
                this.searchBase = bindDn.substring(bindDn.indexOf("@") + 1);
                this.searchBase = "dc=".concat(this.searchBase);
                this.searchBase = this.searchBase.replaceAll("\\.", ",dc=");
            } else {
                int dcIndex = bindDn.toLowerCase().indexOf("dc=");
                this.searchBase = bindDn.substring(dcIndex);
            }
        }
        catch (Throwable t) {
            this.logFile.println("ERROR: Failed to initialize the user sync properties " + t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findBasicUserProperties(LdapContext ldapContext, boolean isOutputNeeded) throws Throwable {
        String bindDn = this.config.getLdapBindDn();
        String userSFilter = this.config.getUserSearchFilter();
        String userSBase = this.config.getUserSearchBase();
        Attribute userNameAttr = null;
        SearchControls userSearchControls = new SearchControls();
        userSearchControls.setSearchScope(this.config.getUserSearchScope());
        userSearchControls.setReturningAttributes(new String[]{"*", "+"});
        int noOfUsers = 0;
        NamingEnumeration<SearchResult> userSearchResultEnum = null;
        try {
            if (userSBase == null || userSBase.isEmpty()) {
                if (bindDn.contains("@")) {
                    userSBase = bindDn.substring(bindDn.indexOf("@") + 1);
                    userSBase = "dc=".concat(userSBase);
                    userSBase = userSBase.replaceAll("\\.", ",dc=");
                } else {
                    userSBase = bindDn.substring(bindDn.indexOf(",") + 1);
                }
            }
            if (userSFilter == null || userSFilter.isEmpty()) {
                if (bindDn.contains("@")) {
                    userSFilter = "userPrincipalName=" + bindDn;
                } else {
                    int cnEndIndex = bindDn.indexOf(",");
                    userSFilter = bindDn.substring(0, cnEndIndex);
                }
            }
            try {
                userSearchResultEnum = ldapContext.search(userSBase, userSFilter, userSearchControls);
                while (userSearchResultEnum.hasMore() && noOfUsers < 5) {
                    String userName;
                    SearchResult userEntry = userSearchResultEnum.next();
                    if (userEntry == null) {
                        this.logFile.println("WARN: userEntry null");
                        continue;
                    }
                    Attributes attributes = userEntry.getAttributes();
                    if (attributes == null) {
                        this.logFile.println("WARN: Attributes missing for entry " + userEntry.getNameInNamespace());
                        continue;
                    }
                    if (this.userNameAttribute == null || this.userNameAttribute.isEmpty()) {
                        for (String nameAttrValue : userNameAttrValues) {
                            userNameAttr = attributes.get(nameAttrValue);
                            if (userNameAttr == null) continue;
                            this.userNameAttribute = nameAttrValue;
                            break;
                        }
                        if (userNameAttr == null) {
                            this.logFile.print("WARN: Failed to find any of ( ");
                            for (String userNameAttrValue : userNameAttrValues) {
                                this.logFile.print(userNameAttrValue + " ");
                            }
                            this.logFile.println(") for entry " + userEntry.getNameInNamespace());
                            continue;
                        }
                    } else {
                        userNameAttr = attributes.get(this.userNameAttribute);
                        if (userNameAttr == null) {
                            this.logFile.println("WARN: Failed to find " + this.userNameAttribute + " for entry " + userEntry.getNameInNamespace());
                            continue;
                        }
                    }
                    if ((userName = (String)userNameAttr.get()) == null || userName.trim().isEmpty()) {
                        this.logFile.println("WARN: " + this.userNameAttribute + " empty for entry " + userEntry.getNameInNamespace());
                        continue;
                    }
                    userName = userName.toLowerCase();
                    Attribute userObjClassAttr = attributes.get("objectClass");
                    NamingEnumeration<?> userObjClassEnum = userObjClassAttr.getAll();
                    String userObjClass = null;
                    block12: while (userObjClassEnum.hasMore()) {
                        userObjClass = userObjClassEnum.next().toString();
                        if (this.userObjClassName != null && !this.userObjClassName.isEmpty()) continue;
                        if (userObjClass != null) {
                            for (String userObjClassValue : userObjClassValues) {
                                if (!userObjClass.equalsIgnoreCase(userObjClassValue)) continue;
                                this.userObjClassName = userObjClass;
                                continue block12;
                            }
                            continue;
                        }
                        this.logFile.println("WARN: Failed to find objectClass attribute for " + userName);
                    }
                    if (this.userObjClassName == null || this.userObjClassName.isEmpty()) {
                        this.userObjClassName = userObjClass;
                    }
                    for (String userGroupMemAttrValue : userGroupMemAttrValues) {
                        Attribute groupMemberAttr = attributes.get(userGroupMemAttrValue);
                        if (groupMemberAttr == null) continue;
                        this.userGroupMemberName = userGroupMemAttrValue;
                        this.groupName = groupMemberAttr.get(0).toString();
                        break;
                    }
                    ++noOfUsers;
                }
            }
            catch (NamingException ne) {
                String msg = "Exception occurred while discovering basic user properties:\nranger.usersync.ldap.user.nameattribute\nranger.usersync.ldap.user.objectclass\nranger.usersync.ldap.user.groupnameattribute\n";
                if (this.config.getUserSearchBase() != null && !this.config.getUserSearchBase().isEmpty() || this.config.getUserSearchFilter() != null && !this.config.getUserSearchFilter().isEmpty()) {
                    throw new Exception(msg + "Please verify values for ranger.usersync.ldap.user.searchbase and ranger.usersync.ldap.user.searchfilter");
                }
                throw new Exception(msg + ne);
            }
            if (isOutputNeeded) {
                this.installProps.println("# Possible values for user search related properties:");
                this.installProps.println("SYNC_LDAP_USER_NAME_ATTRIBUTE=" + this.userNameAttribute);
                this.installProps.println("SYNC_LDAP_USER_OBJECT_CLASS=" + this.userObjClassName);
                this.installProps.println("SYNC_LDAP_USER_GROUP_NAME_ATTRIBUTE=" + this.userGroupMemberName);
                this.ambariProps.println("# Possible values for user search related properties:");
                this.ambariProps.println("ranger.usersync.ldap.user.nameattribute=" + this.userNameAttribute);
                this.ambariProps.println("ranger.usersync.ldap.user.objectclass=" + this.userObjClassName);
                this.ambariProps.println("ranger.usersync.ldap.user.groupnameattribute=" + this.userGroupMemberName);
            }
        }
        finally {
            try {
                if (userSearchResultEnum != null) {
                    userSearchResultEnum.close();
                }
            }
            catch (NamingException ne) {
                this.logFile.println("ERROR: Exception occurred while closing user search result: " + ne.getMessage());
            }
        }
    }

    private void findAdvUserProperties(LdapContext ldapContext, boolean isOutputNeeded) throws Throwable {
        NamingEnumeration<SearchResult> userSearchResultEnum = null;
        SearchControls userSearchControls = new SearchControls();
        userSearchControls.setSearchScope(this.config.getUserSearchScope());
        if (this.userNameAttribute != null && !this.userNameAttribute.isEmpty()) {
            HashSet<String> userSearchAttributes = new HashSet<String>();
            userSearchAttributes.add(this.userNameAttribute);
            userSearchAttributes.add(this.userGroupMemberName);
            userSearchAttributes.add("distinguishedName");
            userSearchControls.setReturningAttributes(userSearchAttributes.toArray(new String[userSearchAttributes.size()]));
        } else {
            userSearchControls.setReturningAttributes(new String[]{"*", "+"});
        }
        String extendedUserSearchFilter = "(objectclass=" + this.userObjClassName + ")";
        try {
            HashMap<String, Integer> ouOccurences = new HashMap<String, Integer>();
            userSearchResultEnum = this.userSearchBase == null || this.userSearchBase.isEmpty() ? ldapContext.search(this.searchBase, extendedUserSearchFilter, userSearchControls) : ldapContext.search(this.userSearchBase, extendedUserSearchFilter, userSearchControls);
            int noOfUsers = 0;
            while (userSearchResultEnum.hasMore() && noOfUsers < 20) {
                String dnValue;
                SearchResult userEntry = userSearchResultEnum.next();
                if (userEntry == null) {
                    this.logFile.println("WARN: userEntry null");
                    continue;
                }
                Attributes attributes = userEntry.getAttributes();
                if (attributes == null) {
                    this.logFile.println("WARN: Attributes missing for entry " + userEntry.getNameInNamespace());
                    continue;
                }
                Attribute dnAttr = attributes.get("distinguishedName");
                if (dnAttr != null) {
                    String ouStr;
                    dnValue = dnAttr.get().toString();
                    int indexOfOU = dnValue.indexOf(ouStr = "OU=");
                    dnValue = indexOfOU > 0 ? dnValue.substring(indexOfOU) : dnValue.substring(dnValue.indexOf(",") + 1);
                } else {
                    dnValue = userEntry.getNameInNamespace();
                    dnValue = dnValue.substring(dnValue.indexOf(",") + 1);
                }
                Integer ouOccrs = (Integer)ouOccurences.get(dnValue);
                if (ouOccrs == null) {
                    ouOccrs = 0;
                }
                int val = ouOccrs;
                ouOccrs = ++val;
                ouOccurences.put(dnValue, ouOccrs);
                ++noOfUsers;
            }
            if (!ouOccurences.isEmpty()) {
                Set keys = ouOccurences.keySet();
                int maxOUOccr = 0;
                for (String key : keys) {
                    int ouOccurVal = (Integer)ouOccurences.get(key);
                    this.logFile.println("INFO: No. of users from " + key + " = " + ouOccurVal);
                    if (ouOccurVal <= maxOUOccr) continue;
                    maxOUOccr = ouOccurVal;
                    this.userSearchBase = key;
                }
            }
            if (this.userSearchFilter == null || this.userSearchFilter.isEmpty()) {
                this.userSearchFilter = this.userNameAttribute + "=*";
            }
            if (isOutputNeeded) {
                this.installProps.println("SYNC_LDAP_USER_SEARCH_BASE=" + this.userSearchBase);
                this.installProps.println("SYNC_LDAP_USER_SEARCH_FILTER=" + this.userSearchFilter);
                this.ambariProps.println("ranger.usersync.ldap.user.searchbase=" + this.userSearchBase);
                this.ambariProps.println("ranger.usersync.ldap.user.searchfilter=" + this.userSearchFilter);
            }
        }
        catch (NamingException ne) {
            String msg = "Exception occured while discovering user properties:\nranger.usersync.ldap.user.searchbase\nranger.usersync.ldap.user.searchfilter\n";
            if (this.config.getUserNameAttribute() != null && !this.config.getUserNameAttribute().isEmpty() || this.config.getUserObjectClass() != null && !this.config.getUserObjectClass().isEmpty() || this.config.getGroupNameAttribute() != null && !this.config.getGroupNameAttribute().isEmpty()) {
                throw new Exception("Please verify values for ranger.usersync.ldap.user.nameattribute, ranger.usersync.ldap.user.objectclass, and ranger.usersync.ldap.user.groupnameattribute");
            }
            throw new Exception(msg + ne);
        }
        finally {
            if (userSearchResultEnum != null) {
                userSearchResultEnum.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findBasicGroupProperties(LdapContext ldapContext) throws Throwable {
        NamingEnumeration<SearchResult> groupSearchResultEnum = null;
        SearchControls groupSearchControls = new SearchControls();
        groupSearchControls.setSearchScope(this.config.getGroupSearchScope());
        try {
            if (this.groupName == null || this.groupName.isEmpty()) {
                groupSearchResultEnum = ldapContext.search(this.searchBase, null);
            } else {
                int baseIndex = this.groupName.indexOf(",");
                String groupBase = this.groupName.substring(baseIndex + 1);
                String groupFilter = this.groupName.substring(0, baseIndex);
                groupSearchResultEnum = ldapContext.search(groupBase, groupFilter, groupSearchControls);
            }
            int noOfGroups = 0;
            while (groupSearchResultEnum.hasMore() && noOfGroups < 1) {
                SearchResult groupEntry = groupSearchResultEnum.next();
                if (groupEntry == null) continue;
                Attributes groupAttributes = groupEntry.getAttributes();
                if (groupAttributes == null) {
                    this.logFile.println("WARN: Attributes missing for entry " + groupEntry.getNameInNamespace());
                    continue;
                }
                Attribute groupObjClassAttr = groupAttributes.get("objectClass");
                if (groupObjClassAttr != null) {
                    NamingEnumeration<?> groupObjClassEnum = groupObjClassAttr.getAll();
                    block4: while (groupObjClassEnum.hasMore()) {
                        String groupObjClassStr = groupObjClassEnum.next().toString();
                        for (String groupObjectClassValue : groupObjectClassValues) {
                            if (!groupObjClassStr.equalsIgnoreCase(groupObjectClassValue)) continue;
                            this.groupObjClassName = groupObjClassStr;
                            continue block4;
                        }
                    }
                } else {
                    this.logFile.println("WARN: Failed to find group objectClass attribute for " + groupEntry.getNameInNamespace());
                    continue;
                }
                if (this.groupNameAttrName == null || this.groupNameAttrName.isEmpty()) {
                    for (String groupNameAttrValue : groupNameAttrValues) {
                        Attribute groupNameAttr = groupAttributes.get(groupNameAttrValue);
                        if (groupNameAttr == null) continue;
                        this.groupNameAttrName = groupNameAttrValue;
                        break;
                    }
                }
                for (String groupMemAttrValue : groupMemAttrValues) {
                    Attribute groupMemberAttr = groupAttributes.get(groupMemAttrValue);
                    if (groupMemberAttr == null) continue;
                    this.groupMemberName = groupMemAttrValue;
                    break;
                }
                ++noOfGroups;
            }
            this.installProps.println("\n# Possible values for group search related properties:");
            this.installProps.println("SYNC_GROUP_MEMBER_ATTRIBUTE_NAME=" + this.groupMemberName);
            this.installProps.println("SYNC_GROUP_NAME_ATTRIBUTE=" + this.groupNameAttrName);
            this.installProps.println("SYNC_GROUP_OBJECT_CLASS=" + this.groupObjClassName);
            this.ambariProps.println("\n# Possible values for group search related properties:");
            this.ambariProps.println("ranger.usersync.group.memberattributename=" + this.groupMemberName);
            this.ambariProps.println("ranger.usersync.group.nameattribute=" + this.groupNameAttrName);
            this.ambariProps.println("ranger.usersync.group.objectclass=" + this.groupObjClassName);
        }
        finally {
            if (groupSearchResultEnum != null) {
                groupSearchResultEnum.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAdvGroupProperties(LdapContext ldapContext) throws Throwable {
        int noOfGroups = 0;
        NamingEnumeration<SearchResult> groupSearchResultEnum = null;
        SearchControls groupSearchControls = new SearchControls();
        HashSet<String> groupSearchAttributes = new HashSet<String>();
        groupSearchControls.setSearchScope(this.config.getGroupSearchScope());
        groupSearchAttributes.add(this.groupNameAttrName);
        groupSearchAttributes.add(this.groupMemberName);
        groupSearchAttributes.add("distinguishedName");
        groupSearchControls.setReturningAttributes(groupSearchAttributes.toArray(new String[groupSearchAttributes.size()]));
        String extendedGroupSearchFilter = "(objectclass=" + this.groupObjClassName + ")";
        try {
            HashMap<String, Integer> ouOccurences = new HashMap<String, Integer>();
            groupSearchResultEnum = this.groupSearchBase == null || this.groupSearchBase.isEmpty() ? ldapContext.search(this.searchBase, extendedGroupSearchFilter, groupSearchControls) : ldapContext.search(this.groupSearchBase, extendedGroupSearchFilter, groupSearchControls);
            while (groupSearchResultEnum.hasMore() && noOfGroups < 20) {
                String dnValue;
                SearchResult groupEntry = groupSearchResultEnum.next();
                if (groupEntry == null) continue;
                Attributes groupAttributes = groupEntry.getAttributes();
                if (groupAttributes == null) {
                    this.logFile.println("WARN: Attributes missing for entry " + groupEntry.getNameInNamespace());
                    continue;
                }
                Attribute dnAttr = groupAttributes.get("distinguishedName");
                if (dnAttr != null) {
                    String ouStr;
                    dnValue = dnAttr.get().toString();
                    int indexOfOU = dnValue.indexOf(ouStr = "OU=");
                    dnValue = indexOfOU > 0 ? dnValue.substring(indexOfOU) : dnValue.substring(dnValue.indexOf(",") + 1);
                } else {
                    dnValue = groupEntry.getNameInNamespace();
                    dnValue = dnValue.substring(dnValue.indexOf(",") + 1);
                }
                Integer ouOccrs = (Integer)ouOccurences.get(dnValue);
                if (ouOccrs == null) {
                    ouOccrs = 0;
                }
                int val = ouOccrs;
                ouOccrs = ++val;
                ouOccurences.put(dnValue, ouOccrs);
                ++noOfGroups;
            }
            if (!ouOccurences.isEmpty()) {
                Set keys = ouOccurences.keySet();
                int maxOUOccr = 0;
                for (String key : keys) {
                    int ouOccurVal = (Integer)ouOccurences.get(key);
                    this.logFile.println("INFO: No. of groups from " + key + " = " + ouOccurVal);
                    if (ouOccurVal <= maxOUOccr) continue;
                    maxOUOccr = ouOccurVal;
                    this.groupSearchBase = key;
                }
            }
            if (this.groupSearchFilter == null || this.groupSearchFilter.isEmpty()) {
                this.groupSearchFilter = this.groupNameAttrName + "=*";
            }
            this.installProps.println("SYNC_GROUP_SEARCH_BASE=" + this.groupSearchBase);
            this.installProps.println("SYNC_LDAP_GROUP_SEARCH_FILTER=" + this.groupSearchFilter);
            this.ambariProps.println("ranger.usersync.group.searchbase=" + this.groupSearchBase);
            this.ambariProps.println("ranger.usersync.group.searchfilter=" + this.groupSearchFilter);
        }
        finally {
            if (groupSearchResultEnum != null) {
                groupSearchResultEnum.close();
            }
        }
    }
}

