/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ldapconfigcheck;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import org.apache.commons.lang.NullArgumentException;
import org.apache.ranger.ldapconfigcheck.AuthenticationCheck;
import org.apache.ranger.ldapconfigcheck.CommandLineOptions;
import org.apache.ranger.ldapconfigcheck.LdapConfig;
import org.apache.ranger.ldapconfigcheck.UserSync;

public class LdapConfigCheckMain {
    private static final String LOG_FILE = "ldapConfigCheck.log";
    private static final String AMBARI_PROPERTIES = "ambari.properties";
    private static final String INSTALL_PROPERTIES = "install.properties";

    private LdapConfigCheckMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CommandLineOptions cli = new CommandLineOptions(args);
        cli.parse();
        String inFileName = cli.getInput();
        String outputDir = cli.getOutput();
        if (!outputDir.endsWith("/")) {
            outputDir = outputDir.concat("/");
        }
        LdapConfig config = new LdapConfig(inFileName, cli.getBindPassword());
        if (cli.getLdapUrl() != null && !cli.getLdapUrl().isEmpty()) {
            config.updateInputPropFile(cli.getLdapUrl(), cli.getBindDn(), cli.getBindPassword(), cli.getUserSearchBase(), cli.getUserSearchFilter(), cli.getAuthUser(), cli.getAuthPass());
        }
        PrintStream logFile = null;
        PrintStream ambariProps = null;
        PrintStream installProps = null;
        Context ldapContext = null;
        try {
            logFile = new PrintStream(outputDir + LOG_FILE);
            ambariProps = new PrintStream(outputDir + AMBARI_PROPERTIES);
            installProps = new PrintStream(outputDir + INSTALL_PROPERTIES);
            UserSync userSyncObj = new UserSync(config, logFile, ambariProps, installProps);
            String bindDn = config.getLdapBindDn();
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", config.getLdapUrl());
            env.put("java.naming.security.principal", bindDn);
            env.put("java.naming.security.credentials", cli.getBindPassword());
            env.put("java.naming.security.authentication", config.getLdapAuthenticationMechanism());
            env.put("java.naming.referral", "follow");
            ldapContext = new InitialLdapContext(env, null);
            if (config.isPagedResultsEnabled()) {
                ldapContext.setRequestControls(new Control[]{new PagedResultsControl(config.getPagedResultsSize(), true)});
            }
            String retrieveValues = "all";
            if (cli.getDiscoverProperties() != null) {
                retrieveValues = cli.getDiscoverProperties();
                if (cli.getDiscoverProperties().equalsIgnoreCase("users")) {
                    userSyncObj.findUserProperties((LdapContext)ldapContext);
                } else if (cli.getDiscoverProperties().equalsIgnoreCase("groups")) {
                    userSyncObj.findGroupProperties((LdapContext)ldapContext);
                } else {
                    LdapConfigCheckMain.findAllUserSyncProperties((LdapContext)ldapContext, userSyncObj);
                }
            } else if (cli.getRetrieveValues() != null) {
                retrieveValues = cli.getRetrieveValues();
            } else {
                cli.help();
            }
            if (cli.isAuthEnabled()) {
                LdapConfigCheckMain.authenticate(userSyncObj, config, logFile, ambariProps, installProps);
            }
            LdapConfigCheckMain.retrieveUsersGroups((LdapContext)ldapContext, userSyncObj, retrieveValues);
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        catch (FileNotFoundException fe) {
            System.out.println(fe.getMessage());
        }
        catch (IOException ioe) {
            logFile.println("ERROR: Failed while setting the paged results controls\n" + ioe);
        }
        catch (NamingException ne) {
            System.out.println("ERROR: Failed to perfom ldap bind. Please verify values for ranger.usersync.ldap.binddn and ranger.usersync.ldap.ldapbindpassword\n" + ne);
        }
        catch (Throwable t) {
            if (logFile != null) {
                logFile.println("ERROR: Connection failed: " + t.getMessage());
            } else {
                System.out.println("ERROR: Connection failed: " + t.getMessage());
            }
        }
        finally {
            if (logFile != null) {
                logFile.close();
            }
            if (ambariProps != null) {
                ambariProps.close();
            }
            if (installProps != null) {
                installProps.close();
            }
            try {
                if (ldapContext != null) {
                    ldapContext.close();
                }
            }
            catch (NamingException ne) {
                System.out.println("Failed to close LdapContext!");
            }
        }
    }

    private static void findAllUserSyncProperties(LdapContext ldapContext, UserSync userSyncObj) throws Throwable {
        userSyncObj.findUserProperties(ldapContext);
        userSyncObj.findGroupProperties(ldapContext);
    }

    private static void authenticate(UserSync userSyncObj, LdapConfig config, PrintStream logFile, PrintStream ambariProps, PrintStream installProps) {
        AuthenticationCheck auth = new AuthenticationCheck(config.getLdapUrl(), userSyncObj, logFile, ambariProps, installProps);
        auth.discoverAuthProperties();
        if (config.getAuthUsername() == null || config.getAuthUsername().isEmpty()) {
            throw new NullArgumentException("ranger.admin.auth.sampleuser ");
        }
        if (config.getAuthPassword() == null || config.getAuthPassword().isEmpty()) {
            throw new NullArgumentException("ranger.admin.auth.samplepassword ");
        }
        if (auth.isAuthenticated(config.getLdapUrl(), config.getLdapBindDn(), config.getLdapBindPassword(), config.getAuthUsername(), config.getAuthPassword())) {
            logFile.println("INFO: Authentication verified successfully");
        } else {
            logFile.println("ERROR: Failed to authenticate " + config.getAuthUsername());
        }
    }

    private static void retrieveUsersGroups(LdapContext ldapContext, UserSync userSyncObj, String retrieve) throws Throwable {
        if (retrieve == null || userSyncObj == null || ldapContext == null) {
            throw new NullArgumentException("Input validation failed while retrieving Users or Groups");
        }
        if (retrieve.equalsIgnoreCase("users")) {
            LdapConfigCheckMain.retrieveUsers(ldapContext, userSyncObj);
        } else if (retrieve.equalsIgnoreCase("groups")) {
            LdapConfigCheckMain.retrieveGroups(ldapContext, userSyncObj);
        } else {
            LdapConfigCheckMain.retrieveUsers(ldapContext, userSyncObj);
            LdapConfigCheckMain.retrieveGroups(ldapContext, userSyncObj);
        }
    }

    private static void retrieveUsers(LdapContext ldapContext, UserSync userSyncObj) throws Throwable {
        if (userSyncObj.getUserNameAttribute() == null || userSyncObj.getUserNameAttribute().isEmpty()) {
            throw new NullArgumentException("ranger.usersync.ldap.user.nameattribute ");
        }
        if (userSyncObj.getUserObjClassName() == null || userSyncObj.getUserObjClassName().isEmpty()) {
            throw new NullArgumentException("ranger.usersync.ldap.user.objectclass ");
        }
        if ((userSyncObj.getUserSearchBase() == null || userSyncObj.getUserSearchBase().isEmpty()) && (userSyncObj.getSearchBase() == null || userSyncObj.getSearchBase().isEmpty())) {
            throw new NullArgumentException("ranger.usersync.ldap.user.searchbase and ranger.usersync.ldap.searchBase");
        }
        userSyncObj.getAllUsers(ldapContext);
    }

    private static void retrieveGroups(LdapContext ldapContext, UserSync userSyncObj) throws Throwable {
        if (userSyncObj.getGroupNameAttrName() == null || userSyncObj.getGroupNameAttrName().isEmpty()) {
            throw new NullArgumentException("ranger.usersync.group.nameattribute ");
        }
        if (userSyncObj.getGroupObjClassName() == null || userSyncObj.getGroupObjClassName().isEmpty()) {
            throw new NullArgumentException("ranger.usersync.group.objectclass ");
        }
        if (userSyncObj.getGroupMemberName() == null || userSyncObj.getGroupMemberName().isEmpty()) {
            throw new NullArgumentException("ranger.usersync.group.memberattributename ");
        }
        if ((userSyncObj.getGroupSearchBase() == null || userSyncObj.getGroupSearchBase().isEmpty()) && (userSyncObj.getSearchBase() == null || userSyncObj.getSearchBase().isEmpty())) {
            throw new NullArgumentException("ranger.usersync.group.searchbase and ranger.usersync.ldap.searchBase");
        }
        userSyncObj.getAllGroups(ldapContext);
    }
}

