/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ldapconfigcheck;

import java.io.Console;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandLineOptions {
    private final Options options = new Options();
    private final String[] args;
    private String input;
    private String output;
    private String discoverProperties;
    private String retrieveValues;
    private String ldapUrl = "";
    private String bindDn = "";
    private String bindPassword = "";
    private String userSearchBase = "";
    private String userSearchFilter = "";
    private String authUser = "";
    private String authPass = "";
    private boolean isAuthEnabled = true;

    public CommandLineOptions(String[] args) {
        this.args = args;
        this.options.addOption("h", "help", false, "show help.");
        this.options.addOption("i", "inputfile", true, "Input file name");
        this.options.addOption("o", "outputdir", true, "Output directory");
        this.options.addOption("d", "discoverProperties", true, "{all|users|groups}");
        this.options.addOption("r", "retrieve", true, "{all|users|groups}");
        this.options.addOption("a", "noAuthentication", false, "Ignore authentication properties");
        this.options.addOption("p", true, "Ldap Bind Password");
        this.options.addOption("u", true, "Sample Authentication User Password");
    }

    public void parse() {
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(this.options, this.args);
            if (cmd.hasOption("p")) {
                this.bindPassword = cmd.getOptionValue("p");
                if (this.bindPassword.trim().isEmpty()) {
                    System.out.println("Ldap Bind Password cannot be empty!");
                }
            }
            if (cmd.hasOption("u")) {
                this.authPass = cmd.getOptionValue("u");
                if (this.authPass.trim().isEmpty()) {
                    System.out.println("Sample Authentication User Password cannot be empty!");
                }
            }
            if (cmd.hasOption("o")) {
                this.output = cmd.getOptionValue("o");
            } else {
                System.out.println("Missing o option for output directory");
                this.help();
            }
            if (cmd.hasOption("d")) {
                this.discoverProperties = cmd.getOptionValue("d");
                if (this.discoverProperties == null || !this.discoverProperties.equalsIgnoreCase("all") && !this.discoverProperties.equalsIgnoreCase("users") && !this.discoverProperties.equalsIgnoreCase("groups")) {
                    System.out.println("Unsupported value for option d");
                    this.help();
                }
            } else if (cmd.hasOption("r")) {
                this.retrieveValues = cmd.getOptionValue("r");
                if (this.retrieveValues == null || !this.retrieveValues.equalsIgnoreCase("all") && !this.retrieveValues.equalsIgnoreCase("users") && !this.retrieveValues.equalsIgnoreCase("groups")) {
                    System.out.println("Unsupported value for option r");
                    this.help();
                }
            } else {
                System.out.println("Default to discover all usersync properties");
                this.discoverProperties = "all";
            }
            if (cmd.hasOption("a") || this.discoverProperties == null || !this.discoverProperties.equalsIgnoreCase("all")) {
                this.isAuthEnabled = false;
            }
            if (cmd.hasOption("i")) {
                this.input = cmd.getOptionValue("i");
                if (this.input == null || this.input.isEmpty()) {
                    System.out.println("Please specify the input properties file name");
                    this.help();
                }
                if (this.bindPassword == null || this.bindPassword.trim().isEmpty()) {
                    System.out.println("Missing Ldap Bind Password!");
                }
            } else {
                this.input = "input.properties";
                this.readCLI();
            }
        }
        catch (ParseException pe) {
            System.out.println("Failed to parse command line arguments " + (Object)((Object)pe));
            this.help();
        }
    }

    public void help() {
        HelpFormatter formater = new HelpFormatter();
        formater.printHelp("ldapConfigCheck", this.options);
        System.exit(0);
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public String getDiscoverProperties() {
        return this.discoverProperties;
    }

    public boolean isAuthEnabled() {
        return this.isAuthEnabled;
    }

    public String getRetrieveValues() {
        return this.retrieveValues;
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public String getAuthPass() {
        return this.authPass;
    }

    private void readCLI() {
        char[] password;
        boolean repeat;
        Console console = System.console();
        do {
            repeat = false;
            System.out.print("Ldap url [ldap://ldap.example.com:389]: ");
            this.ldapUrl = console.readLine();
            if (this.ldapUrl != null && !this.ldapUrl.isEmpty()) continue;
            System.out.println("Please enter valid ldap url.");
            repeat = true;
        } while (repeat);
        do {
            repeat = false;
            System.out.print("Bind DN [cn=admin,ou=users,dc=example,dc=com]: ");
            this.bindDn = console.readLine();
            if (this.bindDn != null && !this.bindDn.isEmpty()) continue;
            System.out.println("Please enter valid bindDn.");
            repeat = true;
        } while (repeat);
        do {
            repeat = false;
            System.out.print("Bind Password: ");
            password = console.readPassword();
            this.bindPassword = String.valueOf(password);
            if (!this.bindPassword.isEmpty()) continue;
            System.out.println("Bind Password can't be empty.");
            repeat = true;
        } while (repeat);
        System.out.print("User Search Base [ou=users,dc=example,dc=com]: ");
        this.userSearchBase = console.readLine();
        System.out.print("User Search Filter [cn=user1]: ");
        this.userSearchFilter = console.readLine();
        if (this.isAuthEnabled) {
            do {
                repeat = false;
                System.out.print("Sample Authentication User [user1]: ");
                this.authUser = console.readLine();
                if (this.authUser != null && !this.authUser.isEmpty()) continue;
                System.out.println("Sample Authentication user must not be empty!");
                repeat = true;
            } while (repeat);
            do {
                repeat = false;
                System.out.print("Sample Authentication Password: ");
                password = console.readPassword();
                this.authPass = String.valueOf(password);
                if (!this.authPass.isEmpty()) continue;
                System.out.println("Sample Authentication password must not be empty!");
                repeat = true;
            } while (repeat);
        }
    }
}

