/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util.sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.util.outputformatter.JisqlFormatter;
import org.apache.util.sql.MySQLPLRunner;

public class Jisql {
    private static final String sapJDBC4SqlAnywhereDriverName = "sap.jdbc4.sqlanywhere.IDriver";
    private static final String sybaseJDBC4SqlAnywhereDriverName = "sybase.jdbc4.sqlanywhere.IDriver";
    private static final String sybaseJConnect6DriverName = "com.sybase.jdbc3.jdbc.SybDriver";
    private static final String sybaseJConnect5DriverName = "com.sybase.jdbc2.jdbc.SybDriver";
    private static final String sybaseJConnect4DriverName = "com.sybase.jdbc.SybDriver";
    private static final String oracleThinDriverName = "oracle.jdbc.driver.OracleDriver";
    private static final String db2AppDriverName = "COM.ibm.db2.jdbc.app.DB2Driver";
    private static final String db2NetDriverName = "COM.ibm.db2.jdbc.net.DB2Driver";
    private static final String cloudscapeDriverName = "COM.cloudscape.core.JDBCDriver";
    private static final String msqlDriverName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String pointbaseDriverName = "com.pointbase.jdbc.jdbcUniversalDriver";
    private static final String postgresqlDriverName = "org.postgresql.Driver";
    private static final String mySQLConnectJDriverName = "com.mysql.jdbc.Driver";
    private static final String mySQLCauchoDriverName = "com.caucho.jdbc.mysql.Driver";
    private static final String defaultFormatterClassName = "org.apache.util.outputformatter.DefaultFormatter";
    private static final String csvFormatterClassName = "org.apache.util.outputformatter.CSVFormatter";
    private static final String xmlFormatterClassName = "org.apache.util.outputformatter.XMLFormatter";
    private String driverName;
    private String connectString;
    private String userName;
    private String password;
    private String passwordFileName;
    private String inputFileName;
    private String inputQuery;
    private String commandTerminator = "go";
    private String formatterClassName = "org.apache.util.outputformatter.DefaultFormatter";
    private JisqlFormatter formatter;
    private Connection connection;
    private Driver driver;
    private Properties props;
    private boolean printDebug;
    private boolean printDriverDetails;

    public static void main(String[] argv) {
        Jisql jisql = new Jisql();
        try {
            jisql.parseArgs(argv);
        }
        catch (Throwable t) {
            t.printStackTrace();
            jisql.usage();
            System.exit(1);
        }
        try {
            jisql.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block37: {
            boolean isExit = false;
            try {
                this.driver = (Driver)Class.forName(this.driverName).newInstance();
                this.props = new Properties();
                this.props.put("user", this.userName);
                if (this.password != null) {
                    this.props.put("password", this.password);
                }
                this.connection = DriverManager.getConnection(this.connectString, this.props);
                if (this.printDriverDetails) {
                    this.printDriverInfo();
                    break block37;
                }
                if (this.connectString.toLowerCase().startsWith("jdbc:mysql") && this.inputFileName != null) {
                    MySQLPLRunner scriptRunner = new MySQLPLRunner(this.connection, false, true, this.printDebug);
                    scriptRunner.setDelimiter(this.commandTerminator, false);
                    try (FileReader reader = new FileReader(this.inputFileName);){
                        scriptRunner.runScript(reader);
                        break block37;
                    }
                }
                this.doIsql();
            }
            catch (SQLException sqle) {
                this.printAllExceptions(sqle);
                isExit = true;
            }
            catch (IOException ie) {
                isExit = true;
            }
            catch (ClassNotFoundException cnfe) {
                isExit = true;
                System.err.println("Cannot find the driver class \"" + this.driverName + "\" in the current classpath.");
            }
            catch (InstantiationException ie) {
                isExit = true;
                System.err.println("Cannot instantiate the driver class \"" + this.driverName + "\"");
                ie.printStackTrace(System.err);
            }
            catch (IllegalAccessException iae) {
                isExit = true;
                System.err.println("Cannot instantiate the driver class \"" + this.driverName + "\" because of an IllegalAccessException");
                iae.printStackTrace(System.err);
            }
            finally {
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (SQLException sqle) {}
                    if (isExit) {
                        System.exit(1);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doIsql() throws IOException, SQLException {
        BufferedReader reader;
        ResultSet resultSet = null;
        if (this.inputFileName != null) {
            try {
                reader = new BufferedReader(new FileReader(this.inputFileName));
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("Unable to open file \"" + this.inputFileName + "\"");
                fnfe.printStackTrace(System.err);
                throw fnfe;
            }
        } else {
            reader = new BufferedReader(new InputStreamReader(System.in));
        }
        if (this.printDebug) {
            this.printAllExceptions(this.connection.getWarnings());
        }
        Statement statement = this.connection.createStatement();
        this.connection.clearWarnings();
        try {
            while (true) {
                int linecount = 1;
                StringBuilder query = new StringBuilder();
                try {
                    if (this.inputFileName == null && this.inputQuery == null) {
                        System.out.print("\nEnter a query:\n");
                    }
                    while (true) {
                        String line;
                        if (this.inputFileName == null && this.inputQuery == null) {
                            System.out.print(linecount++ + " > ");
                            System.out.flush();
                        }
                        if ((line = this.inputQuery == null ? reader.readLine() : this.inputQuery) == null || line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit")) {
                            if (this.inputFileName == null) return;
                            if (this.inputQuery == null) return;
                            break;
                        }
                        if (line.equals("reset")) {
                            query = new StringBuilder();
                            break;
                        }
                        String trimmedLine = line.trim();
                        if (trimmedLine.startsWith("--") || trimmedLine.isEmpty()) continue;
                        if (this.connectString.toLowerCase().startsWith("jdbc:oracle") && this.inputFileName != null) {
                            if (trimmedLine.startsWith("/") || trimmedLine.length() < 2) {
                                this.commandTerminator = ";";
                                continue;
                            }
                            if (trimmedLine.toUpperCase().startsWith("DECLARE")) {
                                this.commandTerminator = "/";
                            }
                            if (trimmedLine.toUpperCase().startsWith("CREATE OR REPLACE PROCEDURE") || trimmedLine.toUpperCase().startsWith("CREATE OR REPLACE FUNCTION")) {
                                this.commandTerminator = "/";
                            }
                        }
                        if (this.connectString.toLowerCase().startsWith("jdbc:postgresql") && this.inputFileName != null && trimmedLine.toLowerCase().startsWith("select 'delimiter start';")) {
                            this.commandTerminator = "select 'delimiter end';";
                            continue;
                        }
                        if (line.trim().equalsIgnoreCase(this.commandTerminator) || line.trim().endsWith(this.commandTerminator)) {
                            if (!line.trim().endsWith(this.commandTerminator)) break;
                            line = line.substring(0, line.length() - this.commandTerminator.length());
                            query.append("\n");
                            query.append(line);
                            break;
                        }
                        query.append("\n");
                        query.append(line);
                    }
                    if (query.toString().isEmpty()) continue;
                    if (this.printDebug) {
                        System.out.println("executing: " + query);
                    }
                    boolean moreResults = statement.execute(query.toString());
                    int rowsAffected = 0;
                    do {
                        if (this.printDebug) {
                            this.printAllExceptions(statement.getWarnings());
                        }
                        statement.clearWarnings();
                        if (moreResults) {
                            resultSet = statement.getResultSet();
                            if (this.printDebug) {
                                this.printAllExceptions(resultSet.getWarnings());
                            }
                            resultSet.clearWarnings();
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            this.formatter.formatHeader(System.out, resultSetMetaData);
                            this.formatter.formatData(System.out, resultSet, resultSetMetaData);
                            this.formatter.formatFooter(System.out, resultSetMetaData);
                            int rowsSelected = statement.getUpdateCount();
                            if (rowsSelected >= 0 && this.printDebug) {
                                System.out.println(rowsSelected + " rows affected.");
                            }
                        } else {
                            rowsAffected = statement.getUpdateCount();
                            if (this.printDebug) {
                                this.printAllExceptions(statement.getWarnings());
                            }
                            statement.clearWarnings();
                            if (rowsAffected >= 0 && this.printDebug) {
                                System.out.println(rowsAffected + " rows affected.");
                            }
                        }
                        try {
                            moreResults = statement.getMoreResults();
                        }
                        catch (NullPointerException npe) {
                            moreResults = false;
                        }
                    } while (moreResults || rowsAffected != -1);
                }
                catch (SQLException sqle) {
                    this.printAllExceptions(sqle);
                    statement.cancel();
                    statement.clearWarnings();
                    throw sqle;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                if (this.inputQuery != null) break;
            }
            return;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void printDriverInfo() throws SQLException {
        DriverPropertyInfo[] infos;
        System.out.println("driver.getMajorVersion() is " + this.driver.getMajorVersion());
        System.out.println("driver.getMinorVersion() is " + this.driver.getMinorVersion());
        System.out.println("driver is " + (this.driver.jdbcCompliant() ? "" : "not ") + "JDBC compliant");
        for (DriverPropertyInfo info : infos = this.driver.getPropertyInfo(this.connectString, this.props)) {
            System.out.println("driver property named \"" + info.name + "\"");
            if (info.choices != null) {
                System.out.println("choices:");
                for (int j = 0; j < info.choices.length; ++j) {
                    System.out.println("\tchoice " + j + ": \"" + info.choices[j] + "\"");
                }
            }
            System.out.println("description: \"" + info.description + "\"");
            System.out.println("required parameter?: \"" + info.required + "\"");
            System.out.println("current value: \"" + info.value + "\"\n");
        }
        DatabaseMetaData metaData = this.connection.getMetaData();
        System.out.println("metaData.getDatabaseProductName(): \"" + metaData.getDatabaseProductName() + "\"");
        System.out.println("metaData.getDatabaseProductVersion(): \"" + metaData.getDatabaseProductVersion() + "\"");
        System.out.println("metaData.getDriverName(): \"" + metaData.getDriverName() + "\"");
        System.out.println("metaData.getDriverVersion(): \"" + metaData.getDriverVersion() + "\"");
    }

    public void parseArgs(String[] argv) throws Throwable {
        int argumentIndex;
        String passwordValue = null;
        for (argumentIndex = 0; argumentIndex < argv.length; ++argumentIndex) {
            if (!"-p".equalsIgnoreCase(argv[argumentIndex]) && !"-password".equalsIgnoreCase(argv[argumentIndex]) || argv.length <= argumentIndex + 1) continue;
            passwordValue = argv[argumentIndex + 1];
            argv[argumentIndex + 1] = "";
            break;
        }
        for (argumentIndex = 0; argumentIndex < argv.length; ++argumentIndex) {
            if (!argv[argumentIndex].equals("-formatter")) continue;
            this.formatterClassName = argv[argumentIndex + 1];
            break;
        }
        if (this.formatterClassName.compareToIgnoreCase("csv") == 0) {
            this.formatterClassName = csvFormatterClassName;
        } else if (this.formatterClassName.compareToIgnoreCase("xml") == 0) {
            this.formatterClassName = xmlFormatterClassName;
        } else if (this.formatterClassName.compareToIgnoreCase("default") == 0) {
            this.formatterClassName = defaultFormatterClassName;
        }
        this.formatter = (JisqlFormatter)Class.forName(this.formatterClassName).newInstance();
        OptionParser parser = new OptionParser();
        parser.posixlyCorrect(false);
        parser.accepts("c").withRequiredArg().ofType(String.class);
        parser.accepts("cstring").withRequiredArg().ofType(String.class);
        parser.accepts("debug");
        parser.accepts("driver").withRequiredArg().ofType(String.class);
        parser.accepts("driverinfo");
        parser.accepts("formatter").withRequiredArg().ofType(String.class);
        parser.accepts("help");
        parser.accepts("input").withRequiredArg().ofType(String.class);
        parser.accepts("password").withOptionalArg().ofType(String.class);
        parser.accepts("p").withOptionalArg().ofType(String.class);
        parser.accepts("pf").withRequiredArg().ofType(String.class);
        parser.accepts("query").withRequiredArg().ofType(String.class);
        parser.accepts("user").withRequiredArg().ofType(String.class);
        parser.accepts("u").withRequiredArg().ofType(String.class);
        this.formatter.setSupportedOptions(parser);
        OptionSet options = parser.parse(argv);
        if (options.has("help")) {
            this.usage();
            System.exit(1);
        }
        if (options.has("driver")) {
            this.driverName = (String)options.valueOf("driver");
            if (this.driverName.compareToIgnoreCase("jconnect4") == 0) {
                this.driverName = sybaseJConnect4DriverName;
            } else if (this.driverName.compareToIgnoreCase("jconnect5") == 0) {
                this.driverName = sybaseJConnect5DriverName;
            } else if (this.driverName.compareToIgnoreCase("jconnect6") == 0) {
                this.driverName = sybaseJConnect6DriverName;
            } else if (this.driverName.compareToIgnoreCase("oraclethin") == 0) {
                this.driverName = oracleThinDriverName;
            } else if (this.driverName.compareToIgnoreCase("db2app") == 0) {
                this.driverName = db2AppDriverName;
            } else if (this.driverName.compareToIgnoreCase("db2net") == 0) {
                this.driverName = db2NetDriverName;
            } else if (this.driverName.compareToIgnoreCase("cloudscape") == 0) {
                this.driverName = cloudscapeDriverName;
            } else if (this.driverName.compareToIgnoreCase("mssql") == 0) {
                this.driverName = msqlDriverName;
            } else if (this.driverName.compareToIgnoreCase("pointbase") == 0) {
                this.driverName = pointbaseDriverName;
            } else if (this.driverName.compareToIgnoreCase("postgresql") == 0) {
                this.driverName = postgresqlDriverName;
            } else if (this.driverName.compareToIgnoreCase("mysqlconj") == 0) {
                this.driverName = mySQLConnectJDriverName;
            } else if (this.driverName.compareToIgnoreCase("mysqlcaucho") == 0) {
                this.driverName = mySQLCauchoDriverName;
            } else if (this.driverName.compareToIgnoreCase("sapsajdbc4") == 0) {
                this.driverName = sapJDBC4SqlAnywhereDriverName;
            } else if (this.driverName.compareToIgnoreCase("sybasesajdbc4") == 0) {
                this.driverName = sybaseJDBC4SqlAnywhereDriverName;
            }
        }
        this.connectString = (String)options.valueOf("cstring");
        if (options.has("c")) {
            this.commandTerminator = (String)options.valueOf("c");
        }
        if (options.has("debug")) {
            this.printDebug = true;
        }
        if (options.has("user")) {
            this.userName = (String)options.valueOf("user");
        } else if (options.has("u")) {
            this.userName = (String)options.valueOf("u");
        }
        this.password = passwordValue;
        if (options.has("driverinfo")) {
            this.printDriverDetails = true;
        }
        if (options.has("input")) {
            this.inputFileName = (String)options.valueOf("input");
        }
        if (options.has("pf")) {
            this.passwordFileName = (String)options.valueOf("pf");
        }
        if (options.has("query")) {
            this.inputQuery = (String)options.valueOf("query");
        }
        if (this.driverName == null) {
            throw new Exception("driver name must exist");
        }
        if (this.connectString == null) {
            throw new Exception("connect string must exist");
        }
        if (this.userName == null) {
            throw new Exception("user name must exist");
        }
        if (this.password == null && this.passwordFileName == null) {
            this.password = "";
        } else if (this.password == null) {
            File passwordFile = new File(this.passwordFileName);
            if (!passwordFile.exists()) {
                throw new Exception("the password file \"" + this.passwordFileName + "\" does not exist");
            }
            if (!passwordFile.isFile()) {
                throw new Exception("the password file \"" + this.passwordFileName + "\" is not a normal file");
            }
            if (!passwordFile.canRead()) {
                throw new Exception("the password file \"" + this.passwordFileName + "\" is not readable");
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(passwordFile));){
                this.password = reader.readLine().trim();
            }
            catch (Exception e) {
                throw new Exception("An error occured reading the password file", e);
            }
        }
        this.formatter.consumeOptions(options);
    }

    private void printAllExceptions(SQLException sqle) {
        while (sqle != null) {
            System.err.println("SQLException : SQL state: " + sqle.getSQLState() + " " + sqle + " ErrorCode: " + sqle.getErrorCode());
            sqle = sqle.getNextException();
        }
    }

    private void usage() {
        System.err.println();
        System.err.println("usage: java " + this.getClass().getName() + " -driver driver -cstring connect_string -user|-u username -password|-p password [-pf password_file] [-c command_term] [-input file_name] [-debug] [-driverinfo] [-formatter formatter]");
        System.err.println("where:");
        System.err.println("\t-driver specifies the JDBC driver to use.  There are several builtin shortcuts - see the docs for details.");
        System.err.println("\t-cstring specifies the connection string to use.  These are driver specific.");
        System.err.println("\t-user specifies a user name to log into a database server with.");
        System.err.println("\t-password specifies the user name to log into a database server with.");
        System.err.println("\t-pf specifies the name of a file that contains the password to log into a database server with.");
        System.err.println("\t The first line of file should contain the password and nothing else.");
        System.err.println("\t-c specifies the command terminator.  The default is \"" + this.commandTerminator + "\"");
        System.err.println("\t-input specifies a file name to read commands from.");
        System.err.println("\t-query specifies an optional single query to run instead of interacting with the command line or a file.");
        System.err.println("\t Note that the command must include a command terminator or the command will hang");
        System.err.println("\t-debug prints to stdout (System.out) debugging information");
        System.err.println("\t-driverinfo prints to stdout (System.out) detailed driver information and then exits");
        System.err.println("\t-formatter specifies either a class name or a pre-configured output formatter.  See the docs for details.");
        if (this.formatter != null) {
            System.err.println("Additional command line arguments of the " + this.formatter.getClass().getName() + " class are");
            this.formatter.usage(System.err);
        }
        System.err.println();
    }
}

