/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util.outputformatter;

import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.util.outputformatter.JisqlFormatter;

public class CSVFormatter
implements JisqlFormatter {
    private char delimiter = (char)44;
    private boolean includeColumnNames;

    @Override
    public void setSupportedOptions(OptionParser parser) {
        parser.accepts("delimiter").withRequiredArg().ofType(String.class);
        parser.accepts("colnames");
    }

    @Override
    public void consumeOptions(OptionSet options) {
        if (options.has("delimiter")) {
            this.delimiter = ((String)options.valueOf("delimiter")).charAt(0);
        }
        if (options.has("colnames")) {
            this.includeColumnNames = true;
        }
    }

    @Override
    public void usage(PrintStream out) {
        out.println("\t-delimiter specifies the character to use as the delimiter.  This defaults to \"" + this.delimiter + "\"");
        out.println("\t-colnames outputs column names.  By default there are no column names.");
    }

    @Override
    public void formatHeader(PrintStream out, ResultSetMetaData metaData) throws Exception {
        if (this.includeColumnNames) {
            int numColumns = metaData.getColumnCount();
            for (int i = 1; i <= numColumns; ++i) {
                out.print(metaData.getColumnName(i).trim());
                if (i + 1 > numColumns) continue;
                out.print(this.delimiter);
            }
            out.println();
        }
    }

    @Override
    public void formatData(PrintStream out, ResultSet resultSet, ResultSetMetaData metaData) {
    }

    @Override
    public void formatFooter(PrintStream out, ResultSetMetaData metaData) {
    }
}

