/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.server.tomcat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.server.tomcat.EmbeddedServerUtil;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.SolrZooKeeper;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;

public class SolrCollectionBootstrapper
extends Thread {
    private static final Logger logger = Logger.getLogger(SolrCollectionBootstrapper.class.getName());
    public static final String DEFAULT_COLLECTION_NAME = "ranger_audits";
    public static final String DEFAULT_CONFIG_NAME = "ranger_audits";
    public static final long DEFAULT_SOLR_TIME_INTERVAL_MS = 60000L;
    public static final int DEFAULT_VALUE = 1;
    public static final int DEFAULT_SOLR_BOOTSTRP_MAX_RETRY = -1;
    static final String SOLR_ZK_HOSTS = "ranger.audit.solr.zookeepers";
    static final String SOLR_COLLECTION_NAME_KEY = "ranger.audit.solr.collection.name";
    static final String SOLR_CONFIG_NAME_KEY = "ranger.audit.solr.config.name";
    static final String CONFIG_SET_LOCATION = "ranger.audit.solr.configset.location";
    static final String SOLR_NO_SHARDS = "ranger.audit.solr.no.shards";
    static final String SOLR_MAX_SHARD_PER_NODE = "ranger.audit.solr.max.shards.per.node";
    static final String SOLR_NO_REPLICA = "ranger.audit.solr.no.replica";
    static final String SOLR_TIME_INTERVAL = "ranger.audit.solr.time.interval";
    static final String SOLR_BOOTSTRP_MAX_RETRY = "ranger.audit.solr.max.retry";
    static final String PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    private static final String AUTH_TYPE_KERBEROS = "kerberos";
    private static final String AUTHENTICATION_TYPE = "hadoop.security.authentication";
    private static final String RANGER_SERVICE_HOSTNAME = "ranger.service.host";
    private static final String ADMIN_USER_PRINCIPAL = "ranger.admin.kerberos.principal";
    private static final String SSL_ENABLED_PARAM = "ranger.service.https.attrib.ssl.enabled";
    private static final int TRY_UNTIL_SUCCESS = -1;
    private final String customConfigSetLocation;
    private final File configSetFolder;
    private final boolean isSSLEnabled;
    boolean solrCloudMode;
    boolean isCompleted;
    boolean isKERBEROS;
    String principal;
    String hostName;
    String keytab;
    String nameRules;
    String solrCollectionName;
    String solrConfigName;
    Path pathForCloudMode;
    int noOfReplicas;
    int maxNodePerShards;
    int maxRetry;
    int retryCounter;
    Long timeInterval;
    SolrClient solrClient;
    CloudSolrClient solrCloudClient;
    SolrZooKeeper solrZookeeper;
    SolrZkClient zkClient;

    public SolrCollectionBootstrapper() throws IOException {
        logger.info("Starting Solr Setup");
        logger.info("AUTHENTICATION_TYPE : " + EmbeddedServerUtil.getConfig(AUTHENTICATION_TYPE));
        if (EmbeddedServerUtil.getConfig(AUTHENTICATION_TYPE) != null && EmbeddedServerUtil.getConfig(AUTHENTICATION_TYPE).trim().equalsIgnoreCase(AUTH_TYPE_KERBEROS)) {
            this.isKERBEROS = true;
            this.hostName = EmbeddedServerUtil.getConfig(RANGER_SERVICE_HOSTNAME);
            try {
                this.principal = SecureClientLogin.getPrincipal((String)EmbeddedServerUtil.getConfig(ADMIN_USER_PRINCIPAL), (String)this.hostName);
            }
            catch (IOException ignored) {
                logger.warning("Failed to get ranger.admin.kerberos.principal. Reason: " + ignored);
            }
        }
        this.solrCollectionName = EmbeddedServerUtil.getConfig(SOLR_COLLECTION_NAME_KEY, "ranger_audits");
        logger.info("Solr Collection name provided is : " + this.solrCollectionName);
        this.solrConfigName = EmbeddedServerUtil.getConfig(SOLR_CONFIG_NAME_KEY, "ranger_audits");
        logger.info("Solr Config name provided is : " + this.solrConfigName);
        this.noOfReplicas = EmbeddedServerUtil.getIntConfig(SOLR_NO_REPLICA, 1);
        logger.info("No. of replicas provided is : " + this.noOfReplicas);
        this.maxNodePerShards = EmbeddedServerUtil.getIntConfig(SOLR_MAX_SHARD_PER_NODE, 1);
        logger.info("Max no of nodes per shards provided is : " + this.maxNodePerShards);
        this.timeInterval = EmbeddedServerUtil.getLongConfig(SOLR_TIME_INTERVAL, 60000L);
        logger.info("Solr time interval provided is : " + this.timeInterval);
        this.maxRetry = EmbeddedServerUtil.getIntConfig(SOLR_BOOTSTRP_MAX_RETRY, -1);
        if (System.getProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG) == null) {
            System.setProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG, "/dev/null");
        }
        String basedir = new File(".").getCanonicalPath();
        String solrFileDir = new File(basedir).getParent();
        this.customConfigSetLocation = EmbeddedServerUtil.getConfig(CONFIG_SET_LOCATION);
        logger.info("Provided custom configSet location : " + this.customConfigSetLocation);
        if (StringUtils.isNotEmpty((String)this.customConfigSetLocation)) {
            this.configSetFolder = new File(this.customConfigSetLocation);
        } else {
            this.pathForCloudMode = Paths.get(solrFileDir, "contrib", "solr_for_audit_setup", "conf");
            this.configSetFolder = this.pathForCloudMode.toFile();
        }
        String sslEnabledProp = EmbeddedServerUtil.getConfig(SSL_ENABLED_PARAM);
        this.isSSLEnabled = "true".equalsIgnoreCase(sslEnabledProp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map postDataAndGetResponse(CloudSolrClient cloudClient, String uri, ByteBuffer bytarr) throws IOException {
        HttpPost httpPost = null;
        String response = null;
        Map m = null;
        try {
            httpPost = new HttpPost(uri);
            httpPost.setHeader("Content-Type", "application/octet-stream");
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(bytarr.array(), bytarr.arrayOffset(), bytarr.limit()));
            HttpEntity entity = cloudClient.getLbClient().getHttpClient().execute((HttpUriRequest)httpPost).getEntity();
            try {
                response = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                m = (Map)ObjectBuilder.getVal((JSONParser)new JSONParser((Reader)new StringReader(response)));
            }
            catch (JSONParser.ParseException e) {
                logger.severe("Error response: " + response);
            }
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
        return m;
    }

    @Override
    public void run() {
        logger.info("Started run method");
        List<String> zookeeperHosts = SolrCollectionBootstrapper.getZkHosts();
        if (zookeeperHosts != null && !zookeeperHosts.isEmpty() && zookeeperHosts.stream().noneMatch(h -> h.equalsIgnoreCase("none"))) {
            logger.info("Solr zkHosts=" + zookeeperHosts + ", collectionName=" + this.solrCollectionName);
            while (!(this.isCompleted || this.maxRetry != -1 && this.retryCounter >= this.maxRetry)) {
                block9: {
                    try {
                        if (this.connect(zookeeperHosts)) {
                            if (!this.solrCloudMode) break block9;
                            if (this.uploadConfiguration() && this.createCollection()) {
                                this.isCompleted = true;
                                break;
                            }
                            this.logErrorMessageAndWait("Error while performing operations on solr. ", null);
                            break block9;
                        }
                        this.logErrorMessageAndWait("Cannot connect to solr kindly check the solr related configs. ", null);
                    }
                    catch (Exception ex) {
                        this.logErrorMessageAndWait("Error while configuring solr. ", ex);
                    }
                }
                try {
                    if (this.solrCloudClient == null) continue;
                    this.solrCloudClient.close();
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Error while closing the solr client. ", ex);
                }
            }
        } else {
            logger.severe("Solr ZKHosts for Audit are empty. Please set property ranger.audit.solr.zookeepers");
        }
    }

    private boolean connect(List<String> zookeeperHosts) {
        try {
            logger.info("Solr is in Cloud mode");
            if (this.isKERBEROS) {
                this.setHttpClientBuilderForKrb();
            }
            this.solrCloudClient = new CloudSolrClient.Builder(zookeeperHosts, Optional.empty()).build();
            this.solrCloudClient.setDefaultCollection(this.solrCollectionName);
            this.solrCloudClient.connect();
            this.zkClient = this.solrCloudClient.getZkStateReader().getZkClient();
            this.solrClient = this.solrCloudClient;
            this.solrCloudMode = true;
            return true;
        }
        catch (Exception ex) {
            logger.severe("Can't connect to Solr server. ZooKeepers=" + zookeeperHosts + ", collection=" + this.solrCollectionName + ex);
            return false;
        }
    }

    private void setHttpClientBuilderForKrb() {
        try (Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();){
            SolrHttpClientBuilder kb = krbBuild.getBuilder();
            HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)kb);
        }
    }

    private boolean uploadConfiguration() {
        try {
            if (this.zkClient != null) {
                ZkConfigManager zkConfigManager = new ZkConfigManager(this.zkClient);
                boolean configExists = zkConfigManager.configExists(this.solrConfigName);
                if (!configExists) {
                    try {
                        logger.info("Config does not exist with name " + this.solrConfigName);
                        String zipOfConfigs = null;
                        if (this.configSetFolder.exists() && this.configSetFolder.isFile()) {
                            zipOfConfigs = this.configSetFolder.getAbsolutePath();
                        } else {
                            String[] files = this.configSetFolder.list();
                            if (files != null) {
                                for (String aFile : files) {
                                    if (aFile == null || !aFile.equals("solr_audit_conf.zip")) continue;
                                    zipOfConfigs = this.configSetFolder + "/" + aFile;
                                    break;
                                }
                            }
                        }
                        if (zipOfConfigs == null) {
                            throw new FileNotFoundException("Could Not Find Configs Zip File : " + this.getConfigSetFolder());
                        }
                        File file = new File(zipOfConfigs);
                        byte[] arrByte = Files.readAllBytes(file.toPath());
                        ByteBuffer byteBuffer = ByteBuffer.wrap(arrByte);
                        String baseUrl = this.getBaseUrl();
                        String protocol = this.isSSLEnabled ? "https" : "http";
                        String uploadConfigsUrl = String.format("%s://%s/admin/configs?action=UPLOAD&name=%s", protocol, baseUrl, this.solrConfigName);
                        SolrCollectionBootstrapper.postDataAndGetResponse(this.solrCloudClient, uploadConfigsUrl, byteBuffer);
                        return true;
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Error while uploading configs : ", ex);
                        return false;
                    }
                }
                logger.info("Config already exists with name " + this.solrConfigName);
                return true;
            }
            logger.severe("Solr is in cloud mode and could not find the zookeeper client for performing upload operations. ");
            return false;
        }
        catch (Exception ex) {
            logger.severe("Error while uploading configuration : " + ex);
            return false;
        }
    }

    private void logErrorMessageAndWait(String msg, Exception exception) {
        ++this.retryCounter;
        String attempMessage = this.maxRetry != -1 ? (this.retryCounter == this.maxRetry ? "Maximum attempts reached for setting up Solr." : "[retrying after " + this.timeInterval + " ms]. No. of attempts left : " + (this.maxRetry - this.retryCounter) + " . Maximum attempts : " + this.maxRetry) : "[retrying after " + this.timeInterval + " ms]";
        StringBuilder errorBuilder = new StringBuilder(msg);
        if (exception != null) {
            errorBuilder.append("Error : ".concat(exception.getMessage() + ". "));
        }
        errorBuilder.append(attempMessage);
        logger.severe(errorBuilder.toString());
        try {
            Thread.sleep(this.timeInterval);
        }
        catch (InterruptedException ex) {
            logger.info("sleep interrupted: " + ex.getMessage());
        }
    }

    private boolean createCollection() {
        try {
            List<String> allCollectionList = this.getCollections();
            if (allCollectionList != null) {
                if (!allCollectionList.contains(this.solrCollectionName)) {
                    int shardsCalculation = this.solrCloudClient != null ? this.solrCloudClient.getClusterStateProvider().getLiveNodes().size() : 1;
                    int noOfShards = EmbeddedServerUtil.getIntConfig(SOLR_NO_SHARDS, shardsCalculation);
                    logger.info("No. of shards provided is : " + noOfShards);
                    CollectionAdminRequest.Create createCollection = CollectionAdminRequest.createCollection((String)this.solrCollectionName, (String)this.solrConfigName, (int)noOfShards, (int)this.noOfReplicas);
                    createCollection.setMaxShardsPerNode(Integer.valueOf(this.maxNodePerShards));
                    CollectionAdminResponse createResponse = (CollectionAdminResponse)createCollection.process(this.solrClient);
                    if (createResponse.getStatus() != 0) {
                        logger.severe("Error creating collection. collectionName=" + this.solrCollectionName + " , solr config name = " + this.solrConfigName + " , replicas = " + this.noOfReplicas + ", shards=" + noOfShards + " , max node per shards = " + this.maxNodePerShards + ", response=" + createResponse);
                        return false;
                    }
                    allCollectionList = this.getCollections();
                    if (allCollectionList != null) {
                        if (allCollectionList.contains(this.solrCollectionName)) {
                            logger.info("Created collection " + this.solrCollectionName + " with config name " + this.solrConfigName + " replicas =  " + this.noOfReplicas + " Shards = " + noOfShards + " max node per shards  = " + this.maxNodePerShards);
                            return true;
                        }
                        logger.severe("Collection does not exist. collectionName=" + this.solrCollectionName + " , solr config name = " + this.solrConfigName + " , replicas = " + this.noOfReplicas + ", shards=" + noOfShards + " , max node per shards = " + this.maxNodePerShards + ", response=" + createResponse);
                        return false;
                    }
                    logger.severe("Error while getting collection list after creating collection");
                    return false;
                }
                logger.info("Collection already exists with name " + this.solrCollectionName);
                return true;
            }
            logger.severe("Error while connecting to solr ");
            return false;
        }
        catch (Exception ex) {
            logger.severe("Error while creating collection in solr : " + ex);
            return false;
        }
    }

    private List<String> getCollections() throws IOException {
        try {
            CollectionAdminRequest.List colListReq = new CollectionAdminRequest.List();
            CollectionAdminResponse response = (CollectionAdminResponse)colListReq.process(this.solrClient);
            if (response.getStatus() != 0) {
                logger.severe("Error getting collection list from solr.  response=" + response);
                return null;
            }
            return (List)response.getResponse().get("collections");
        }
        catch (SolrServerException | SolrException e) {
            logger.severe("getCollections() operation failed : " + e);
            return null;
        }
    }

    private File getConfigSetFolder() {
        return this.configSetFolder;
    }

    private static List<String> getZkHosts() {
        ArrayList<String> zookeeperHosts = null;
        if (!StringUtil.isEmpty((String)EmbeddedServerUtil.getConfig(SOLR_ZK_HOSTS))) {
            String zkHosts = EmbeddedServerUtil.getConfig(SOLR_ZK_HOSTS).trim();
            zookeeperHosts = new ArrayList<String>(Arrays.asList(zkHosts.split(",")));
        }
        return zookeeperHosts;
    }

    private String getBaseUrl() throws Exception {
        Set nodes = this.solrCloudClient.getClusterStateProvider().getLiveNodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            throw new Exception("No live SolrServers available");
        }
        String[] nodeArr = nodes.toArray(new String[0]);
        return nodeArr[0].replaceAll("_", "/");
    }
}

