/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.server.tomcat;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.ranger.authorization.credutils.CredentialsProviderUtil;
import org.apache.ranger.authorization.credutils.kerberos.KerberosCredentialsProvider;
import org.apache.ranger.credentialapi.CredentialReader;
import org.apache.ranger.server.tomcat.EmbeddedServerUtil;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;

public class ElasticSearchIndexBootStrapper
extends Thread {
    private static final Logger LOG = Logger.getLogger(ElasticSearchIndexBootStrapper.class.getName());
    private static final String ES_CONFIG_USERNAME = "ranger.audit.elasticsearch.user";
    private static final String ES_CONFIG_PASSWORD = "ranger.audit.elasticsearch.password";
    private static final String ES_CONFIG_URLS = "ranger.audit.elasticsearch.urls";
    private static final String ES_CONFIG_PORT = "ranger.audit.elasticsearch.port";
    private static final String ES_CONFIG_PROTOCOL = "ranger.audit.elasticsearch.protocol";
    private static final String ES_CONFIG_INDEX = "ranger.audit.elasticsearch.index";
    private static final String ES_TIME_INTERVAL = "ranger.audit.elasticsearch.time.interval";
    private static final String ES_NO_SHARDS = "ranger.audit.elasticsearch.no.shards";
    private static final String ES_NO_REPLICA = "ranger.audit.elasticsearch.no.replica";
    private static final String ES_CREDENTIAL_PROVIDER_PATH = "ranger.credential.provider.path";
    private static final String ES_CREDENTIAL_ALIAS = "ranger.audit.elasticsearch.credential.alias";
    private static final String ES_BOOTSTRAP_MAX_RETRY = "ranger.audit.elasticsearch.max.retry";
    private static final String DEFAULT_INDEX_NAME = "ranger_audits";
    private static final String ES_RANGER_AUDIT_SCHEMA_FILE = "ranger_es_schema.json";
    private static final long DEFAULT_ES_TIME_INTERVAL_MS = 60000L;
    private static final int TRY_UNTIL_SUCCESS = -1;
    private static final int DEFAULT_ES_BOOTSTRAP_MAX_RETRY = 30;
    private volatile RestHighLevelClient client;
    private final AtomicLong lastLoggedAt = new AtomicLong(0L);
    private final Long timeInterval;
    private final String user;
    private String password;
    private final String hosts;
    private final String protocol;
    private final String index;
    private final String esRangerAuditSchemaJson;
    private final int port;
    private final int maxRetry;
    private int retryCounter;
    private final int noOfReplicas;
    private final int noOfShards;
    private boolean isCompleted;

    public ElasticSearchIndexBootStrapper() throws IOException {
        LOG.info("Starting Ranger audit schema setup in ElasticSearch.");
        this.timeInterval = EmbeddedServerUtil.getLongConfig(ES_TIME_INTERVAL, 60000L);
        this.user = EmbeddedServerUtil.getConfig(ES_CONFIG_USERNAME);
        this.hosts = EmbeddedServerUtil.getHosts(EmbeddedServerUtil.getConfig(ES_CONFIG_URLS));
        this.port = EmbeddedServerUtil.getIntConfig(ES_CONFIG_PORT, 9200);
        this.protocol = EmbeddedServerUtil.getConfig(ES_CONFIG_PROTOCOL, "http");
        this.index = EmbeddedServerUtil.getConfig(ES_CONFIG_INDEX, DEFAULT_INDEX_NAME);
        this.password = EmbeddedServerUtil.getConfig(ES_CONFIG_PASSWORD);
        this.noOfReplicas = EmbeddedServerUtil.getIntConfig(ES_NO_REPLICA, 1);
        this.noOfShards = EmbeddedServerUtil.getIntConfig(ES_NO_SHARDS, 1);
        this.maxRetry = EmbeddedServerUtil.getIntConfig(ES_BOOTSTRAP_MAX_RETRY, 30);
        String jarLocation = null;
        try {
            jarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (Exception ex) {
            LOG.severe("Error finding base location:" + ex);
        }
        String rangerHomeDir = new File(jarLocation).getParentFile().getParentFile().getParentFile().getPath();
        Path esSchemaPath = Paths.get(rangerHomeDir, "contrib", "elasticsearch_for_audit_setup", "conf", ES_RANGER_AUDIT_SCHEMA_FILE);
        this.esRangerAuditSchemaJson = new String(Files.readAllBytes(esSchemaPath), StandardCharsets.UTF_8);
        String providerPath = EmbeddedServerUtil.getConfig(ES_CREDENTIAL_PROVIDER_PATH);
        String credentialAlias = EmbeddedServerUtil.getConfig(ES_CREDENTIAL_ALIAS, ES_CONFIG_PASSWORD);
        String keyStoreFileType = EmbeddedServerUtil.getConfig("ranger.keystore.file.type", KeyStore.getDefaultType());
        if (providerPath != null && credentialAlias != null) {
            this.password = CredentialReader.getDecryptedString((String)providerPath.trim(), (String)credentialAlias.trim(), (String)keyStoreFileType);
            if (StringUtils.isBlank((String)this.password) || "none".equalsIgnoreCase(this.password.trim())) {
                this.password = EmbeddedServerUtil.getConfig(ES_CONFIG_PASSWORD);
            }
        }
    }

    public static RestClientBuilder getRestClientBuilder(String urls, String protocol, String user, String password, int port) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])((HttpHost[])EmbeddedServerUtil.toArray(urls, ",").stream().map(x -> new HttpHost(x, port, protocol)).toArray(HttpHost[]::new)));
        if (StringUtils.isNotBlank((String)user) && StringUtils.isNotBlank((String)password) && !user.equalsIgnoreCase("NONE") && !password.equalsIgnoreCase("NONE")) {
            if (password.contains("keytab") && new File(password).exists()) {
                KerberosCredentialsProvider credentialsProvider = CredentialsProviderUtil.getKerberosCredentials((String)user, (String)password);
                Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory()).build();
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticSearchIndexBootStrapper.lambda$getRestClientBuilder$2(credentialsProvider, (Lookup)authSchemeRegistry, arg_0));
            } else {
                CredentialsProvider credentialsProvider = CredentialsProviderUtil.getBasicCredentials((String)user, (String)password);
                restClientBuilder.setHttpClientConfigCallback(clientBuilder -> clientBuilder.setDefaultCredentialsProvider(credentialsProvider));
            }
        } else {
            LOG.severe("ElasticSearch Credentials not provided!!");
            CredentialsProvider credentialsProvider = null;
            restClientBuilder.setHttpClientConfigCallback(clientBuilder -> clientBuilder.setDefaultCredentialsProvider(credentialsProvider));
        }
        return restClientBuilder;
    }

    @Override
    public void run() {
        LOG.info("Started run method");
        if (StringUtils.isNotBlank((String)this.hosts)) {
            LOG.info("Elastic search hosts=" + this.hosts + ", index=" + this.index);
            while (!(this.isCompleted || this.maxRetry != -1 && this.retryCounter >= this.maxRetry)) {
                try {
                    LOG.info("Trying to acquire elastic search connection");
                    if (this.connect()) {
                        LOG.info("Connection to elastic search established successfully");
                        if (this.createIndex()) {
                            this.isCompleted = true;
                            break;
                        }
                        this.logErrorMessageAndWait("Error while performing operations on elasticsearch. ", null);
                        continue;
                    }
                    this.logErrorMessageAndWait("Cannot connect to elasticsearch kindly check the elasticsearch related configs. ", null);
                }
                catch (Exception ex) {
                    this.logErrorMessageAndWait("Error while validating elasticsearch index ", ex);
                }
            }
        } else {
            LOG.severe("elasticsearch hosts values are empty. Please set property ranger.audit.elasticsearch.urls");
        }
    }

    private String connectionString() {
        return String.format(Locale.ROOT, "User:%s, %s://%s:%s/%s", this.user, this.protocol, this.hosts, this.port, this.index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized boolean connect() {
        RestHighLevelClient me = this.client;
        if (me == null) {
            Class<ElasticSearchIndexBootStrapper> clazz = ElasticSearchIndexBootStrapper.class;
            // MONITORENTER : org.apache.ranger.server.tomcat.ElasticSearchIndexBootStrapper.class
            me = this.client;
            if (me == null) {
                try {
                    this.createClient();
                    me = this.client;
                }
                catch (Exception ex) {
                    LOG.severe("Can't connect to elasticsearch server. host=" + this.hosts + ", index=" + this.index + ex);
                }
            }
            // MONITOREXIT : clazz
        }
        if (me == null) return false;
        return true;
    }

    private void createClient() {
        try {
            RestClientBuilder restClientBuilder = ElasticSearchIndexBootStrapper.getRestClientBuilder(this.hosts, this.protocol, this.user, this.password, this.port);
            this.client = new RestHighLevelClient(restClientBuilder);
        }
        catch (Throwable t) {
            this.lastLoggedAt.updateAndGet(lastLoggedAt -> {
                long now = System.currentTimeMillis();
                long elapsed = now - lastLoggedAt;
                if (elapsed > TimeUnit.MINUTES.toMillis(1L)) {
                    LOG.severe("Can't connect to ElasticSearch server: " + this.connectionString() + t);
                    return now;
                }
                return lastLoggedAt;
            });
        }
    }

    private boolean createIndex() {
        boolean exits = false;
        if (this.client == null) {
            this.connect();
        }
        if (this.client != null) {
            try {
                exits = this.client.indices().open(new OpenIndexRequest(new String[]{this.index}), RequestOptions.DEFAULT).isShardsAcknowledged();
            }
            catch (Exception e) {
                LOG.info("Index " + this.index + " not available.");
            }
            if (!exits) {
                LOG.info("Index does not exist. Attempting to create index:" + this.index);
                CreateIndexRequest request = new CreateIndexRequest(this.index);
                if (this.noOfShards >= 0 && this.noOfReplicas >= 0) {
                    request.settings(Settings.builder().put("index.number_of_shards", this.noOfShards).put("index.number_of_replicas", this.noOfShards));
                }
                request.mapping(this.esRangerAuditSchemaJson, XContentType.JSON);
                request.setMasterTimeout(TimeValue.timeValueMinutes((long)1L));
                request.setTimeout(TimeValue.timeValueMinutes((long)2L));
                try {
                    CreateIndexResponse createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
                    if (createIndexResponse != null && (exits = this.client.indices().open(new OpenIndexRequest(new String[]{this.index}), RequestOptions.DEFAULT).isShardsAcknowledged())) {
                        LOG.info("Index " + this.index + " created successfully.");
                    }
                }
                catch (Exception e) {
                    LOG.severe("Unable to create Index. Reason:" + e);
                    e.printStackTrace();
                }
            } else {
                LOG.info("Index " + this.index + " is already created.");
            }
        }
        return exits;
    }

    private void logErrorMessageAndWait(String msg, Exception exception) {
        ++this.retryCounter;
        String attemptMessage = this.maxRetry != -1 ? (this.retryCounter == this.maxRetry ? "Maximum attempts reached for setting up elasticsearch." : "[retrying after " + this.timeInterval + " ms]. No. of attempts left : " + (this.maxRetry - this.retryCounter) + " . Maximum attempts : " + this.maxRetry) : "[retrying after " + this.timeInterval + " ms]";
        StringBuilder errorBuilder = new StringBuilder(msg);
        if (exception != null) {
            errorBuilder.append("Error : ".concat(exception.getMessage() + ". "));
        }
        errorBuilder.append(attemptMessage);
        LOG.severe(errorBuilder.toString());
        try {
            Thread.sleep(this.timeInterval);
        }
        catch (InterruptedException ex) {
            LOG.info("sleep interrupted: " + ex.getMessage());
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$getRestClientBuilder$2(KerberosCredentialsProvider credentialsProvider, Lookup authSchemeRegistry, HttpAsyncClientBuilder clientBuilder) {
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        clientBuilder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
        return clientBuilder;
    }
}

