/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSampleProjectProvider
extends RangerAbstractContextEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSampleProjectProvider.class);
    private String contextName = "PROJECT";
    private Properties userProjectMap;

    public void init() {
        LOG.debug("==> RangerSampleProjectProvider.init({})", (Object)this.enricherDef);
        super.init();
        this.contextName = this.getOption("contextName", "PROJECT");
        String dataFile = this.getOption("dataFile", "/etc/ranger/data/userProject.txt");
        this.userProjectMap = this.readProperties(dataFile);
        LOG.debug("<== RangerSampleProjectProvider.init({})", (Object)this.enricherDef);
    }

    public void enrich(RangerAccessRequest request) {
        LOG.debug("==> RangerSampleProjectProvider.enrich({})", (Object)request);
        if (request != null && this.userProjectMap != null && request.getUser() != null) {
            Map context = request.getContext();
            String project = this.userProjectMap.getProperty(request.getUser());
            if (context != null && !StringUtils.isEmpty((String)project)) {
                request.getContext().put(this.contextName, project);
            } else {
                LOG.debug("RangerSampleProjectProvider.enrich(): skipping due to unavailable context or project. context={}; project={}", (Object)context, (Object)project);
            }
        }
        LOG.debug("<== RangerSampleProjectProvider.enrich({})", (Object)request);
    }
}

