/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSampleSimpleMatcher
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSampleSimpleMatcher.class);
    public static final String CONTEXT_NAME = "CONTEXT_NAME";
    private boolean allowAny;
    private String contextName;
    private final List<String> values = new ArrayList<String>();

    public void init() {
        LOG.debug("==> RangerSampleSimpleMatcher.init({})", (Object)this.condition);
        super.init();
        if (this.condition == null) {
            LOG.debug("init: null policy condition! Will match always!");
            this.allowAny = true;
        } else if (this.conditionDef == null) {
            LOG.debug("init: null policy condition definition! Will match always!");
            this.allowAny = true;
        } else if (CollectionUtils.isEmpty((Collection)this.condition.getValues())) {
            LOG.debug("init: empty conditions collection on policy condition!  Will match always!");
            this.allowAny = true;
        } else if (MapUtils.isEmpty((Map)this.conditionDef.getEvaluatorOptions())) {
            LOG.debug("init: Evaluator options were empty.  Can't determine what value to use from context.  Will match always.");
            this.allowAny = true;
        } else if (StringUtils.isEmpty((String)((String)this.conditionDef.getEvaluatorOptions().get(CONTEXT_NAME)))) {
            LOG.debug("init: CONTEXT_NAME is not specified in evaluator options.  Can't determine what value to use from context.  Will match always.");
            this.allowAny = true;
        } else {
            this.contextName = (String)this.conditionDef.getEvaluatorOptions().get(CONTEXT_NAME);
            this.values.addAll(this.condition.getValues());
        }
        LOG.debug("<== RangerSampleSimpleMatcher.init({}): values[{}]", (Object)this.condition, this.values);
    }

    public boolean isMatched(RangerAccessRequest request) {
        LOG.debug("==> RangerSampleSimpleMatcher.isMatched({})", (Object)request);
        boolean matched = false;
        if (this.allowAny) {
            matched = true;
        } else {
            String requestValue = this.extractValue(request, this.contextName);
            if (StringUtils.isNotBlank((String)requestValue)) {
                for (String policyValue : this.values) {
                    if (!FilenameUtils.wildcardMatch((String)requestValue, (String)policyValue)) continue;
                    matched = true;
                    break;
                }
            }
        }
        LOG.debug("<== RangerSampleSimpleMatcher.isMatched({}): {}", (Object)request, (Object)matched);
        return matched;
    }

    String extractValue(RangerAccessRequest request, String key) {
        LOG.debug("==> RangerSampleSimpleMatcher.extractValue({})", (Object)request);
        String value = null;
        if (request == null) {
            LOG.debug("isMatched: Unexpected: null request.  Returning null!");
        } else if (request.getContext() == null) {
            LOG.debug("isMatched: Context map of request is null.  Ok. Returning null!");
        } else if (CollectionUtils.isEmpty(request.getContext().entrySet())) {
            LOG.debug("isMatched: Missing context on request.  Ok. Condition isn't applicable.  Returning null!");
        } else if (!request.getContext().containsKey(key)) {
            LOG.debug("isMatched: Unexpected: Context did not have data for condition[{}]. Returning null!", (Object)key);
        } else {
            value = (String)request.getContext().get(key);
        }
        LOG.debug("<== RangerSampleSimpleMatcher.extractValue({}): {}", (Object)request, value);
        return value;
    }
}

