/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.net.DNS;
import org.apache.phoenix.compat.HiveCompatUtil;
import org.apache.phoenix.hive.PrimaryKeyData;
import org.apache.phoenix.hive.ql.index.IndexSearchCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PhoenixStorageHandlerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixStorageHandlerUtil.class);
    protected static final AtomicReference<Method> GET_BUCKET_METHOD_REF = new AtomicReference();
    protected static final AtomicReference<Method> GET_BUCKET_ID_METHOD_REF = new AtomicReference();
    private static final Map<InetAddress, String> reverseDNSCacheMap = new ConcurrentHashMap<InetAddress, String>();

    public static String getTargetTableName(Table table) {
        Map tableParameterMap = table.getParameters();
        String tableName = (String)tableParameterMap.get("phoenix.table.name");
        if (tableName == null) {
            tableName = table.getTableName();
            tableParameterMap.put("phoenix.table.name", tableName);
        }
        return tableName;
    }

    public static Object[] toTypedValues(JobConf jobConf, String typeName, String[] values) throws Exception {
        Object[] results = new Object[values.length];
        SimpleDateFormat df = null;
        int limit = values.length;
        for (int i = 0; i < limit; ++i) {
            if ("string".equals(typeName) || typeName.startsWith("char") || typeName.startsWith("varchar")) {
                results[i] = values[i];
                continue;
            }
            if ("int".equals(typeName)) {
                results[i] = new Integer(values[i]);
                continue;
            }
            if ("bigint".equals(typeName)) {
                results[i] = new Long(values[i]);
                continue;
            }
            if ("double".equals(typeName)) {
                results[i] = new Double(values[i]);
                continue;
            }
            if ("float".equals(typeName)) {
                results[i] = new Float(values[i]);
                continue;
            }
            if ("smallint".equals(typeName)) {
                results[i] = new Short(values[i]);
                continue;
            }
            if ("tinyint".equals(typeName)) {
                results[i] = new Byte(values[i]);
                continue;
            }
            if ("date".equals(typeName)) {
                String dateFormat = jobConf.get("hbase.date.format", "yyyy-MM-dd");
                df = new SimpleDateFormat(dateFormat);
                results[i] = new Long(df.parse(values[i]).getTime());
                continue;
            }
            if ("timestamp".equals(typeName)) {
                String timestampFormat = jobConf.get("hbase.timestamp.format", "yyyy-MM-dd HH:mm:ss.SSS");
                df = new SimpleDateFormat(timestampFormat);
                results[i] = new Long(df.parse(values[i]).getTime());
                continue;
            }
            if (!typeName.contains("decimal")) continue;
            results[i] = new BigDecimal(values[i]);
        }
        return results;
    }

    public static String[] getConstantValues(IndexSearchCondition condition, String comparisonOp) {
        String[] constantValues = null;
        if (comparisonOp.endsWith("UDFOPEqual") || comparisonOp.endsWith("UDFOPNotEqual")) {
            constantValues = new String[]{String.valueOf(condition.getConstantDesc().getValue())};
        } else if (comparisonOp.endsWith("UDFOPEqualOrGreaterThan")) {
            constantValues = new String[]{String.valueOf(condition.getConstantDesc().getValue())};
        } else if (comparisonOp.endsWith("UDFOPGreaterThan")) {
            constantValues = new String[]{String.valueOf(condition.getConstantDesc().getValue())};
        } else if (comparisonOp.endsWith("UDFOPEqualOrLessThan")) {
            constantValues = new String[]{String.valueOf(condition.getConstantDesc().getValue())};
        } else if (comparisonOp.endsWith("UDFOPLessThan")) {
            constantValues = new String[]{String.valueOf(condition.getConstantDesc().getValue())};
        } else if (comparisonOp.endsWith("GenericUDFBetween")) {
            constantValues = new String[]{String.valueOf(condition.getConstantDesc(0).getValue()), String.valueOf(condition.getConstantDesc(1).getValue())};
        } else if (comparisonOp.endsWith("GenericUDFIn")) {
            ExprNodeConstantDesc[] constantDescs = condition.getConstantDescs();
            constantValues = new String[constantDescs.length];
            int limit = constantDescs.length;
            for (int i = 0; i < limit; ++i) {
                constantValues[i] = String.valueOf(condition.getConstantDesc(i).getValue());
            }
        }
        return constantValues;
    }

    public static String getRegionLocation(HRegionLocation location, Logger log) throws IOException {
        InetSocketAddress isa = new InetSocketAddress(location.getHostname(), location.getPort());
        if (isa.isUnresolved()) {
            log.warn("Failed resolve " + isa);
        }
        InetAddress regionAddress = isa.getAddress();
        String regionLocation = null;
        try {
            regionLocation = PhoenixStorageHandlerUtil.reverseDNS(regionAddress);
        }
        catch (NamingException e) {
            log.warn("Cannot resolve the host name for " + regionAddress + " because of " + e);
            regionLocation = location.getHostname();
        }
        return regionLocation;
    }

    private static String reverseDNS(InetAddress ipAddress) throws NamingException, UnknownHostException {
        String hostName = reverseDNSCacheMap.get(ipAddress);
        if (hostName == null) {
            String ipAddressString = null;
            try {
                ipAddressString = DNS.reverseDns((InetAddress)ipAddress, null);
            }
            catch (Exception e) {
                ipAddressString = InetAddress.getByName(ipAddress.getHostAddress()).getHostName();
            }
            if (ipAddressString == null) {
                throw new UnknownHostException("No host found for " + ipAddress);
            }
            hostName = Strings.domainNamePointerToHostName((String)ipAddressString);
            reverseDNSCacheMap.put(ipAddress, hostName);
        }
        return hostName;
    }

    public static String getTableKeyOfSession(JobConf jobConf, String tableName) {
        String sessionId = jobConf.get("phoenix.sessionid");
        return "[" + sessionId + "]-" + tableName;
    }

    public static Map<String, TypeInfo> createColumnTypeMap(JobConf jobConf) {
        HashMap<String, TypeInfo> columnTypeMap = new HashMap<String, TypeInfo>();
        String[] columnNames = jobConf.get("columns").split(",");
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)jobConf.get("columns.types"));
        int limit = columnNames.length;
        for (int i = 0; i < limit; ++i) {
            columnTypeMap.put(columnNames[i], (TypeInfo)typeInfos.get(i));
        }
        return columnTypeMap;
    }

    public static List<String> getReadColumnNames(Configuration conf) {
        String colNames = conf.get("hive.io.file.readcolumn.names");
        if (colNames != null && !colNames.isEmpty()) {
            return Arrays.asList(colNames.split(","));
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean isTransactionalTable(Properties tableProperties) {
        String tableIsTransactional = tableProperties.getProperty("transactional");
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true");
    }

    public static boolean isTransactionalTable(Configuration config) {
        String tableIsTransactional = config.get("transactional");
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true");
    }

    public static void printConfiguration(Configuration config) {
        if (Boolean.getBoolean("dev")) {
            for (Map.Entry entry : config) {
                System.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
    }

    public static String toString(Object obj) {
        String content = null;
        if (obj instanceof Array) {
            Object[] values = (Object[])obj;
            content = String.join((CharSequence)",", (String[])values);
        } else {
            content = obj.toString();
        }
        return content;
    }

    public static Map<?, ?> toMap(byte[] serialized) {
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        try {
            return PrimaryKeyData.deserialize(bais).getData();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getOptionsValue(AcidOutputFormat.Options options) {
        return HiveCompatUtil.getOptionsValue(options, GET_BUCKET_METHOD_REF, GET_BUCKET_ID_METHOD_REF, LOG);
    }
}

