/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.JobConf;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixConnectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixConnectionUtil.class);

    public static Connection getInputConnection(Configuration conf, Properties props) throws SQLException {
        String quorum = conf.get("phoenix.zookeeper.quorum");
        quorum = quorum == null ? props.getProperty("phoenix.zookeeper.quorum", "localhost") : quorum;
        int zooKeeperClientPort = conf.getInt("phoenix.zookeeper.client.port", 0);
        zooKeeperClientPort = zooKeeperClientPort == 0 ? Integer.parseInt(props.getProperty("phoenix.zookeeper.client.port", String.valueOf(2181))) : zooKeeperClientPort;
        String zNodeParent = conf.get("phoenix.zookeeper.znode.parent");
        zNodeParent = zNodeParent == null ? props.getProperty("phoenix.zookeeper.znode.parent", "/hbase") : zNodeParent;
        return PhoenixConnectionUtil.getConnection(quorum, zooKeeperClientPort, zNodeParent, PropertiesUtil.combineProperties((Properties)props, (Configuration)conf));
    }

    public static Connection getConnection(Table table) throws SQLException {
        Map tableParameterMap = table.getParameters();
        String zookeeperQuorum = (String)tableParameterMap.get("phoenix.zookeeper.quorum");
        zookeeperQuorum = zookeeperQuorum == null ? "localhost" : zookeeperQuorum;
        String clientPortString = (String)tableParameterMap.get("phoenix.zookeeper.client.port");
        int clientPort = clientPortString == null ? 2181 : Integer.parseInt(clientPortString);
        String zNodeParent = (String)tableParameterMap.get("phoenix.zookeeper.znode.parent");
        zNodeParent = zNodeParent == null ? "/hbase" : zNodeParent;
        try {
            Class.forName("org.apache.phoenix.jdbc.PhoenixDriver");
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Coould not load driver", (Throwable)e);
        }
        return DriverManager.getConnection(QueryUtil.getUrl((String)zookeeperQuorum, (int)clientPort, (String)zNodeParent));
    }

    private static Connection getConnection(String quorum, Integer clientPort, String zNodeParent, Properties props) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection attrs [quorum, port, znode] : " + quorum + ", " + clientPort + ", " + zNodeParent);
        }
        return DriverManager.getConnection(clientPort != null ? QueryUtil.getUrl((String)quorum, (Integer)clientPort, (String)zNodeParent) : QueryUtil.getUrl((String)quorum), props);
    }

    public static Configuration getConfiguration(JobConf jobConf) {
        String zNodeParent;
        int zooKeeperClientPort;
        Configuration conf = new Configuration((Configuration)jobConf);
        String quorum = conf.get("phoenix.zookeeper.quorum");
        if (quorum != null) {
            conf.set("hbase.zookeeper.quorum", quorum);
        }
        if ((zooKeeperClientPort = conf.getInt("phoenix.zookeeper.client.port", 0)) != 0) {
            conf.setInt("hbase.zookeeper.property.clientPort", zooKeeperClientPort);
        }
        if ((zNodeParent = conf.get("phoenix.zookeeper.znode.parent")) != null) {
            conf.set("zookeeper.znode.parent", zNodeParent);
        }
        return conf;
    }
}

