/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.ql.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.phoenix.hive.ql.index.IndexSearchCondition;
import org.apache.phoenix.hive.util.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexPredicateAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(IndexPredicateAnalyzer.class);
    private final Set<String> udfNames = new HashSet<String>();
    private final Map<String, Set<String>> columnToUDFs = new HashMap<String, Set<String>>();
    private FieldValidator fieldValidator;
    private boolean acceptsFields;

    public void setFieldValidator(FieldValidator fieldValidator) {
        this.fieldValidator = fieldValidator;
    }

    public void addComparisonOp(String udfName) {
        this.udfNames.add(udfName);
    }

    public void clearAllowedColumnNames() {
        this.columnToUDFs.clear();
    }

    public void allowColumnName(String columnName) {
        this.columnToUDFs.put(columnName, this.udfNames);
    }

    public void addComparisonOp(String columnName, String ... udfs) {
        Set<String> allowed = this.columnToUDFs.get(columnName);
        if (allowed == null || allowed == this.udfNames) {
            this.columnToUDFs.put(columnName, new HashSet<String>(Arrays.asList(udfs)));
        } else {
            allowed.addAll(Arrays.asList(udfs));
        }
    }

    public ExprNodeDesc analyzePredicate(ExprNodeDesc predicate, final List<IndexSearchCondition> searchConditions) {
        LinkedHashMap opRules = new LinkedHashMap();
        NodeProcessor nodeProcessor = new NodeProcessor(){

            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                Node ancestor;
                Iterator iterator = stack.iterator();
                while (iterator.hasNext() && nd != (ancestor = (Node)iterator.next())) {
                    if (FunctionRegistry.isOpAnd((ExprNodeDesc)((ExprNodeDesc)ancestor))) continue;
                    return nd;
                }
                return IndexPredicateAnalyzer.this.analyzeExpr((ExprNodeGenericFuncDesc)nd, searchConditions, nodeOutputs);
            }
        };
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(nodeProcessor, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker((Dispatcher)disp);
        ArrayList<ExprNodeDesc> topNodes = new ArrayList<ExprNodeDesc>();
        topNodes.add(predicate);
        HashMap nodeOutput = new HashMap();
        try {
            ogw.startWalking(topNodes, nodeOutput);
        }
        catch (SemanticException ex) {
            throw new RuntimeException(ex);
        }
        ExprNodeDesc residualPredicate = (ExprNodeDesc)nodeOutput.get(predicate);
        return residualPredicate;
    }

    private ExprNodeDesc getColumnExpr(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeColumnDesc) {
            return expr;
        }
        ExprNodeGenericFuncDesc funcDesc = null;
        if (expr instanceof ExprNodeGenericFuncDesc) {
            funcDesc = (ExprNodeGenericFuncDesc)expr;
        }
        if (null == funcDesc) {
            return expr;
        }
        GenericUDF udf = funcDesc.getGenericUDF();
        if ((udf instanceof GenericUDFBridge || udf instanceof GenericUDFToBinary || udf instanceof GenericUDFToChar || udf instanceof GenericUDFToVarchar || udf instanceof GenericUDFToDecimal || udf instanceof GenericUDFToDate || udf instanceof GenericUDFToUnixTimeStamp || udf instanceof GenericUDFToUtcTimestamp) && funcDesc.getChildren().size() == 1 && funcDesc.getChildren().get(0) instanceof ExprNodeColumnDesc) {
            return (ExprNodeDesc)expr.getChildren().get(0);
        }
        return expr;
    }

    private void processingBetweenOperator(ExprNodeGenericFuncDesc expr, List<IndexSearchCondition> searchConditions, Object ... nodeOutputs) {
        String[] fields = null;
        boolean isNot = (Boolean)((ExprNodeConstantDesc)nodeOutputs[0]).getValue();
        ExprNodeDesc columnNodeDesc = (ExprNodeDesc)nodeOutputs[1];
        if (columnNodeDesc instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc fieldDesc = (ExprNodeFieldDesc)columnNodeDesc;
            fields = ExprNodeDescUtils.extractFields((ExprNodeFieldDesc)fieldDesc);
            ExprNodeDesc[] extracted = ExprNodeDescUtils.extractComparePair((ExprNodeDesc)((ExprNodeDesc)nodeOutputs[1]), (ExprNodeDesc)((ExprNodeDesc)nodeOutputs[2]));
            columnNodeDesc = extracted[0];
        }
        this.addSearchConditionIfPossible(expr, searchConditions, fields, isNot, columnNodeDesc, Arrays.copyOfRange(nodeOutputs, 2, nodeOutputs.length));
    }

    private void addSearchConditionIfPossible(ExprNodeGenericFuncDesc expr, List<IndexSearchCondition> searchConditions, String[] fields, boolean isNot, ExprNodeDesc columnNodeDesc, Object[] nodeOutputs) {
        if (!((columnNodeDesc = this.getColumnExpr(columnNodeDesc)) instanceof ExprNodeColumnDesc)) {
            return;
        }
        ExprNodeColumnDesc columnDesc = (ExprNodeColumnDesc)columnNodeDesc;
        String udfName = expr.getGenericUDF().getUdfName();
        ExprNodeConstantDesc[] constantDescs = null;
        if (nodeOutputs != null && (constantDescs = this.extractConstants(columnDesc, nodeOutputs)) == null) {
            return;
        }
        searchConditions.add(new IndexSearchCondition(columnDesc, udfName, constantDescs, expr, fields, isNot));
    }

    private boolean isAcceptableConstants(ExprNodeDesc columnDesc, ExprNodeDesc constant) {
        return TypeInfoUtils.implicitConvertible(constant.getTypeInfo(), columnDesc.getTypeInfo());
    }

    private ExprNodeConstantDesc[] extractConstants(ExprNodeColumnDesc columnDesc, Object ... nodeOutputs) {
        ExprNodeConstantDesc[] constantDescs = new ExprNodeConstantDesc[nodeOutputs.length];
        for (int i = 0; i < nodeOutputs.length; ++i) {
            ExprNodeDesc[] extracted = ExprNodeDescUtils.extractComparePair((ExprNodeDesc)columnDesc, (ExprNodeDesc)((ExprNodeDesc)nodeOutputs[i]));
            if (extracted == null || !this.isAcceptableConstants((ExprNodeDesc)columnDesc, extracted[1])) {
                return null;
            }
            constantDescs[i] = (ExprNodeConstantDesc)extracted[1];
        }
        return constantDescs;
    }

    private void processingInOperator(ExprNodeGenericFuncDesc expr, List<IndexSearchCondition> searchConditions, boolean isNot, Object ... nodeOutputs) {
        ExprNodeDesc columnDesc;
        String[] fields = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing In Operator. nodeOutputs : " + new ArrayList<Object>(Arrays.asList(nodeOutputs)));
        }
        if ((columnDesc = (ExprNodeDesc)nodeOutputs[0]) instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc fieldDesc = (ExprNodeFieldDesc)columnDesc;
            fields = ExprNodeDescUtils.extractFields((ExprNodeFieldDesc)fieldDesc);
            ExprNodeDesc[] extracted = ExprNodeDescUtils.extractComparePair((ExprNodeDesc)((ExprNodeDesc)nodeOutputs[0]), (ExprNodeDesc)((ExprNodeDesc)nodeOutputs[1]));
            if (extracted == null) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("nodeOutputs[0] : " + nodeOutputs[0] + ", nodeOutputs[1] : " + nodeOutputs[1] + " => " + new ArrayList<ExprNodeDesc>(Arrays.asList(extracted)));
            }
            columnDesc = extracted[0];
        }
        this.addSearchConditionIfPossible(expr, searchConditions, fields, isNot, columnDesc, Arrays.copyOfRange(nodeOutputs, 1, nodeOutputs.length));
    }

    private void processingNullOperator(ExprNodeGenericFuncDesc expr, List<IndexSearchCondition> searchConditions, Object ... nodeOutputs) {
        ExprNodeDesc columnDesc = null;
        String[] fields = null;
        columnDesc = (ExprNodeDesc)nodeOutputs[0];
        if (columnDesc instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc fieldDesc = (ExprNodeFieldDesc)columnDesc;
            fields = ExprNodeDescUtils.extractFields((ExprNodeFieldDesc)fieldDesc);
            ExprNodeDesc[] extracted = ExprNodeDescUtils.extractComparePair((ExprNodeDesc)columnDesc, (ExprNodeDesc)new ExprNodeConstantDesc());
            columnDesc = extracted[0];
        }
        this.addSearchConditionIfPossible(expr, searchConditions, fields, false, columnDesc, null);
    }

    private void processingNotNullOperator(ExprNodeGenericFuncDesc expr, List<IndexSearchCondition> searchConditions, Object ... nodeOutputs) {
        String[] fields = null;
        ExprNodeDesc columnDesc = (ExprNodeDesc)nodeOutputs[0];
        if (columnDesc instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc fieldDesc = (ExprNodeFieldDesc)columnDesc;
            fields = ExprNodeDescUtils.extractFields((ExprNodeFieldDesc)fieldDesc);
            ExprNodeDesc[] extracted = ExprNodeDescUtils.extractComparePair((ExprNodeDesc)columnDesc, (ExprNodeDesc)new ExprNodeConstantDesc());
            columnDesc = extracted[0];
        }
        this.addSearchConditionIfPossible(expr, searchConditions, fields, true, columnDesc, null);
    }

    private ExprNodeDesc analyzeExpr(ExprNodeGenericFuncDesc expr, List<IndexSearchCondition> searchConditions, Object ... nodeOutputs) throws SemanticException {
        ExprNodeConstantDesc constantDesc;
        ExprNodeColumnDesc columnDesc;
        ExprNodeDesc[] extracted;
        if (FunctionRegistry.isOpAnd((ExprNodeDesc)expr)) {
            ArrayList<ExprNodeDesc> residuals = new ArrayList<ExprNodeDesc>();
            for (Object nodeOutput : nodeOutputs) {
                if (nodeOutput == null) continue;
                residuals.add((ExprNodeDesc)nodeOutput);
            }
            if (residuals.size() == 1) {
                return (ExprNodeDesc)residuals.get(0);
            }
            return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), residuals);
        }
        GenericUDF genericUDF = expr.getGenericUDF();
        if (!(genericUDF instanceof GenericUDFBaseCompare)) {
            if (genericUDF instanceof GenericUDFBetween) {
                this.processingBetweenOperator(expr, searchConditions, nodeOutputs);
                return expr;
            }
            if (genericUDF instanceof GenericUDFIn) {
                this.processingInOperator(expr, searchConditions, false, nodeOutputs);
                return expr;
            }
            if (genericUDF instanceof GenericUDFOPNot && ((ExprNodeGenericFuncDesc)expr.getChildren().get(0)).getGenericUDF() instanceof GenericUDFIn) {
                this.processingInOperator((ExprNodeGenericFuncDesc)expr.getChildren().get(0), searchConditions, true, ((ExprNodeGenericFuncDesc)nodeOutputs[0]).getChildren().toArray());
                return expr;
            }
            if (genericUDF instanceof GenericUDFOPNull) {
                this.processingNullOperator(expr, searchConditions, nodeOutputs);
                return expr;
            }
            if (genericUDF instanceof GenericUDFOPNotNull) {
                this.processingNotNullOperator(expr, searchConditions, nodeOutputs);
                return expr;
            }
            return expr;
        }
        ExprNodeDesc expr1 = (ExprNodeDesc)nodeOutputs[0];
        ExprNodeDesc expr2 = (ExprNodeDesc)nodeOutputs[1];
        if (expr1.getTypeInfo().equals((Object)expr2.getTypeInfo())) {
            expr1 = this.getColumnExpr(expr1);
            expr2 = this.getColumnExpr(expr2);
        }
        if ((extracted = ExprNodeDescUtils.extractComparePair((ExprNodeDesc)expr1, (ExprNodeDesc)expr2)) == null || extracted.length > 2 && !this.acceptsFields) {
            return expr;
        }
        if (extracted[0] instanceof ExprNodeConstantDesc) {
            genericUDF = genericUDF.flip();
            columnDesc = (ExprNodeColumnDesc)extracted[1];
            constantDesc = (ExprNodeConstantDesc)extracted[0];
        } else {
            columnDesc = (ExprNodeColumnDesc)extracted[0];
            constantDesc = (ExprNodeConstantDesc)extracted[1];
        }
        Set<String> allowed = this.columnToUDFs.get(columnDesc.getColumn());
        if (allowed == null) {
            return expr;
        }
        String udfName = genericUDF.getUdfName();
        if (!allowed.contains(genericUDF.getUdfName())) {
            return expr;
        }
        String[] fields = null;
        if (extracted.length > 2) {
            ExprNodeFieldDesc fieldDesc = (ExprNodeFieldDesc)extracted[2];
            if (!this.isValidField(fieldDesc)) {
                return expr;
            }
            fields = ExprNodeDescUtils.extractFields((ExprNodeFieldDesc)fieldDesc);
        }
        ArrayList<ExprNodeDesc> list = new ArrayList<ExprNodeDesc>();
        list.add(expr1);
        list.add(expr2);
        expr = new ExprNodeGenericFuncDesc(expr.getTypeInfo(), expr.getGenericUDF(), list);
        searchConditions.add(new IndexSearchCondition(columnDesc, udfName, constantDesc, expr, fields));
        return fields == null ? null : expr;
    }

    private boolean isValidField(ExprNodeFieldDesc field) {
        return this.fieldValidator == null || this.fieldValidator.validate(field);
    }

    public ExprNodeGenericFuncDesc translateSearchConditions(List<IndexSearchCondition> searchConditions) {
        ExprNodeGenericFuncDesc expr = null;
        for (IndexSearchCondition searchCondition : searchConditions) {
            if (expr == null) {
                expr = searchCondition.getComparisonExpr();
                continue;
            }
            ArrayList<ExprNodeGenericFuncDesc> children = new ArrayList<ExprNodeGenericFuncDesc>();
            children.add(expr);
            children.add(searchCondition.getComparisonExpr());
            expr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
        }
        return expr;
    }

    public void setAcceptsFields(boolean acceptsFields) {
        this.acceptsFields = acceptsFields;
    }

    public static IndexPredicateAnalyzer createAnalyzer(boolean equalOnly) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual");
        if (equalOnly) {
            return analyzer;
        }
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull");
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull");
        return analyzer;
    }

    public static interface FieldValidator {
        public boolean validate(ExprNodeFieldDesc var1);
    }
}

