/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParameters;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PhoenixListObjectInspector
implements ListObjectInspector {
    private ObjectInspector listElementObjectInspector;
    private byte separator;
    private LazyObjectInspectorParameters lazyParams;

    public PhoenixListObjectInspector(ObjectInspector listElementObjectInspector, byte separator, LazyObjectInspectorParameters lazyParams) {
        this.listElementObjectInspector = listElementObjectInspector;
        this.separator = separator;
        this.lazyParams = lazyParams;
    }

    public String getTypeName() {
        return "array<" + this.listElementObjectInspector.getTypeName() + ">";
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.LIST;
    }

    public ObjectInspector getListElementObjectInspector() {
        return this.listElementObjectInspector;
    }

    public Object getListElement(Object data, int index) {
        if (data == null) {
            return null;
        }
        PhoenixArray array = (PhoenixArray)data;
        return array.getElement(index);
    }

    public int getListLength(Object data) {
        if (data == null) {
            return -1;
        }
        PhoenixArray array = (PhoenixArray)data;
        return array.getDimensions();
    }

    public List<?> getList(Object data) {
        if (data == null) {
            return null;
        }
        PhoenixArray array = (PhoenixArray)data;
        int valueLength = array.getDimensions();
        ArrayList<Object> valueList = new ArrayList<Object>(valueLength);
        for (int i = 0; i < valueLength; ++i) {
            valueList.add(array.getElement(i));
        }
        return valueList;
    }

    public byte getSeparator() {
        return this.separator;
    }

    public LazyObjectInspectorParameters getLazyParams() {
        return this.lazyParams;
    }
}

