/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.objectinspector;

import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.phoenix.hive.objectinspector.AbstractPhoenixObjectInspector;

public class PhoenixDecimalObjectInspector
extends AbstractPhoenixObjectInspector<HiveDecimalWritable>
implements HiveDecimalObjectInspector {
    public PhoenixDecimalObjectInspector() {
        this((PrimitiveTypeInfo)TypeInfoFactory.decimalTypeInfo);
    }

    public PhoenixDecimalObjectInspector(PrimitiveTypeInfo typeInfo) {
        super(typeInfo);
    }

    public Object copyObject(Object o) {
        return o == null ? null : new BigDecimal(o.toString());
    }

    public HiveDecimal getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        return HiveDecimalUtils.enforcePrecisionScale((HiveDecimal)HiveDecimal.create((BigDecimal)((BigDecimal)o)), (DecimalTypeInfo)((DecimalTypeInfo)this.typeInfo));
    }

    public HiveDecimalWritable getPrimitiveWritableObject(Object o) {
        HiveDecimalWritable value = null;
        if (o != null) {
            try {
                value = new HiveDecimalWritable(this.getPrimitiveJavaObject(o));
            }
            catch (Exception e) {
                this.logExceptionMessage(o, "DECIMAL");
            }
        }
        return value;
    }
}

