/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.mapreduce;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.hive.PhoenixRowKey;
import org.apache.phoenix.hive.mapreduce.PhoenixInputSplit;
import org.apache.phoenix.hive.mapreduce.PhoenixResultWritable;
import org.apache.phoenix.hive.util.PhoenixStorageHandlerUtil;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.MapReduceParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.RoundRobinResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.thirdparty.com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixRecordReader<T extends DBWritable>
implements RecordReader<WritableComparable, T> {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixRecordReader.class);
    private final Configuration configuration;
    private final QueryPlan queryPlan;
    private WritableComparable key;
    private T value = null;
    private Class<T> inputClass;
    private ResultIterator resultIterator = null;
    private PhoenixResultSet resultSet;
    private long readCount;
    private boolean isTransactional;

    public PhoenixRecordReader(Class<T> inputClass, Configuration configuration, QueryPlan queryPlan) throws IOException {
        this.inputClass = inputClass;
        this.configuration = configuration;
        this.queryPlan = queryPlan;
        this.isTransactional = PhoenixStorageHandlerUtil.isTransactionalTable(configuration);
    }

    public void initialize(InputSplit split) throws IOException {
        PhoenixInputSplit pSplit = (PhoenixInputSplit)split;
        List<Scan> scans = pSplit.getScans();
        if (LOG.isInfoEnabled()) {
            LOG.info("Target table : " + this.queryPlan.getTableRef().getTable().getPhysicalName());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scan count[" + scans.size() + "] : " + Bytes.toStringBinary((byte[])scans.get(0).getStartRow()) + " ~ " + Bytes.toStringBinary((byte[])scans.get(scans.size() - 1).getStopRow()));
            LOG.debug("First scan : " + scans.get(0) + " scanAttribute : " + scans.get(0).getAttributesMap());
            int limit = scans.size();
            for (int i = 0; i < limit; ++i) {
                LOG.debug("EXPECTED_UPPER_REGION_KEY[" + i + "] : " + Bytes.toStringBinary((byte[])scans.get(i).getAttribute("_ExpectedUpperRegionKey")));
            }
        }
        try {
            PeekingResultIterator iterator;
            ArrayList<PeekingResultIterator> iterators = new ArrayList<PeekingResultIterator>(scans.size());
            StatementContext ctx = this.queryPlan.getContext();
            ReadMetricQueue readMetrics = ctx.getReadMetricsQueue();
            String tableName = this.queryPlan.getTableRef().getTable().getPhysicalName().getString();
            long renewScannerLeaseThreshold = this.queryPlan.getContext().getConnection().getQueryServices().getRenewLeaseThresholdMilliSeconds();
            for (Scan scan : scans) {
                scan.setAttribute("_SKIP_REGION_BOUNDARY_CHECK", Bytes.toBytes((boolean)true));
                ScanMetricsHolder scanMetricsHolder = ScanMetricsHolder.getInstance((ReadMetricQueue)readMetrics, (String)tableName, (Scan)scan, (LogLevel)ctx.getConnection().getLogLevel());
                TableResultIterator tableResultIterator = new TableResultIterator(this.queryPlan.getContext().getConnection().getMutationState(), scan, scanMetricsHolder, renewScannerLeaseThreshold, this.queryPlan, (ParallelScanGrouper)MapReduceParallelScanGrouper.getInstance());
                PeekingResultIterator peekingResultIterator = LookAheadResultIterator.wrap((ResultIterator)tableResultIterator);
                iterators.add(peekingResultIterator);
            }
            Object object = iterator = this.queryPlan.useRoundRobinIterator() ? RoundRobinResultIterator.newIterator(iterators, (QueryPlan)this.queryPlan) : ConcatResultIterator.newIterator(iterators);
            if (this.queryPlan.getContext().getSequenceManager().getSequenceCount() > 0) {
                iterator = new SequenceResultIterator((ResultIterator)iterator, this.queryPlan.getContext().getSequenceManager());
            }
            this.resultIterator = iterator;
            this.resultSet = new PhoenixResultSet(this.resultIterator, this.queryPlan.getProjector().cloneIfNecessary(), this.queryPlan.getContext());
        }
        catch (SQLException e) {
            LOG.error(String.format(" Error [%s] initializing PhoenixRecordReader. ", e.getMessage()));
            Throwables.propagate((Throwable)e);
        }
    }

    public boolean next(WritableComparable key, T value) throws IOException {
        try {
            if (!this.resultSet.next()) {
                return false;
            }
            value.readFields((ResultSet)this.resultSet);
            if (this.isTransactional) {
                ((PhoenixResultWritable)value).readPrimaryKey((PhoenixRowKey)key);
            }
            ++this.readCount;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Result[" + this.readCount + "] : " + ((PhoenixResultWritable)value).getResultMap());
            }
            return true;
        }
        catch (SQLException e) {
            LOG.error(String.format(" Error [%s] occurred while iterating over the resultset. ", e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public WritableComparable createKey() {
        this.key = this.isTransactional ? new PhoenixRowKey() : NullWritable.get();
        return this.key;
    }

    public T createValue() {
        this.value = (DBWritable)ReflectionUtils.newInstance(this.inputClass, (Configuration)this.configuration);
        return this.value;
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Read Count : " + this.readCount);
        }
        if (this.resultIterator != null) {
            try {
                this.resultIterator.close();
            }
            catch (SQLException e) {
                LOG.error(" Error closing resultset.");
                throw new RuntimeException(e);
            }
        }
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }
}

