/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class PhoenixInputSplit
extends FileSplit
implements InputSplit {
    private List<Scan> scans;
    private KeyRange keyRange;
    private long regionSize;
    private String query;

    public PhoenixInputSplit() {
    }

    public PhoenixInputSplit(List<Scan> scans, Path dummyPath, String regionLocation, long length) {
        super(dummyPath, 0L, 0L, new String[]{regionLocation});
        this.regionSize = length;
        Preconditions.checkNotNull(scans);
        Preconditions.checkState((!scans.isEmpty() ? 1 : 0) != 0);
        this.scans = scans;
        this.init();
    }

    public List<Scan> getScans() {
        return this.scans;
    }

    public KeyRange getKeyRange() {
        return this.keyRange;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private void init() {
        this.keyRange = KeyRange.getKeyRange((byte[])this.scans.get(0).getStartRow(), (byte[])this.scans.get(this.scans.size() - 1).getStopRow());
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Preconditions.checkNotNull(this.scans);
        WritableUtils.writeVInt((DataOutput)out, (int)this.scans.size());
        for (Scan scan : this.scans) {
            ClientProtos.Scan protoScan = ProtobufUtil.toScan((Scan)scan);
            byte[] protoScanBytes = protoScan.toByteArray();
            WritableUtils.writeVInt((DataOutput)out, (int)protoScanBytes.length);
            out.write(protoScanBytes);
        }
        WritableUtils.writeString((DataOutput)out, (String)this.query);
        WritableUtils.writeVLong((DataOutput)out, (long)this.regionSize);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int count = WritableUtils.readVInt((DataInput)in);
        this.scans = new ArrayList<Scan>(count);
        for (int i = 0; i < count; ++i) {
            byte[] protoScanBytes = new byte[WritableUtils.readVInt((DataInput)in)];
            in.readFully(protoScanBytes);
            ClientProtos.Scan protoScan = ClientProtos.Scan.parseFrom((byte[])protoScanBytes);
            Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)protoScan);
            this.scans.add(scan);
        }
        this.init();
        this.query = WritableUtils.readString((DataInput)in);
        this.regionSize = WritableUtils.readVLong((DataInput)in);
    }

    public long getLength() {
        return this.regionSize;
    }

    public String[] getLocations() throws IOException {
        return new String[0];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.keyRange.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoenixInputSplit)) {
            return false;
        }
        PhoenixInputSplit other = (PhoenixInputSplit)((Object)obj);
        return !(this.keyRange == null ? other.keyRange != null : !this.keyRange.equals((Object)other.keyRange));
    }
}

