/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.metadata.InputEstimator;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.phoenix.hive.PhoenixMetaHook;
import org.apache.phoenix.hive.PhoenixSerDe;
import org.apache.phoenix.hive.mapreduce.PhoenixInputFormat;
import org.apache.phoenix.hive.mapreduce.PhoenixOutputFormat;
import org.apache.phoenix.hive.ppd.PhoenixPredicateDecomposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixStorageHandler
extends DefaultStorageHandler
implements HiveStoragePredicateHandler,
InputEstimator {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixStorageHandler.class);
    private Configuration jobConf;
    private Configuration hbaseConf;

    public void setConf(Configuration conf) {
        this.jobConf = conf;
        this.hbaseConf = HBaseConfiguration.create((Configuration)conf);
    }

    public Configuration getConf() {
        return this.hbaseConf;
    }

    public PhoenixStorageHandler() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PhoenixStorageHandler created");
        }
    }

    public HiveMetaHook getMetaHook() {
        return new PhoenixMetaHook();
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        try {
            org.apache.hadoop.hbase.mapred.TableMapReduceUtil.addDependencyJars((JobConf)jobConf);
            TableMapReduceUtil.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{PhoenixStorageHandler.class});
            JobConf hbaseJobConf = new JobConf(this.getConf());
            org.apache.hadoop.hbase.mapred.TableMapReduceUtil.initCredentials((JobConf)hbaseJobConf);
            ShimLoader.getHadoopShims().mergeCredentials(jobConf, hbaseJobConf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return PhoenixOutputFormat.class;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return PhoenixInputFormat.class;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring input job for table : " + tableDesc.getTableName());
        }
        tableDesc.getProperties().setProperty("in.out.work", "input");
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring output job for  table : " + tableDesc.getTableName());
        }
        tableDesc.getProperties().setProperty("in.out.work", "output");
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
    }

    protected void configureJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        SessionState sessionState;
        String tableName;
        Class inputFormatClass;
        Properties tableProperties = tableDesc.getProperties();
        String inputFormatClassName = tableProperties.getProperty("phoenix.input.format.class");
        if (LOG.isDebugEnabled()) {
            LOG.debug("phoenix.input.format.class is " + inputFormatClassName);
        }
        try {
            inputFormatClass = inputFormatClassName != null ? JavaUtils.loadClass((String)inputFormatClassName) : PhoenixInputFormat.class;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (inputFormatClass != null) {
            tableDesc.setInputFileFormatClass(inputFormatClass);
        }
        if ((tableName = tableProperties.getProperty("phoenix.table.name")) == null) {
            tableName = tableDesc.getTableName();
            tableProperties.setProperty("phoenix.table.name", tableName);
        }
        String sessionId = (sessionState = SessionState.get()) != null ? sessionState.getSessionId() : UUID.randomUUID().toString();
        jobProperties.put("phoenix.sessionid", sessionId);
        jobProperties.put("phoenix.input.table.name", tableName);
        jobProperties.put("phoenix.zookeeper.quorum", tableProperties.getProperty("phoenix.zookeeper.quorum", "localhost"));
        jobProperties.put("phoenix.zookeeper.client.port", tableProperties.getProperty("phoenix.zookeeper.client.port", String.valueOf(2181)));
        jobProperties.put("phoenix.zookeeper.znode.parent", tableProperties.getProperty("phoenix.zookeeper.znode.parent", "/hbase"));
        String columnMapping = tableProperties.getProperty("phoenix.column.mapping");
        if (columnMapping != null) {
            jobProperties.put("phoenix.column.mapping", columnMapping);
        }
        jobProperties.put("storage_handler", ((Object)((Object)this)).getClass().getName());
        jobProperties.put("hbase.zookeeper.quorum", jobProperties.get("phoenix.zookeeper.quorum"));
        jobProperties.put("hbase.zookeeper.property.clientPort", jobProperties.get("phoenix.zookeeper.client.port"));
        jobProperties.put("zookeeper.znode.parent", jobProperties.get("phoenix.zookeeper.znode.parent"));
        this.addHBaseResources(this.jobConf, jobProperties);
    }

    private void addHBaseResources(Configuration jobConf, Map<String, String> newJobProperties) {
        Configuration conf = new Configuration(false);
        HBaseConfiguration.addHbaseResources((Configuration)conf);
        for (Map.Entry entry : conf) {
            if (jobConf.get((String)entry.getKey()) != null) continue;
            newJobProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return PhoenixSerDe.class;
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc predicate) {
        PhoenixSerDe phoenixSerDe = (PhoenixSerDe)deserializer;
        List columnNameList = phoenixSerDe.getSerdeParams().getColumnNames();
        return PhoenixPredicateDecomposer.create(columnNameList).decomposePredicate(predicate);
    }

    public InputEstimator.Estimation estimate(JobConf job, TableScanOperator ts, long remaining) throws HiveException {
        String hiveTableName = ((TableScanDesc)ts.getConf()).getTableMetadata().getTableName();
        int reducerCount = job.getInt(hiveTableName + ".reducer.count", 1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Estimating input size for table: " + hiveTableName + " with reducer count " + reducerCount + ". Remaining : " + remaining);
        }
        long bytesPerReducer = job.getLong(HiveConf.ConfVars.BYTESPERREDUCER.varname, Long.parseLong(HiveConf.ConfVars.BYTESPERREDUCER.getDefaultValue()));
        long totalLength = (long)reducerCount * bytesPerReducer;
        return new InputEstimator.Estimation(0, totalLength);
    }
}

