/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compat;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.cache.results.QueryResultsCache;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.phoenix.compat.MyResult;
import org.slf4j.Logger;

public class HiveCompatUtil {
    private HiveCompatUtil() {
    }

    public static ExprNodeGenericFuncDesc getComparisonExpr(ExprNodeGenericFuncDesc comparisonExpr, boolean isNot) {
        ExprNodeGenericFuncDesc ret = comparisonExpr;
        try {
            if (GenericUDFIn.class == comparisonExpr.getGenericUDF().getClass() && isNot) {
                ret = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getFunctionInfo((String)"not").getGenericUDF(), Collections.singletonList(comparisonExpr));
            }
        }
        catch (SemanticException e) {
            throw new RuntimeException("hive operator -- never be thrown", e);
        }
        return ret;
    }

    public static String getOptionsValue(AcidOutputFormat.Options options, AtomicReference<Method> GET_BUCKET_METHOD_REF, AtomicReference<Method> GET_BUCKET_ID_METHOD_REF, Logger LOG) {
        StringBuilder content = new StringBuilder();
        int bucket = HiveCompatUtil.getBucket(options, GET_BUCKET_METHOD_REF, GET_BUCKET_ID_METHOD_REF, LOG);
        String inspectorInfo = options.getInspector().getCategory() + ":" + options.getInspector().getTypeName();
        long maxTxnId = options.getMaximumWriteId();
        long minTxnId = options.getMinimumWriteId();
        int recordIdColumn = options.getRecordIdColumn();
        boolean isCompresses = options.isCompressed();
        boolean isWritingBase = options.isWritingBase();
        content.append("bucket : ").append(bucket).append(", inspectorInfo : ").append(inspectorInfo).append(", minTxnId : ").append(minTxnId).append(", maxTxnId : ").append(maxTxnId).append(", recordIdColumn : ").append(recordIdColumn);
        content.append(", isCompressed : ").append(isCompresses).append(", isWritingBase : ").append(isWritingBase);
        return content.toString();
    }

    private static int getBucket(AcidOutputFormat.Options options, AtomicReference<Method> GET_BUCKET_METHOD_REF, AtomicReference<Method> GET_BUCKET_ID_METHOD_REF, Logger LOG) {
        Method getBucketMethod = GET_BUCKET_METHOD_REF.get();
        try {
            if (getBucketMethod == null) {
                getBucketMethod = AcidOutputFormat.Options.class.getMethod("getBucket", new Class[0]);
                GET_BUCKET_METHOD_REF.set(getBucketMethod);
            }
            return (Integer)getBucketMethod.invoke((Object)options, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            LOG.trace("Failed to invoke Options.getBucket()", (Throwable)e);
            Method getBucketIdMethod = GET_BUCKET_ID_METHOD_REF.get();
            try {
                if (getBucketIdMethod == null) {
                    getBucketIdMethod = AcidOutputFormat.Options.class.getMethod("getBucketId", new Class[0]);
                    GET_BUCKET_ID_METHOD_REF.set(getBucketMethod);
                }
                return (Integer)getBucketIdMethod.invoke((Object)options, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e2) {
                throw new RuntimeException("Failed to invoke Options.getBucketId()", e2);
            }
        }
    }

    public static Object getDateOrTimestampValue(Object value) {
        if (value instanceof org.apache.hadoop.hive.common.type.Date) {
            value = Date.valueOf(value.toString());
        } else if (value instanceof org.apache.hadoop.hive.common.type.Timestamp) {
            value = Timestamp.valueOf(value.toString());
        }
        return value;
    }

    public static String getDefaultDatabaseName() {
        return "default";
    }

    public static MyResult doSetup(String confDir) throws MalformedURLException {
        if (confDir != null && !confDir.isEmpty()) {
            HiveConf.setHiveSiteLocation((URL)new URL("file://" + new File(confDir).toURI().getPath() + "/hive-site.xml"));
            MetastoreConf.setHiveSiteLocation((URL)HiveConf.getHiveSiteLocation());
            System.out.println("Setting hive-site: " + HiveConf.getHiveSiteLocation());
        }
        QueryState queryState = new QueryState.Builder().withHiveConf(new HiveConf(IDriver.class)).build();
        HiveConf conf = queryState.getConf();
        return new MyResult(conf, queryState);
    }

    public static void destroyTEZSession(SessionState sessionState) throws Exception {
        sessionState.getTezSession().destroy();
    }

    public static Object getDriver(HiveConf conf) {
        return DriverFactory.newDriver((HiveConf)conf);
    }

    public static void cleanupQueryResultCache() {
        QueryResultsCache.cleanupInstance();
    }

    public static HiveConf getHiveConf() {
        return new HiveConf(IDriver.class);
    }

    public static int getDriverResponseCode(Object drv, String createTableCmd) {
        IDriver driver = (IDriver)drv;
        return driver.run(createTableCmd).getResponseCode();
    }

    public static void closeDriver(Object drv) {
        IDriver driver = (IDriver)drv;
        driver.close();
    }

    public static QueryState getQueryState(HiveConf conf) {
        return new QueryState.Builder().withHiveConf(conf).build();
    }

    public static void initHiveMaterializedViewsRegistry() {
        HiveMaterializedViewsRegistry.get().init();
    }

    public static void initHiveMaterializedViewsRegistry(Hive db) {
    }
}

