/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.mapred.JobConf;
import org.apache.phoenix.hive.ql.index.IndexSearchCondition;
import org.apache.phoenix.hive.query.PhoenixQueryBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PhoenixQueryBuilderTest {
    private static final PhoenixQueryBuilder BUILDER = PhoenixQueryBuilder.getInstance();
    private static final String TABLE_NAME = "TEST_TABLE";

    private IndexSearchCondition mockedIndexSearchCondition(String comparisionOp, Object constantValue, Object[] constantValues, String columnName, String typeString, boolean isNot) {
        IndexSearchCondition condition = (IndexSearchCondition)Mockito.mock(IndexSearchCondition.class);
        Mockito.when((Object)condition.getComparisonOp()).thenReturn((Object)comparisionOp);
        if (constantValue != null) {
            ExprNodeConstantDesc constantDesc = (ExprNodeConstantDesc)Mockito.mock(ExprNodeConstantDesc.class);
            Mockito.when((Object)constantDesc.getValue()).thenReturn(constantValue);
            Mockito.when((Object)condition.getConstantDesc()).thenReturn((Object)constantDesc);
        }
        ExprNodeColumnDesc columnDesc = (ExprNodeColumnDesc)Mockito.mock(ExprNodeColumnDesc.class);
        Mockito.when((Object)columnDesc.getColumn()).thenReturn((Object)columnName);
        Mockito.when((Object)columnDesc.getTypeString()).thenReturn((Object)typeString);
        Mockito.when((Object)condition.getColumnDesc()).thenReturn((Object)columnDesc);
        if (ArrayUtils.isNotEmpty((Object[])constantValues)) {
            ExprNodeConstantDesc[] constantDescs = new ExprNodeConstantDesc[constantValues.length];
            for (int i = 0; i < constantDescs.length; ++i) {
                constantDescs[i] = (ExprNodeConstantDesc)Mockito.mock(ExprNodeConstantDesc.class);
                Mockito.when((Object)condition.getConstantDesc(i)).thenReturn((Object)constantDescs[i]);
                Mockito.when((Object)constantDescs[i].getValue()).thenReturn(constantValues[i]);
            }
            Mockito.when((Object)condition.getConstantDescs()).thenReturn((Object)constantDescs);
        }
        Mockito.when((Object)condition.isNot()).thenReturn((Object)isNot);
        return condition;
    }

    @Test
    public void testBuildQueryWithCharColumns() throws IOException {
        String COLUMN_CHAR = "Column_Char";
        String COLUMN_VARCHAR = "Column_VChar";
        String expectedQueryPrefix = "select /*+ NO_CACHE  */ \"Column_Char\",\"Column_VChar\" from TEST_TABLE where ";
        JobConf jobConf = new JobConf();
        ArrayList<String> readColumnList = new ArrayList<String>(Arrays.asList("Column_Char", "Column_VChar"));
        ArrayList<IndexSearchCondition> searchConditions = new ArrayList<IndexSearchCondition>(Arrays.asList(this.mockedIndexSearchCondition("GenericUDFOPEqual", "CHAR_VALUE", null, "Column_Char", "char(10)", false), this.mockedIndexSearchCondition("GenericUDFOPEqual", "CHAR_VALUE2", null, "Column_VChar", "varchar(10)", false)));
        Assert.assertEquals((Object)"select /*+ NO_CACHE  */ \"Column_Char\",\"Column_VChar\" from TEST_TABLE where \"Column_Char\" = 'CHAR_VALUE' and \"Column_VChar\" = 'CHAR_VALUE2'", (Object)BUILDER.buildQuery(jobConf, TABLE_NAME, readColumnList, searchConditions));
        searchConditions = new ArrayList<IndexSearchCondition>(Arrays.asList(this.mockedIndexSearchCondition("GenericUDFIn", null, new Object[]{"CHAR1", "CHAR2", "CHAR3"}, "Column_Char", "char(10)", false)));
        Assert.assertEquals((Object)"select /*+ NO_CACHE  */ \"Column_Char\",\"Column_VChar\" from TEST_TABLE where \"Column_Char\" in ('CHAR1', 'CHAR2', 'CHAR3')", (Object)BUILDER.buildQuery(jobConf, TABLE_NAME, readColumnList, searchConditions));
        searchConditions = new ArrayList<IndexSearchCondition>(Arrays.asList(this.mockedIndexSearchCondition("GenericUDFIn", null, new Object[]{"CHAR1", "CHAR2", "CHAR3"}, "Column_Char", "char(10)", true)));
        Assert.assertEquals((Object)"select /*+ NO_CACHE  */ \"Column_Char\",\"Column_VChar\" from TEST_TABLE where \"Column_Char\" not in ('CHAR1', 'CHAR2', 'CHAR3')", (Object)BUILDER.buildQuery(jobConf, TABLE_NAME, readColumnList, searchConditions));
        searchConditions = new ArrayList<IndexSearchCondition>(Arrays.asList(this.mockedIndexSearchCondition("GenericUDFBetween", null, new Object[]{"CHAR1", "CHAR2"}, "Column_Char", "char(10)", false)));
        Assert.assertEquals((Object)"select /*+ NO_CACHE  */ \"Column_Char\",\"Column_VChar\" from TEST_TABLE where \"Column_Char\" between 'CHAR1' and 'CHAR2'", (Object)BUILDER.buildQuery(jobConf, TABLE_NAME, readColumnList, searchConditions));
        searchConditions = new ArrayList<IndexSearchCondition>(Arrays.asList(this.mockedIndexSearchCondition("GenericUDFBetween", null, new Object[]{"CHAR1", "CHAR2"}, "Column_Char", "char(10)", true)));
        Assert.assertEquals((Object)"select /*+ NO_CACHE  */ \"Column_Char\",\"Column_VChar\" from TEST_TABLE where \"Column_Char\" not between 'CHAR1' and 'CHAR2'", (Object)BUILDER.buildQuery(jobConf, TABLE_NAME, readColumnList, searchConditions));
    }

    @Test
    public void testBuildBetweenQueryWithDateColumns() throws IOException {
        String COLUMN_DATE = "Column_Date";
        String tableName = TABLE_NAME;
        String expectedQueryPrefix = "select /*+ NO_CACHE  */ \"Column_Date\" from TEST_TABLE where ";
        JobConf jobConf = new JobConf();
        ArrayList<String> readColumnList = new ArrayList<String>(Arrays.asList("Column_Date"));
        ArrayList<IndexSearchCondition> searchConditions = new ArrayList<IndexSearchCondition>(Arrays.asList(this.mockedIndexSearchCondition("GenericUDFBetween", null, new Object[]{"1992-01-02", "1992-02-02"}, "Column_Date", "date", false)));
        Assert.assertEquals((Object)"select /*+ NO_CACHE  */ \"Column_Date\" from TEST_TABLE where \"Column_Date\" between to_date('1992-01-02') and to_date('1992-02-02')", (Object)BUILDER.buildQuery(jobConf, TABLE_NAME, readColumnList, searchConditions));
        searchConditions = new ArrayList<IndexSearchCondition>(Arrays.asList(this.mockedIndexSearchCondition("GenericUDFBetween", null, new Object[]{"1992-01-02", "1992-02-02"}, "Column_Date", "date", true)));
        Assert.assertEquals((Object)"select /*+ NO_CACHE  */ \"Column_Date\" from TEST_TABLE where \"Column_Date\" not between to_date('1992-01-02') and to_date('1992-02-02')", (Object)BUILDER.buildQuery(jobConf, TABLE_NAME, readColumnList, searchConditions));
    }

    @Test
    public void testBuildQueryWithNotNull() throws IOException {
        String COLUMN_DATE = "Column_Date";
        String tableName = TABLE_NAME;
        String expectedQueryPrefix = "select /*+ NO_CACHE  */ \"Column_Date\" from TEST_TABLE where ";
        JobConf jobConf = new JobConf();
        ArrayList<String> readColumnList = new ArrayList<String>(Arrays.asList("Column_Date"));
        ArrayList<IndexSearchCondition> searchConditions = new ArrayList<IndexSearchCondition>(Arrays.asList(this.mockedIndexSearchCondition("GenericUDFOPNotNull", null, null, "Column_Date", "date", true)));
        Assert.assertEquals((Object)"select /*+ NO_CACHE  */ \"Column_Date\" from TEST_TABLE where \"Column_Date\" is not null ", (Object)BUILDER.buildQuery(jobConf, TABLE_NAME, readColumnList, searchConditions));
    }

    @Test
    public void testBuildQueryWithBigintColumns() throws IOException {
        String COLUMN_BIGINT = "Column_Bigint";
        String tableName = TABLE_NAME;
        String expectedQueryPrefix = "select /*+ NO_CACHE  */ \"Column_Bigint\" from TEST_TABLE where ";
        JobConf jobConf = new JobConf();
        ArrayList<String> readColumnList = new ArrayList<String>(Arrays.asList("Column_Bigint"));
        ArrayList<IndexSearchCondition> searchConditions = new ArrayList<IndexSearchCondition>(Arrays.asList(this.mockedIndexSearchCondition("GenericUDFOPEqual", 100L, null, "Column_Bigint", "bigint", false)));
        Assert.assertEquals((Object)"select /*+ NO_CACHE  */ \"Column_Bigint\" from TEST_TABLE where \"Column_Bigint\" = 100", (Object)BUILDER.buildQuery(jobConf, TABLE_NAME, readColumnList, searchConditions));
    }
}

