/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.phoenix.hive.PrimaryKeyData;
import org.junit.Assert;
import org.junit.Test;

public class PrimaryKeyDataTest {
    private byte[] serialize(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(o);
        }
        return baos.toByteArray();
    }

    @Test
    public void testSerde() throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("one", 1);
        data.put("two", "two");
        data.put("three", 3);
        PrimaryKeyData pkData = new PrimaryKeyData(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        pkData.serialize((OutputStream)baos);
        PrimaryKeyData pkCopy = PrimaryKeyData.deserialize((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Assert.assertEquals(data, (Object)pkCopy.getData());
    }

    @Test
    public void testDisallowedDeserialization() throws Exception {
        byte[] serializedMap = this.serialize(new HashMap());
        byte[] serializedClass = this.serialize(new Disallowed());
        byte[] serializedString = this.serialize("asdf");
        try {
            PrimaryKeyData.deserialize((InputStream)new ByteArrayInputStream(serializedMap));
            Assert.fail((String)"Expected an InvalidClassException");
        }
        catch (InvalidClassException invalidClassException) {
            // empty catch block
        }
        try {
            PrimaryKeyData.deserialize((InputStream)new ByteArrayInputStream(serializedClass));
            Assert.fail((String)"Expected an InvalidClassException");
        }
        catch (InvalidClassException invalidClassException) {
            // empty catch block
        }
        try {
            PrimaryKeyData.deserialize((InputStream)new ByteArrayInputStream(serializedString));
            Assert.fail((String)"Expected an InvalidClassException");
        }
        catch (InvalidClassException invalidClassException) {
            // empty catch block
        }
    }

    private static class Disallowed
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private Disallowed() {
        }
    }
}

