/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.util;

import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.phoenix.mapreduce.PhoenixRecordWritable;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PUnsignedSmallint;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.pig.PigException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.hadoop.hbase.HBaseBinaryConverter;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TypeUtil.class);
    private static final HBaseBinaryConverter BINARY_CONVERTER = new HBaseBinaryConverter();
    private static final ImmutableMap<PDataType, Byte> PHOENIX_TO_PIG_TYPE = TypeUtil.init();
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    private TypeUtil() {
    }

    private static ImmutableMap<PDataType, Byte> init() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)PLong.INSTANCE, (Object)15);
        builder.put((Object)PVarbinary.INSTANCE, (Object)50);
        builder.put((Object)PChar.INSTANCE, (Object)55);
        builder.put((Object)PVarchar.INSTANCE, (Object)55);
        builder.put((Object)PDouble.INSTANCE, (Object)25);
        builder.put((Object)PFloat.INSTANCE, (Object)20);
        builder.put((Object)PInteger.INSTANCE, (Object)10);
        builder.put((Object)PTinyint.INSTANCE, (Object)10);
        builder.put((Object)PSmallint.INSTANCE, (Object)10);
        builder.put((Object)PDecimal.INSTANCE, (Object)70);
        builder.put((Object)PTime.INSTANCE, (Object)30);
        builder.put((Object)PTimestamp.INSTANCE, (Object)30);
        builder.put((Object)PBoolean.INSTANCE, (Object)5);
        builder.put((Object)PDate.INSTANCE, (Object)30);
        builder.put((Object)PUnsignedDate.INSTANCE, (Object)30);
        builder.put((Object)PUnsignedDouble.INSTANCE, (Object)25);
        builder.put((Object)PUnsignedFloat.INSTANCE, (Object)20);
        builder.put((Object)PUnsignedInt.INSTANCE, (Object)10);
        builder.put((Object)PUnsignedLong.INSTANCE, (Object)15);
        builder.put((Object)PUnsignedSmallint.INSTANCE, (Object)10);
        builder.put((Object)PUnsignedTime.INSTANCE, (Object)30);
        builder.put((Object)PUnsignedTimestamp.INSTANCE, (Object)30);
        builder.put((Object)PUnsignedTinyint.INSTANCE, (Object)10);
        return builder.build();
    }

    public static PDataType getType(Object obj, byte type) {
        PVarbinary sqlType;
        if (obj == null) {
            return null;
        }
        switch (type) {
            case 50: {
                sqlType = PVarbinary.INSTANCE;
                break;
            }
            case 55: {
                sqlType = PVarchar.INSTANCE;
                break;
            }
            case 25: 
            case 70: {
                sqlType = PDouble.INSTANCE;
                break;
            }
            case 20: {
                sqlType = PFloat.INSTANCE;
                break;
            }
            case 10: {
                sqlType = PInteger.INSTANCE;
                break;
            }
            case 15: 
            case 65: {
                sqlType = PLong.INSTANCE;
                break;
            }
            case 5: {
                sqlType = PBoolean.INSTANCE;
                break;
            }
            case 30: {
                sqlType = PDate.INSTANCE;
                break;
            }
            case 6: {
                sqlType = PTinyint.INSTANCE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown type " + obj.getClass().getName() + " passed to PhoenixHBaseStorage");
            }
        }
        return sqlType;
    }

    public static Object castPigTypeToPhoenix(Object o, byte objectType, PDataType targetPhoenixType) throws SQLException {
        if (110 == objectType) {
            Tuple tuple = (Tuple)o;
            List data = tuple.getAll();
            return data.toArray();
        }
        PDataType inferredPType = TypeUtil.getType(o, objectType);
        if (inferredPType == null) {
            return null;
        }
        if (inferredPType == PVarbinary.INSTANCE) {
            try {
                o = TypeUtil.castBytes(o, targetPhoenixType);
                if (targetPhoenixType != PVarbinary.INSTANCE && targetPhoenixType != PBinary.INSTANCE) {
                    inferredPType = TypeUtil.getType(o, DataType.findType((Object)o));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while casting bytes for object " + o);
            }
        }
        if (inferredPType == PDate.INSTANCE) {
            int inferredSqlType = targetPhoenixType.getSqlType();
            if (inferredSqlType == 91) {
                return new Date(((DateTime)o).getMillis());
            }
            if (inferredSqlType == 92) {
                return new Time(((DateTime)o).getMillis());
            }
            if (inferredSqlType == 93) {
                return new Timestamp(((DateTime)o).getMillis());
            }
        }
        if (targetPhoenixType == inferredPType || inferredPType.isCoercibleTo(targetPhoenixType)) {
            return inferredPType.toObject(o, targetPhoenixType);
        }
        throw new RuntimeException(o.getClass().getName() + " cannot be coerced to " + targetPhoenixType.toString());
    }

    private static Object castBytes(Object o, PDataType targetPhoenixType) throws IOException {
        byte[] bytes = ((DataByteArray)o).get();
        if (PDataType.equalsAny((PDataType)targetPhoenixType, (PDataType[])new PDataType[]{PChar.INSTANCE, PVarchar.INSTANCE})) {
            return BINARY_CONVERTER.bytesToCharArray(bytes);
        }
        if (PDataType.equalsAny((PDataType)targetPhoenixType, (PDataType[])new PDataType[]{PUnsignedSmallint.INSTANCE, PSmallint.INSTANCE})) {
            return BINARY_CONVERTER.bytesToInteger(bytes).shortValue();
        }
        if (PDataType.equalsAny((PDataType)targetPhoenixType, (PDataType[])new PDataType[]{PUnsignedTinyint.INSTANCE, PTinyint.INSTANCE})) {
            return BINARY_CONVERTER.bytesToInteger(bytes).byteValue();
        }
        if (PDataType.equalsAny((PDataType)targetPhoenixType, (PDataType[])new PDataType[]{PUnsignedInt.INSTANCE, PInteger.INSTANCE})) {
            return BINARY_CONVERTER.bytesToInteger(bytes);
        }
        if (targetPhoenixType.equals((Object)PBoolean.INSTANCE)) {
            return BINARY_CONVERTER.bytesToBoolean(bytes);
        }
        if (PDataType.equalsAny((PDataType)targetPhoenixType, (PDataType[])new PDataType[]{PFloat.INSTANCE, PUnsignedFloat.INSTANCE})) {
            return BINARY_CONVERTER.bytesToFloat(bytes);
        }
        if (PDataType.equalsAny((PDataType)targetPhoenixType, (PDataType[])new PDataType[]{PDouble.INSTANCE, PUnsignedDouble.INSTANCE})) {
            return BINARY_CONVERTER.bytesToDouble(bytes);
        }
        if (PDataType.equalsAny((PDataType)targetPhoenixType, (PDataType[])new PDataType[]{PUnsignedLong.INSTANCE, PLong.INSTANCE})) {
            return BINARY_CONVERTER.bytesToLong(bytes);
        }
        if (PDataType.equalsAny((PDataType)targetPhoenixType, (PDataType[])new PDataType[]{PVarbinary.INSTANCE, PBinary.INSTANCE})) {
            return bytes;
        }
        return o;
    }

    public static Tuple transformToTuple(PhoenixRecordWritable record, ResourceSchema.ResourceFieldSchema[] projectedColumns) throws IOException {
        Map columnValues = record.getResultMap();
        if (columnValues == null || columnValues.size() == 0 || projectedColumns == null || projectedColumns.length != columnValues.size()) {
            return null;
        }
        int numColumns = columnValues.size();
        Tuple tuple = TUPLE_FACTORY.newTuple(numColumns);
        try {
            int i = 0;
            for (Map.Entry entry : columnValues.entrySet()) {
                ResourceSchema.ResourceFieldSchema fieldSchema = projectedColumns[i];
                Object object = entry.getValue();
                if (object == null) {
                    tuple.set(i++, null);
                    continue;
                }
                switch (fieldSchema.getType()) {
                    case 50: {
                        byte[] bytes = PDataType.fromTypeId((int)PBinary.INSTANCE.getSqlType()).toBytes(object);
                        tuple.set(i, (Object)new DataByteArray(bytes, 0, bytes.length));
                        break;
                    }
                    case 55: {
                        tuple.set(i, (Object)DataType.toString(object));
                        break;
                    }
                    case 25: {
                        tuple.set(i, (Object)DataType.toDouble(object));
                        break;
                    }
                    case 20: {
                        tuple.set(i, (Object)DataType.toFloat(object));
                        break;
                    }
                    case 10: {
                        tuple.set(i, (Object)DataType.toInteger(object));
                        break;
                    }
                    case 15: {
                        tuple.set(i, (Object)DataType.toLong(object));
                        break;
                    }
                    case 5: {
                        tuple.set(i, (Object)DataType.toBoolean(object));
                        break;
                    }
                    case 30: {
                        if (object instanceof Timestamp) {
                            tuple.set(i, (Object)new DateTime(((Timestamp)object).getTime()));
                            break;
                        }
                        tuple.set(i, (Object)new DateTime(object));
                        break;
                    }
                    case 70: {
                        tuple.set(i, (Object)DataType.toBigDecimal(object));
                        break;
                    }
                    case 65: {
                        tuple.set(i, (Object)DataType.toBigInteger(object));
                        break;
                    }
                    case 110: {
                        PhoenixArray array = (PhoenixArray)object;
                        Tuple t = TUPLE_FACTORY.newTuple(array.getDimensions());
                        for (int j = 0; j < array.getDimensions(); ++j) {
                            t.set(j, array.getElement(j));
                        }
                        tuple.set(i, (Object)t);
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format(" Not supported [%s] pig type", fieldSchema));
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            String errorMsg = String.format(" Error transforming PhoenixRecord to Tuple [%s] ", ex.getMessage());
            LOG.error(errorMsg);
            throw new PigException(errorMsg);
        }
        return tuple;
    }

    public static Byte getPigDataTypeForPhoenixType(PDataType phoenixDataType) {
        Preconditions.checkNotNull((Object)phoenixDataType);
        if (phoenixDataType instanceof PArrayDataType) {
            return (byte)110;
        }
        Byte pigDataType = (Byte)PHOENIX_TO_PIG_TYPE.get((Object)phoenixDataType);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format(" For PhoenixDataType [%s] , pigDataType is [%s] ", phoenixDataType.getSqlTypeName(), DataType.findTypeName((Object)pigDataType)));
        }
        return pigDataType;
    }
}

