/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.util;

import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Splitter;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;

public final class TableSchemaParserFunction
implements Function<String, Pair<String, String>> {
    private static final char TABLE_COLUMN_DELIMITER = '/';

    public Pair<String, String> apply(String tableSchema) {
        Preconditions.checkNotNull((Object)tableSchema);
        Preconditions.checkArgument((!tableSchema.isEmpty() ? 1 : 0) != 0, (Object)"HBase Table name is empty!!");
        String[] tokens = (String[])Iterables.toArray((Iterable)Splitter.on((char)'/').trimResults().omitEmptyStrings().split((CharSequence)tableSchema), String.class);
        String tableName = tokens[0];
        String columns = null;
        if (tokens.length > 1) {
            columns = tokens[1];
        }
        return new Pair((Object)tableName, (Object)columns);
    }
}

