/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ColumnInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlQueryToColumnInfoFunction
implements Function<String, List<ColumnInfo>> {
    private static final Logger LOG = LoggerFactory.getLogger(SqlQueryToColumnInfoFunction.class);
    private final Configuration configuration;

    public SqlQueryToColumnInfoFunction(Configuration configuration) {
        this.configuration = configuration;
    }

    public List<ColumnInfo> apply(String sqlQuery) {
        Preconditions.checkNotNull((Object)sqlQuery);
        Connection connection = null;
        List columnInfos = null;
        try {
            connection = ConnectionUtil.getInputConnection((Configuration)this.configuration);
            Statement statement = connection.createStatement();
            PhoenixStatement pstmt = statement.unwrap(PhoenixStatement.class);
            QueryPlan queryPlan = pstmt.compileQuery(sqlQuery);
            List projectedColumns = queryPlan.getProjector().getColumnProjectors();
            columnInfos = Lists.newArrayListWithCapacity((int)projectedColumns.size());
            columnInfos = Lists.transform((List)projectedColumns, (Function)new Function<ColumnProjector, ColumnInfo>(){

                public ColumnInfo apply(ColumnProjector columnProjector) {
                    return new ColumnInfo(columnProjector.getName(), columnProjector.getExpression().getDataType().getSqlType());
                }
            });
        }
        catch (SQLException e) {
            LOG.error(String.format(" Error [%s] parsing SELECT query [%s] ", e.getMessage(), sqlQuery));
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    LOG.error("Error closing connection!!");
                    throw new RuntimeException(sqle);
                }
            }
        }
        return columnInfos;
    }
}

