/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySchemaParserFunction
implements Function<String, Pair<String, String>> {
    private static final Logger LOG = LoggerFactory.getLogger(QuerySchemaParserFunction.class);
    private final Configuration configuration;

    public QuerySchemaParserFunction(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configuration = configuration;
    }

    public Pair<String, String> apply(String selectStatement) {
        Preconditions.checkNotNull((Object)selectStatement);
        Preconditions.checkArgument((!selectStatement.isEmpty() ? 1 : 0) != 0, (Object)"Select Query is empty!!");
        Connection connection = null;
        try {
            connection = ConnectionUtil.getInputConnection((Configuration)this.configuration);
            Statement statement = connection.createStatement();
            PhoenixStatement pstmt = statement.unwrap(PhoenixStatement.class);
            QueryPlan queryPlan = pstmt.compileQuery(selectStatement);
            this.isValidStatement(queryPlan);
            String tableName = queryPlan.getTableRef().getTable().getName().getString();
            List projectedColumns = queryPlan.getProjector().getColumnProjectors();
            List columns = Lists.transform((List)projectedColumns, (Function)new Function<ColumnProjector, String>(){

                public String apply(ColumnProjector column) {
                    return column.getName();
                }
            });
            String columnsAsStr = Joiner.on((String)",").join((Iterable)columns);
            Pair pair = new Pair((Object)tableName, (Object)columnsAsStr);
            return pair;
        }
        catch (SQLException e) {
            LOG.error(String.format(" Error [%s] parsing SELECT query [%s] ", e.getMessage(), selectStatement));
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    LOG.error(" Error closing connection ");
                    throw new RuntimeException(sqle);
                }
            }
        }
    }

    private boolean isValidStatement(QueryPlan queryPlan) {
        if (queryPlan.getStatement().getOperation() != PhoenixStatement.Operation.QUERY) {
            throw new IllegalArgumentException("Query passed isn't a SELECT statement");
        }
        if (!queryPlan.getOrderBy().getOrderByExpressions().isEmpty() || queryPlan.getLimit() != null || queryPlan.getGroupBy() != null && !queryPlan.getGroupBy().isEmpty() || queryPlan.getStatement().isDistinct() || queryPlan.getStatement().isAggregate()) {
            throw new IllegalArgumentException("SELECT statement shouldn't contain DISTINCT or ORDER BY or LIMIT or GROUP BY expressions");
        }
        return true;
    }
}

