/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.pig.util.SqlQueryToColumnInfoFunction;
import org.apache.phoenix.pig.util.TypeUtil;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.pig.ResourceSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhoenixPigSchemaUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixPigSchemaUtil.class);

    private PhoenixPigSchemaUtil() {
    }

    public static ResourceSchema getResourceSchema(Configuration configuration, Dependencies dependencies) throws IOException {
        ResourceSchema schema = new ResourceSchema();
        try {
            List<ColumnInfo> columns = null;
            PhoenixConfigurationUtil.SchemaType schemaType = PhoenixConfigurationUtil.getSchemaType((Configuration)configuration);
            if (schemaType == PhoenixConfigurationUtil.SchemaType.QUERY) {
                String sqlQuery = PhoenixConfigurationUtil.getSelectStatement((Configuration)configuration);
                Preconditions.checkNotNull((Object)sqlQuery, (Object)"No Sql Query exists within the configuration");
                SqlQueryToColumnInfoFunction function = new SqlQueryToColumnInfoFunction(configuration);
                columns = function.apply(sqlQuery);
            } else if (schemaType == PhoenixConfigurationUtil.SchemaType.TABLE) {
                columns = dependencies.getSelectColumnMetadataList(configuration);
            }
            ResourceSchema.ResourceFieldSchema[] fields = new ResourceSchema.ResourceFieldSchema[columns.size()];
            int i = 0;
            for (ColumnInfo cinfo : columns) {
                int sqlType = cinfo.getSqlType();
                PDataType phoenixDataType = PDataType.fromTypeId((int)sqlType);
                byte pigType = TypeUtil.getPigDataTypeForPhoenixType(phoenixDataType);
                ResourceSchema.ResourceFieldSchema field = new ResourceSchema.ResourceFieldSchema();
                field.setType(pigType).setName(cinfo.getDisplayName());
                fields[i++] = field;
            }
            schema.setFields(fields);
        }
        catch (SQLException sqle) {
            LOG.error(String.format("Error: SQLException [%s] ", sqle.getMessage()));
            throw new IOException(sqle);
        }
        return schema;
    }

    public static ResourceSchema getResourceSchema(Configuration configuration) throws IOException {
        return PhoenixPigSchemaUtil.getResourceSchema(configuration, new Dependencies());
    }

    static class Dependencies {
        Dependencies() {
        }

        List<ColumnInfo> getSelectColumnMetadataList(Configuration configuration) throws SQLException {
            return PhoenixConfigurationUtil.getSelectColumnMetadataList((Configuration)configuration);
        }
    }
}

