/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.udf;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;

public class ReserveNSequence
extends EvalFunc<Long> {
    public static final String INVALID_TUPLE_MESSAGE = "Tuple should have correct fields(NumtoReserve,SequenceName).";
    public static final String EMPTY_SEQUENCE_NAME_MESSAGE = "Sequence name should be not null";
    public static final String EMPTY_ZK_MESSAGE = "ZKQuorum should be not null";
    public static final String INVALID_NUMBER_MESSAGE = "Number of Sequences to Reserve should be greater than 0";
    private final String zkQuorum;
    private final String tenantId;
    private Configuration configuration;
    Connection connection;

    public ReserveNSequence(@NonNull String zkQuorum, @Nullable String tenantId) {
        Preconditions.checkNotNull((Object)zkQuorum, (Object)EMPTY_ZK_MESSAGE);
        this.zkQuorum = zkQuorum;
        this.tenantId = tenantId;
    }

    public Long exec(Tuple input) throws IOException {
        Preconditions.checkArgument((input != null && input.size() >= 2 ? 1 : 0) != 0, (Object)INVALID_TUPLE_MESSAGE);
        Long numToReserve = (Long)input.get(0);
        Preconditions.checkArgument((numToReserve > 0L ? 1 : 0) != 0, (Object)INVALID_NUMBER_MESSAGE);
        String sequenceName = (String)input.get(1);
        Preconditions.checkNotNull((Object)sequenceName, (Object)EMPTY_SEQUENCE_NAME_MESSAGE);
        if (this.connection == null) {
            this.initConnection();
        }
        ResultSet rs = null;
        try {
            String sql = this.getNextNSequenceSelectStatement((long)numToReserve, sequenceName);
            rs = this.connection.createStatement().executeQuery(sql);
            Preconditions.checkArgument((boolean)rs.next());
            Long startIndex = rs.getLong(1);
            rs.close();
            this.connection.commit();
            return startIndex;
        }
        catch (SQLException e) {
            throw new IOException("Caught exception while processing row." + e.getMessage(), e);
        }
    }

    public void finish() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException("Caught exception while closing connection", e);
            }
        }
    }

    private void initConnection() throws IOException {
        UDFContext context = UDFContext.getUDFContext();
        this.configuration = new Configuration(context.getJobConf());
        this.configuration.set("hbase.zookeeper.quorum", this.zkQuorum);
        if (Strings.isNullOrEmpty((String)this.tenantId)) {
            this.configuration.unset("TenantId");
        } else {
            this.configuration.set("TenantId", this.tenantId);
        }
        try {
            this.connection = ConnectionUtil.getOutputConnection((Configuration)this.configuration);
        }
        catch (SQLException e) {
            throw new IOException("Caught exception while creating connection", e);
        }
    }

    private String getNextNSequenceSelectStatement(Long numToReserve, String sequenceName) {
        return "SELECT NEXT " + numToReserve + " VALUES FOR " + sequenceName;
    }
}

