/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.phoenix.mapreduce.PhoenixOutputFormat;
import org.apache.phoenix.mapreduce.PhoenixRecordWritable;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.pig.util.TableSchemaParserFunction;
import org.apache.phoenix.pig.util.TypeUtil;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixHBaseStorage
implements StoreFuncInterface {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixHBaseStorage.class);
    private static final Set<String> PROPS_TO_IGNORE = new HashSet<String>(Arrays.asList("CurrentSCN"));
    private Configuration config;
    private RecordWriter<NullWritable, PhoenixRecordWritable> writer;
    private List<ColumnInfo> columnInfo = null;
    private String contextSignature = null;
    private ResourceSchema schema;
    private long batchSize;
    private final PhoenixOutputFormat outputFormat = new PhoenixOutputFormat(PROPS_TO_IGNORE);
    private static final Options validOptions = new Options();
    private static final CommandLineParser parser = new GnuParser();
    private static final String SCHEMA = "_schema";
    private static final String PHOENIX_TABLE_NAME_SCHEME = "hbase://";
    private final CommandLine configuredOptions;
    private final String server;

    public PhoenixHBaseStorage(String server) throws ParseException {
        this(server, null);
    }

    public PhoenixHBaseStorage(String server, String optString) throws ParseException {
        PhoenixHBaseStorage.populateValidOptions();
        this.server = server;
        String[] optsArr = optString == null ? new String[]{} : optString.split(" ");
        try {
            this.configuredOptions = parser.parse(validOptions, optsArr);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("[-batchSize]", validOptions);
            throw e;
        }
        this.batchSize = Long.parseLong(this.configuredOptions.getOptionValue("batchSize"));
    }

    private static void populateValidOptions() {
        validOptions.addOption("batchSize", true, "Specify upsert batch size");
    }

    private Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(this.getClass(), new String[]{this.contextSignature});
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        String tableSchema = location.substring(PHOENIX_TABLE_NAME_SCHEME.length());
        TableSchemaParserFunction parseFunction = new TableSchemaParserFunction();
        Pair<String, String> pair = parseFunction.apply(tableSchema);
        PhoenixConfigurationUtil.loadHBaseConfiguration((Job)job);
        this.config = job.getConfiguration();
        this.config.set("hbase.zookeeper.quorum", this.server);
        String tableName = (String)pair.getFirst();
        String columns = (String)pair.getSecond();
        if (columns != null && columns.length() > 0) {
            PhoenixConfigurationUtil.setUpsertColumnNames((Configuration)this.config, (String[])columns.split(","));
        }
        PhoenixConfigurationUtil.setPhysicalTableName((Configuration)this.config, (String)tableName);
        PhoenixConfigurationUtil.setOutputTableName((Configuration)this.config, (String)tableName);
        PhoenixConfigurationUtil.setBatchSize((Configuration)this.config, (Long)this.batchSize);
        String serializedSchema = this.getUDFProperties().getProperty(this.contextSignature + SCHEMA);
        if (serializedSchema != null) {
            this.schema = (ResourceSchema)ObjectSerializer.deserialize((String)serializedSchema);
        }
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
        try {
            this.columnInfo = PhoenixConfigurationUtil.getUpsertColumnMetadataList((Configuration)this.config);
        }
        catch (SQLException sqle) {
            throw new IOException(sqle);
        }
    }

    public void putNext(Tuple t) throws IOException {
        ResourceSchema.ResourceFieldSchema[] fieldSchemas = this.schema == null ? null : this.schema.getFields();
        PhoenixRecordWritable record = new PhoenixRecordWritable(this.columnInfo);
        try {
            for (int i = 0; i < t.size(); ++i) {
                Object value = t.get(i);
                if (value == null) {
                    record.add(null);
                    continue;
                }
                ColumnInfo cinfo = this.columnInfo.get(i);
                byte type = fieldSchemas == null ? DataType.findType((Object)value) : fieldSchemas[i].getType();
                PDataType pDataType = PDataType.fromTypeId((int)cinfo.getSqlType());
                Object v = TypeUtil.castPigTypeToPhoenix(value, type, pDataType);
                record.add(v);
            }
            this.writer.write(null, (Object)record);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            LOG.error("Error on tuple {} .", (Object)t);
            throw new IOException(e);
        }
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.contextSignature = signature;
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    public OutputFormat getOutputFormat() throws IOException {
        return this.outputFormat;
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        this.schema = s;
        this.getUDFProperties().setProperty(this.contextSignature + SCHEMA, ObjectSerializer.serialize((Serializable)this.schema));
    }
}

