/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig;

import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.phoenix.mapreduce.PhoenixInputFormat;
import org.apache.phoenix.mapreduce.PhoenixRecordWritable;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.pig.util.PhoenixPigSchemaUtil;
import org.apache.phoenix.pig.util.QuerySchemaParserFunction;
import org.apache.phoenix.pig.util.TableSchemaParserFunction;
import org.apache.phoenix.pig.util.TypeUtil;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.PigException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhoenixHBaseLoader
extends LoadFunc
implements LoadMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixHBaseLoader.class);
    private static final String PHOENIX_TABLE_NAME_SCHEME = "hbase://table/";
    private static final String PHOENIX_QUERY_SCHEME = "hbase://query/";
    private static final String RESOURCE_SCHEMA_SIGNATURE = "phoenix.pig.schema";
    private Configuration config;
    private String tableName;
    private String selectQuery;
    private String zkQuorum;
    private PhoenixInputFormat<PhoenixRecordWritable> inputFormat;
    private RecordReader<NullWritable, PhoenixRecordWritable> reader;
    private String contextSignature;
    private ResourceSchema schema;

    public PhoenixHBaseLoader(String zkQuorum) {
        if (zkQuorum == null) {
            throw new NullPointerException();
        }
        if (zkQuorum.length() <= 0) {
            throw new IllegalStateException("Zookeeper quorum cannot be empty!");
        }
        this.zkQuorum = zkQuorum;
    }

    public void setLocation(String location, Job job) throws IOException {
        PhoenixConfigurationUtil.loadHBaseConfiguration((Job)job);
        Configuration configuration = job.getConfiguration();
        configuration.setBoolean("pig.noSplitCombination", true);
        this.initializePhoenixPigConfiguration(location, configuration);
    }

    private void initializePhoenixPigConfiguration(String location, Configuration configuration) throws IOException {
        if (this.config != null) {
            return;
        }
        this.config = configuration;
        this.config.set("hbase.zookeeper.quorum", this.zkQuorum);
        PhoenixConfigurationUtil.setInputClass((Configuration)this.config, PhoenixRecordWritable.class);
        Pair<String, String> pair = null;
        try {
            if (location.startsWith(PHOENIX_TABLE_NAME_SCHEME)) {
                String tableSchema = location.substring(PHOENIX_TABLE_NAME_SCHEME.length());
                TableSchemaParserFunction parseFunction = new TableSchemaParserFunction();
                pair = parseFunction.apply(tableSchema);
                PhoenixConfigurationUtil.setSchemaType((Configuration)this.config, (PhoenixConfigurationUtil.SchemaType)PhoenixConfigurationUtil.SchemaType.TABLE);
            } else if (location.startsWith(PHOENIX_QUERY_SCHEME)) {
                this.selectQuery = location.substring(PHOENIX_QUERY_SCHEME.length());
                QuerySchemaParserFunction queryParseFunction = new QuerySchemaParserFunction(this.config);
                pair = queryParseFunction.apply(this.selectQuery);
                PhoenixConfigurationUtil.setInputQuery((Configuration)this.config, (String)this.selectQuery);
                PhoenixConfigurationUtil.setSchemaType((Configuration)this.config, (PhoenixConfigurationUtil.SchemaType)PhoenixConfigurationUtil.SchemaType.QUERY);
            }
            this.tableName = (String)pair.getFirst();
            String selectedColumns = (String)pair.getSecond();
            if ((this.tableName == null || this.tableName.equals("")) && (this.selectQuery == null || this.selectQuery.equals(""))) {
                this.printUsage(location);
            }
            PhoenixConfigurationUtil.setInputTableName((Configuration)this.config, (String)this.tableName);
            if (selectedColumns != null && !selectedColumns.isEmpty()) {
                PhoenixConfigurationUtil.setSelectColumnNames((Configuration)this.config, (String[])selectedColumns.split(","));
            }
        }
        catch (IllegalArgumentException iae) {
            this.printUsage(location);
        }
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return location;
    }

    public InputFormat getInputFormat() throws IOException {
        if (this.inputFormat == null) {
            this.inputFormat = new PhoenixInputFormat();
            PhoenixConfigurationUtil.setInputClass((Configuration)this.config, PhoenixRecordWritable.class);
        }
        return this.inputFormat;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.reader = reader;
        String resourceSchemaAsStr = this.getValueFromUDFContext(this.contextSignature, RESOURCE_SCHEMA_SIGNATURE);
        if (resourceSchemaAsStr == null) {
            throw new IOException("Could not find schema in UDF context");
        }
        this.schema = (ResourceSchema)ObjectSerializer.deserialize((String)resourceSchemaAsStr);
    }

    public void setUDFContextSignature(String signature) {
        this.contextSignature = signature;
    }

    public Tuple getNext() throws IOException {
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            PhoenixRecordWritable record = (PhoenixRecordWritable)this.reader.getCurrentValue();
            if (record == null) {
                return null;
            }
            Tuple tuple = TypeUtil.transformToTuple(record, this.schema.getFields());
            return tuple;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException("Error while reading input", errCode, 16, (Throwable)e);
        }
    }

    private void printUsage(String location) throws PigException {
        String locationErrMsg = String.format("The input location in load statement should be of the form %s<table name> or %s<query>. Got [%s] ", PHOENIX_TABLE_NAME_SCHEME, PHOENIX_QUERY_SCHEME, location);
        LOG.error(locationErrMsg);
        throw new PigException(locationErrMsg);
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        if (this.schema != null) {
            return this.schema;
        }
        PhoenixConfigurationUtil.loadHBaseConfiguration((Job)job);
        Configuration configuration = job.getConfiguration();
        this.initializePhoenixPigConfiguration(location, configuration);
        this.schema = PhoenixPigSchemaUtil.getResourceSchema(this.config);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Resource Schema generated for location [%s] is [%s]", location, this.schema.toString()));
        }
        this.storeInUDFContext(this.contextSignature, RESOURCE_SCHEMA_SIGNATURE, ObjectSerializer.serialize((Serializable)this.schema));
        return this.schema;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    private void storeInUDFContext(String signature, String key, String value) {
        UDFContext udfContext = UDFContext.getUDFContext();
        Properties props = udfContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{signature});
        props.put(key, value);
    }

    private String getValueFromUDFContext(String signature, String key) {
        UDFContext udfContext = UDFContext.getUDFContext();
        Properties props = udfContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{signature});
        return props.getProperty(key);
    }
}

