/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import org.apache.phoenix.mapreduce.PhoenixRecordWritable;
import org.apache.phoenix.pig.util.TypeUtil;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TypeUtilTest {
    @Test
    public void testTransformToTuple() throws Exception {
        PhoenixRecordWritable record = (PhoenixRecordWritable)Mockito.mock(PhoenixRecordWritable.class);
        Object[] doubleArr = new Double[]{64.87, 89.96};
        PhoenixArray arr = PArrayDataType.instantiatePhoenixArray((PDataType)PDouble.INSTANCE, (Object[])doubleArr);
        LinkedHashMap values = Maps.newLinkedHashMap();
        values.put("first", "213123");
        values.put("second", 1231123);
        values.put("third", 31231231232131L);
        values.put("four", "bytearray".getBytes());
        values.put("five", arr);
        Mockito.when((Object)record.getResultMap()).thenReturn((Object)values);
        ResourceSchema.ResourceFieldSchema field = new ResourceSchema.ResourceFieldSchema().setType((byte)55);
        ResourceSchema.ResourceFieldSchema field1 = new ResourceSchema.ResourceFieldSchema().setType((byte)10);
        ResourceSchema.ResourceFieldSchema field2 = new ResourceSchema.ResourceFieldSchema().setType((byte)15);
        ResourceSchema.ResourceFieldSchema field3 = new ResourceSchema.ResourceFieldSchema().setType((byte)50);
        ResourceSchema.ResourceFieldSchema field4 = new ResourceSchema.ResourceFieldSchema().setType((byte)110);
        ResourceSchema.ResourceFieldSchema[] projectedColumns = new ResourceSchema.ResourceFieldSchema[]{field, field1, field2, field3, field4};
        Tuple t = TypeUtil.transformToTuple((PhoenixRecordWritable)record, (ResourceSchema.ResourceFieldSchema[])projectedColumns);
        Assert.assertEquals((long)15L, (long)DataType.findType((Object)t.get(2)));
        Assert.assertEquals((long)110L, (long)DataType.findType((Object)t.get(4)));
        Tuple doubleArrayTuple = (Tuple)t.get(4);
        Assert.assertEquals((long)2L, (long)doubleArrayTuple.size());
        field = new ResourceSchema.ResourceFieldSchema().setType((byte)70);
        field1 = new ResourceSchema.ResourceFieldSchema().setType((byte)65);
        values.clear();
        values.put("first", new BigDecimal(1.23123123123213E8));
        values.put("second", new BigInteger("1312313231312"));
        ResourceSchema.ResourceFieldSchema[] columns = new ResourceSchema.ResourceFieldSchema[]{field, field1};
        t = TypeUtil.transformToTuple((PhoenixRecordWritable)record, (ResourceSchema.ResourceFieldSchema[])columns);
        Assert.assertEquals((long)70L, (long)DataType.findType((Object)t.get(0)));
        Assert.assertEquals((long)65L, (long)DataType.findType((Object)t.get(1)));
    }
}

