/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.util;

import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.pig.util.TableSchemaParserFunction;
import org.junit.Assert;
import org.junit.Test;

public class TableSchemaParserFunctionTest {
    final TableSchemaParserFunction function = new TableSchemaParserFunction();

    @Test
    public void testTableSchema() {
        String loadTableSchema = "EMPLOYEE/col1,col2";
        Pair pair = this.function.apply("EMPLOYEE/col1,col2");
        Assert.assertEquals((Object)"EMPLOYEE", (Object)pair.getFirst());
        Assert.assertEquals((Object)pair.getSecond(), (Object)String.join((CharSequence)",", "col1", "col2"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyTableSchema() {
        String loadTableSchema = "";
        this.function.apply("");
    }

    @Test
    public void testTableOnlySchema() {
        String loadTableSchema = "EMPLOYEE";
        Pair pair = this.function.apply("EMPLOYEE");
        Assert.assertEquals((Object)"EMPLOYEE", (Object)pair.getFirst());
        Assert.assertNull((Object)pair.getSecond());
    }
}

